/*
 * Decompiled with CFR 0.152.
 */
package morph.common.morph;

import cpw.mods.fml.common.FMLCommonHandler;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import morph.common.Morph;
import morph.common.morph.MorphState;
import morph.common.packet.PacketMorphStates;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.util.FakePlayer;

public class MorphHandler {
    public static HashMap<Class<? extends EntityLivingBase>, ArrayList<String>> stripperMappings = new HashMap();

    public static MorphState addOrGetMorphState(ArrayList<MorphState> states, MorphState state) {
        int pos = -1;
        boolean isFavourite = state.isFavourite;
        for (int i = states.size() - 1; i >= 0; --i) {
            MorphState mState = states.get(i);
            if (!mState.identifier.equalsIgnoreCase(state.identifier) && (state.playerMorph.equalsIgnoreCase("") || !mState.playerMorph.equalsIgnoreCase(state.playerMorph))) continue;
            isFavourite = mState.isFavourite;
            states.remove(i);
            pos = i;
        }
        if (state.playerName.equalsIgnoreCase(state.playerMorph) && !state.playerMorph.equalsIgnoreCase("")) {
            isFavourite = true;
            pos = 0;
        }
        if (pos != -1) {
            states.add(pos, state);
        } else {
            states.add(state);
        }
        state.isFavourite = isFavourite;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && Morph.config.getInt("sortMorphs") == 2) {
            Collections.sort(states);
        }
        return state;
    }

    public static void updatePlayerOfMorphStates(EntityPlayerMP player, MorphState morphState, boolean clear) {
        ArrayList<MorphState> states;
        if (player.field_71135_a == null || player.getClass() == FakePlayer.class) {
            return;
        }
        if (morphState == null) {
            states = Morph.proxy.tickHandlerServer.getPlayerMorphs(player.field_70170_p, (EntityPlayer)player);
        } else {
            states = new ArrayList<MorphState>();
            states.add(morphState);
        }
        PacketHandler.sendToPlayer(Morph.channels, (AbstractPacket)new PacketMorphStates(clear, states), (EntityPlayer)player);
    }

    public static MorphState getMorphState(EntityPlayerMP player, String identifier) {
        ArrayList<MorphState> states = Morph.proxy.tickHandlerServer.getPlayerMorphs(player.field_70170_p, (EntityPlayer)player);
        for (MorphState state : states) {
            if (!state.identifier.equalsIgnoreCase(identifier)) continue;
            return state;
        }
        return null;
    }

    public static void reorderMorphs(String starter, LinkedHashMap<String, ArrayList<MorphState>> morphMap) {
        if (Morph.config.getInt("sortMorphs") == 1 || Morph.config.getInt("sortMorphs") == 2) {
            ArrayList<String> order = new ArrayList<String>();
            Iterator<String> ite = morphMap.keySet().iterator();
            while (ite.hasNext()) {
                order.add(ite.next());
            }
            Collections.sort(order);
            order.remove(starter);
            order.add(0, starter);
            LinkedHashMap<String, ArrayList<MorphState>> bufferList = new LinkedHashMap<String, ArrayList<MorphState>>(morphMap);
            morphMap.clear();
            for (int i = 0; i < order.size(); ++i) {
                morphMap.put((String)order.get(i), bufferList.get(order.get(i)));
            }
        }
    }

    public static ArrayList<String> getNBTTagsToStrip(EntityLivingBase ent) {
        ArrayList<String> tagsToStrip = new ArrayList<String>();
        for (Class<?> clz = ent.getClass(); clz != EntityLivingBase.class; clz = clz.getSuperclass()) {
            tagsToStrip.addAll(MorphHandler.getNBTTagsToStrip(clz));
        }
        return tagsToStrip;
    }

    public static ArrayList<String> getNBTTagsToStrip(Class<? extends EntityLivingBase> clz) {
        ArrayList<String> list = stripperMappings.get(clz);
        if (list == null) {
            list = new ArrayList();
            stripperMappings.put(clz, list);
        }
        return list;
    }
}

