/*
 * Decompiled with CFR 0.152.
 */
package morph.common.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import morph.api.Ability;
import morph.client.morph.MorphInfoClient;
import morph.common.Morph;
import morph.common.ability.AbilityHandler;
import morph.common.morph.MorphState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class PacketMorphInfo
extends AbstractPacket {
    public String playerName;
    public boolean morphing;
    public int morphProgress;
    public boolean hasPrevState;
    public boolean hasNextState;
    public NBTTagCompound prevTag;
    public NBTTagCompound nextTag;
    public boolean flying;

    public PacketMorphInfo() {
    }

    public PacketMorphInfo(String playerName, boolean morphing, int morphProgress, boolean hasPrevState, boolean hasNextState, NBTTagCompound prevTag, NBTTagCompound nextTag, boolean flying) {
        this.playerName = playerName;
        this.morphing = morphing;
        this.morphProgress = morphProgress;
        this.hasPrevState = hasPrevState;
        this.hasNextState = hasNextState;
        this.prevTag = prevTag;
        this.nextTag = nextTag;
        this.flying = flying;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerName);
        buffer.writeBoolean(this.hasPrevState);
        if (this.hasPrevState) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.prevTag);
        }
        buffer.writeBoolean(this.hasNextState);
        if (this.hasNextState) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.nextTag);
        }
        buffer.writeBoolean(this.morphing);
        buffer.writeInt(this.morphProgress);
        buffer.writeBoolean(this.flying);
    }

    public void readFrom(ByteBuf buffer, Side side) {
        this.prevTag = new NBTTagCompound();
        this.nextTag = new NBTTagCompound();
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.hasPrevState = buffer.readBoolean();
        if (this.hasPrevState) {
            this.prevTag = ByteBufUtils.readTag((ByteBuf)buffer);
        }
        this.hasNextState = buffer.readBoolean();
        if (this.hasNextState) {
            this.nextTag = ByteBufUtils.readTag((ByteBuf)buffer);
        }
        this.morphing = buffer.readBoolean();
        this.morphProgress = buffer.readInt();
        this.flying = buffer.readBoolean();
    }

    public void execute(Side side, EntityPlayer player) {
        if (side.isClient()) {
            this.handleClient(side, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(Side side, EntityPlayer player) {
        String name1;
        Ability clone3;
        ArrayList<Ability> newAbilities;
        EntityPlayer player1;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.hasNextState && (player1 = mc.field_71441_e.func_72924_a(this.playerName)) != null && !player1.func_70651_bq().isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : player1.func_70651_bq()) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            this.nextTag.func_74782_a("ActiveEffects", (NBTBase)nbttaglist);
        }
        MorphState prevState = new MorphState((World)mc.field_71441_e, this.playerName, "", null, true);
        MorphState nextState = new MorphState((World)mc.field_71441_e, this.playerName, "", null, true);
        prevState.readTag((World)mc.field_71441_e, this.prevTag);
        nextState.readTag((World)mc.field_71441_e, this.nextTag);
        if (prevState.entInstance != null && prevState.entInstance != mc.field_71439_g) {
            prevState.entInstance.field_70145_X = true;
        }
        if (nextState.entInstance != null && nextState.entInstance != mc.field_71439_g) {
            nextState.entInstance.field_70145_X = true;
        }
        MorphInfoClient info = new MorphInfoClient(this.playerName, prevState, nextState);
        info.setMorphing(this.morphing);
        info.morphProgress = this.morphProgress;
        MorphInfoClient info1 = Morph.proxy.tickHandlerClient.playerMorphInfo.get(this.playerName);
        if (info1 != null) {
            info.morphAbilities = info1.morphAbilities;
            newAbilities = AbilityHandler.getEntityAbilities(info.nextState.entInstance.getClass());
            for (Ability ability : newAbilities) {
                if (!ability.requiresInactiveClone()) continue;
                try {
                    clone3 = ability.clone();
                    clone3.inactive = true;
                    info.morphAbilities.add(clone3);
                }
                catch (Exception clone2) {}
            }
        } else {
            newAbilities = AbilityHandler.getEntityAbilities(info.nextState.entInstance.getClass());
            info.morphAbilities = new ArrayList();
            for (Ability ability : newAbilities) {
                try {
                    clone3 = ability.clone();
                    info.morphAbilities.add(clone3);
                }
                catch (Exception clone3) {}
            }
        }
        Morph.proxy.tickHandlerClient.playerMorphInfo.put(this.playerName, info);
        info.flying = this.flying;
        if (Morph.config.getInt("sortMorphs") == 3 && info.playerName.equalsIgnoreCase(mc.field_71439_g.func_70005_c_()) && (name1 = info.nextState.entInstance.func_70005_c_()) != null) {
            ArrayList<String> order = new ArrayList<String>();
            Iterator<String> ite = Morph.proxy.tickHandlerClient.playerMorphCatMap.keySet().iterator();
            while (ite.hasNext()) {
                order.add(ite.next());
            }
            order.remove(name1);
            order.remove(mc.field_71439_g.func_70005_c_());
            order.add(0, name1);
            order.add(0, mc.field_71439_g.func_70005_c_());
            LinkedHashMap<String, ArrayList<MorphState>> bufferList = new LinkedHashMap<String, ArrayList<MorphState>>(Morph.proxy.tickHandlerClient.playerMorphCatMap);
            Morph.proxy.tickHandlerClient.playerMorphCatMap.clear();
            for (int i = 0; i < order.size(); ++i) {
                Morph.proxy.tickHandlerClient.playerMorphCatMap.put((String)order.get(i), bufferList.get(order.get(i)));
            }
        }
    }
}

