/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.recipe;

import java.util.UUID;
import net.darkhax.bookshelf.lib.util.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class PlayerRecipe
implements IRecipe {
    private String[] playerNames;
    private UUID[] playerIDs;
    private IRecipe recipe;

    public PlayerRecipe(String username, IRecipe recipe) {
        this(new String[]{username}, recipe);
    }

    public PlayerRecipe(String[] usernames, IRecipe recipe) {
        this.playerNames = usernames;
        this.recipe = recipe;
    }

    public PlayerRecipe(UUID playerID, IRecipe recipe) {
        this(new UUID[]{playerID}, recipe);
    }

    public PlayerRecipe(UUID[] playerIDs, IRecipe recipe) {
        this.playerIDs = playerIDs;
        this.recipe = recipe;
    }

    public boolean func_77569_a(InventoryCrafting crafting, World world) {
        EntityPlayer player = PlayerUtils.getPlayerFromCrafting(crafting);
        boolean isValidPlayer = false;
        if (player != null) {
            if (this.playerNames != null) {
                for (String playerName : this.playerNames) {
                    if (!player.func_70005_c_().equalsIgnoreCase(playerName)) continue;
                    isValidPlayer = true;
                    break;
                }
            }
            if (this.playerIDs != null && !isValidPlayer) {
                for (UUID playerID : this.playerIDs) {
                    if (!player.func_110124_au().equals(playerID)) continue;
                    isValidPlayer = true;
                    break;
                }
            }
        }
        return isValidPlayer && this.recipe.func_77569_a(crafting, world);
    }

    public ItemStack func_77572_b(InventoryCrafting crafting) {
        return this.recipe.func_77572_b(crafting);
    }

    public int func_77570_a() {
        return this.recipe.func_77570_a();
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }
}

