/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.api;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.mapping.MapMatrix;
import jaredbgreat.dldungeons.rooms.Room;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public class DLDEvent
extends Event {

    public static class PlaceDungeonFinish
    extends PlaceDungeon {
        private final Dungeon dungeon;

        public PlaceDungeonFinish(Random random, int chunkX, int chunkZ, World world, Dungeon dungeon) {
            super(random, chunkX, chunkZ, world);
            this.dungeon = dungeon;
        }

        public Dungeon getDungeon() {
            return this.dungeon;
        }
    }

    @Cancelable
    public static class PlaceDungeonBegin
    extends PlaceDungeon {
        public PlaceDungeonBegin(Random random, int chunkX, int chunkZ, World world) {
            super(random, chunkX, chunkZ, world);
        }
    }

    @Cancelable
    public static abstract class PlaceDungeon
    extends DLDEvent {
        protected final Random random;
        protected final int chunkX;
        protected final int chunkZ;
        protected final World world;

        public PlaceDungeon(Random random, int chunkX, int chunkZ, World world) {
            this.random = random;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.world = world;
        }

        public Random getRandom() {
            return this.random;
        }

        public int getChunkX() {
            return this.chunkX;
        }

        public int getChunkZ() {
            return this.chunkZ;
        }

        public World getWorld() {
            return this.world;
        }
    }

    public static class AfterBuild
    extends BeforeBuild {
        public AfterBuild(MapMatrix mapMatrix, int shiftX, int shiftZ, boolean flooded) {
            super(mapMatrix, shiftX, shiftZ, flooded);
        }
    }

    public static class BeforeBuild
    extends DLDEvent {
        protected final MapMatrix mapMatrix;
        protected final int shiftX;
        protected final int shiftZ;
        protected final boolean flooded;

        public BeforeBuild(MapMatrix mapMatrix, int shiftX, int shiftZ, boolean flooded) {
            this.mapMatrix = mapMatrix;
            this.shiftX = shiftX;
            this.shiftZ = shiftZ;
            this.flooded = flooded;
        }

        public MapMatrix getMapMatrix() {
            return this.mapMatrix;
        }

        public int getShiftX() {
            return this.shiftX;
        }

        public int getShiftZ() {
            return this.shiftZ;
        }

        public boolean isFlooded() {
            return this.flooded;
        }
    }

    @Cancelable
    public static class AddEntrance
    extends DungeonRoom {
        public AddEntrance(Dungeon dungeon, Room room) {
            super(dungeon, room);
        }
    }

    @Cancelable
    public static class AddTileEntitiesToRoom
    extends DungeonRoom {
        public AddTileEntitiesToRoom(Dungeon dungeon, Room room) {
            super(dungeon, room);
        }
    }

    public static class AfterChestTileEntity
    extends DLDEvent {
        private final World world;
        private final TileEntityChest contents;
        private final int which;
        private final int x;
        private final int y;
        private final int z;
        private final Random random;
        private final int level;

        public AfterChestTileEntity(World world, TileEntityChest contents, int which, int x, int y, int z, Random random, int level) {
            this.world = world;
            this.contents = contents;
            this.which = which;
            this.x = x;
            this.y = y;
            this.z = z;
            this.random = random;
            this.level = level;
        }

        public World getWorld() {
            return this.world;
        }

        public TileEntityChest getContents() {
            return this.contents;
        }

        public int getWhich() {
            return this.which;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public Random getRandom() {
            return this.random;
        }

        public int getLevel() {
            return this.level;
        }
    }

    @Cancelable
    public static class BeforePlaceSpawner
    extends DLDEvent {
        private final World world;
        private final int x;
        private final int y;
        private final int z;
        private final String mob;

        public BeforePlaceSpawner(World world, int x, int y, int z, String mob) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.mob = mob;
        }

        public World getWorld() {
            return this.world;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public String getMob() {
            return this.mob;
        }
    }

    @Cancelable
    public static class AddChestBlocksToRoom
    extends DungeonRoom {
        public AddChestBlocksToRoom(Dungeon dungeon, Room room) {
            super(dungeon, room);
        }
    }

    public static class DungeonRoom
    extends DLDEvent {
        protected final Dungeon dungeon;
        protected final Room room;

        public DungeonRoom(Dungeon dungeon, Room room) {
            this.dungeon = dungeon;
            this.room = room;
        }

        public Dungeon getDungeon() {
            return this.dungeon;
        }

        public Room getRoom() {
            return this.room;
        }
    }

    @Cancelable
    public static class PlaceBlock
    extends Place {
        protected final Block block;

        public PlaceBlock(World world, int x, int y, int z, Block block) {
            super(world, x, y, z);
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }
    }

    @Cancelable
    public static class PlaceDBlock
    extends Place {
        protected final DBlock block;

        public PlaceDBlock(World world, int x, int y, int z, DBlock block) {
            super(world, x, y, z);
            this.block = block;
        }

        public DBlock getBlock() {
            return this.block;
        }
    }

    @Cancelable
    public static abstract class Place
    extends DLDEvent {
        protected final World world;
        protected int blockX;
        protected int blockY;
        protected int blockZ;

        public Place(World world, int x, int y, int z) {
            this.world = world;
            this.blockX = x;
            this.blockX = y;
            this.blockX = y;
        }

        public World getWorld() {
            return this.world;
        }

        public int getX() {
            return this.blockX;
        }

        public int getY() {
            return this.blockY;
        }

        public int getZ() {
            return this.blockZ;
        }

        public void setX(int x) {
            this.blockX = x;
        }

        public void setY(int y) {
            this.blockY = y;
        }

        public void setZ(int z) {
            this.blockY = z;
        }
    }
}

