/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.debug.Logging;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public final class DBlock {
    private final String id;
    private final Block block;
    private final int meta;
    public static final Block spawner = Blocks.field_150474_ac;
    public static final Block chest = Blocks.field_150486_ae;
    public static final Block portal1 = Blocks.field_150378_br;
    public static final Block portal2 = Blocks.field_150384_bq;
    public static final Block quartz = Blocks.field_150371_ca;
    public static final Block lapis = Blocks.field_150368_y;
    public static final Block water = Blocks.field_150355_j;
    public static final Block air = Blocks.field_150350_a;
    public static final ArrayList<DBlock> registry = new ArrayList();

    private DBlock(String id) {
        this.id = id;
        StringTokenizer nums = new StringTokenizer(id, "({[]})");
        this.block = Block.func_149684_b((String)nums.nextToken());
        if (this.block == null) {
            Logging.LogError("[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).");
        }
        this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
    }

    private DBlock(String id, float version) throws NoSuchElementException {
        StringTokenizer nums;
        this.id = id;
        if ((double)version < 1.7) {
            nums = new StringTokenizer(id, "({[]})");
            this.block = Block.func_149684_b((String)nums.nextToken());
            this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
        } else {
            nums = new StringTokenizer(id, ":({[]})");
            this.block = GameRegistry.findBlock((String)nums.nextToken(), (String)nums.nextToken());
            this.meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
        }
        if (this.block == null) {
            String error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).";
            Logging.LogError(error);
            throw new NoSuchElementException(error);
        }
    }

    public void placeNoMeta(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_147449_b(x, y, z, this.block);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDBlock(world, x, y, z, this))) {
            return;
        }
    }

    public void place(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_147465_d(x, y, z, this.block, this.meta, 2);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDBlock(world, x, y, z, this))) {
            return;
        }
    }

    public static void place(World world, int x, int y, int z, int block) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            registry.get(block).place(world, x, y, z);
        }
    }

    public static int add(String id) {
        DBlock block = new DBlock(id);
        if (!registry.contains(block)) {
            registry.add(block);
        }
        return registry.indexOf(block);
    }

    public static int add(String id, float version) throws NoSuchElementException {
        DBlock block = new DBlock(id, version);
        if (!registry.contains(block)) {
            registry.add(block);
        }
        return registry.indexOf(block);
    }

    public static boolean placeBlock(World world, int x, int y, int z, Block block) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return false;
        }
        world.func_147449_b(x, y, z, block);
        return !MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceBlock(world, x, y, z, block));
    }

    public static void placeBlock(World world, int x, int y, int z, Block block, int a, int b) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            world.func_147465_d(x, y, z, block, a, b);
        }
    }

    public static void deleteBlock(World world, int x, int y, int z) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public static void deleteBlock(World world, int x, int y, int z, boolean flooded) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (flooded) {
            world.func_147449_b(x, y, z, water);
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    public static void placeChest(World world, int x, int y, int z) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            world.func_147465_d(x, y, z, chest, 0, 2);
        }
    }

    public static void placeSpawner(World world, int x, int y, int z, String mob) {
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.BeforePlaceSpawner(world, x, y, z, mob))) {
            return;
        }
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        DBlock.placeBlock(world, x, y, z, spawner);
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        theSpawner.func_145881_a().func_98272_a(mob);
    }

    public static boolean isGroundBlock(World world, int x, int y, int z) {
        Material mat = world.func_147439_a(x, y, z).func_149688_o();
        return mat == Material.field_151577_b || mat == Material.field_151573_f || mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151576_e || mat == Material.field_151571_B || mat == Material.field_151589_v;
    }

    public static boolean isProtectedBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == chest || block == spawner || block == portal1 || block == portal2 || block instanceof BlockChest || block instanceof BlockEndPortalFrame || block instanceof BlockMobSpawner;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DBlock)) {
            return false;
        }
        return this.id.hashCode() == ((DBlock)other).id.hashCode();
    }

    public int hashCode() {
        int a = Block.func_149682_b((Block)this.block);
        a = (a << 4) + this.meta;
        a += a << 16;
        return a;
    }
}

