/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.nbt.tags;

import jaredbgreat.dldungeons.nbt.NBTType;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class NBTIntArray
extends ITag {
    public final int[] data;

    NBTIntArray(String label, String name, String data) {
        super(label, name);
        ArrayList<Integer> tmp = this.parseData(data);
        this.data = new int[tmp.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = tmp.get(i);
        }
    }

    NBTIntArray(String label, String name, int[] data) {
        super(label, name);
        this.data = data;
    }

    @Override
    public void write(NBTTagCompound cmp) {
        cmp.func_74783_a(this.name, this.data);
    }

    @Override
    public void write(NBTTagList cmp) {
        cmp.func_74742_a((NBTBase)new NBTTagIntArray(this.data));
    }

    private ArrayList<Integer> parseData(String in) {
        StringTokenizer tokens = new StringTokenizer(in, "{,}");
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        while (tokens.hasMoreTokens()) {
            tmp.add(Integer.getInteger(tokens.nextToken()));
        }
        return tmp;
    }

    @Override
    public NBTType getType() {
        return NBTType.INT_ARRAY;
    }
}

