/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootList;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class TreasureChest
extends BasicChest {
    private static int A2 = 3;
    private static int B2 = 2;
    private static int C2 = 2;
    static ArrayList<Integer> slots = new ArrayList();
    int slot;

    public TreasureChest(int x, int y, int z, int level) {
        super(x, y, z, level);
    }

    @Override
    public void place(World world, int x, int y, int z, Random random) {
        ItemStack treasure;
        int i;
        Collections.shuffle(slots, random);
        this.slot = 0;
        this.level += random.nextInt(2);
        if (this.level >= 7) {
            this.level = 6;
        }
        DBlock.placeChest(world, x, y, z);
        if (world.func_147439_a(x, y, z) != DBlock.chest) {
            return;
        }
        TileEntityChest contents = (TileEntityChest)world.func_147438_o(x, y, z);
        if (ConfigHandler.vanillaLoot) {
            this.vanillaChest(contents, random);
        }
        int num = random.nextInt(A2 + this.level / B2) + C2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.getLoot(LootType.HEAL, this.level, random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
        num = random.nextInt(A2 + this.level / B2) + C2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.getLoot(LootType.GEAR, this.level, random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
        num = random.nextInt(A2 + this.level / B2) + C2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.getLoot(LootType.LOOT, this.level + 1 + random.nextInt(2), random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
        if (random.nextInt(7) < this.level) {
            treasure = this.level >= 6 ? LootList.special.getLoot(random).getStack(random) : LootList.discs.getLoot(random).getStack(random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
    }

    private void vanillaChest(TileEntityChest chest, Random random) {
        ChestGenHooks chinf;
        int which = random.nextInt(4);
        switch (which) {
            case 0: {
                chinf = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
                break;
            }
            case 1: {
                chinf = ChestGenHooks.getInfo((String)"pyramidJungleChest");
                break;
            }
            default: {
                chinf = ChestGenHooks.getInfo((String)"dungeonChest");
            }
        }
        WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chinf.getItems(random), (IInventory)chest, (int)chinf.getCount(random));
    }

    private boolean validSlot(int slot) {
        return slot >= 0 && slot < 27;
    }

    public static void initSlots() {
        for (int i = 0; i < 27; ++i) {
            slots.add(new Integer(i));
        }
    }

    public static void setTreasureLootNumbers(int a, int b, int c) {
        A2 = a;
        B2 = b;
        C2 = c;
    }
}

