/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner.mapping;

import cpw.mods.fml.common.eventhandler.Event;
import jaredbgreat.dldungeons.DoomlikeDungeons;
import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.astar.Step;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.themes.ThemeFlags;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class MapMatrix {
    private static final Block lapis = Block.func_149684_b((String)"lapis_block");
    private static final Block slab = Block.func_149684_b((String)"double_stone_slab");
    private static final Block gold = Block.func_149684_b((String)"gold_block");
    private static final Block glass = Block.func_149684_b((String)"glass");
    private static boolean drawFlyingMap = false;
    public final World world;
    public final int chunkX;
    public final int chunkZ;
    public final int origenX;
    public final int origenZ;
    public byte[][] ceilY;
    public byte[][] floorY;
    public byte[][] nCeilY;
    public byte[][] nFloorY;
    public int[][] ceiling;
    public int[][] wall;
    public int[][] floor;
    public int[][] room;
    public boolean[][] isWall;
    public boolean[][] isFence;
    public boolean[][] hasLiquid;
    public boolean[][] isDoor;
    public Step[][] nodedge;
    public boolean[][] astared;

    public MapMatrix(int width, World world, int chunkX, int chunkZ) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.origenX = chunkX * 16 - width / 2 + 8;
        this.origenZ = chunkZ * 16 - width / 2 + 8;
        this.ceilY = new byte[width][width];
        this.floorY = new byte[width][width];
        this.nCeilY = new byte[width][width];
        this.nFloorY = new byte[width][width];
        this.room = new int[width][width];
        this.ceiling = new int[width][width];
        this.wall = new int[width][width];
        this.floor = new int[width][width];
        this.isWall = new boolean[width][width];
        this.isFence = new boolean[width][width];
        this.hasLiquid = new boolean[width][width];
        this.isDoor = new boolean[width][width];
        this.nodedge = new Step[width][width];
        this.astared = new boolean[width][width];
    }

    public void build(Dungeon dungeon) {
        DoomlikeDungeons.profiler.startTask("Building Dungeon in World");
        DoomlikeDungeons.profiler.startTask("Building Dungeon architecture");
        int shiftX = this.chunkX * 16 - this.room.length / 2 + 8;
        int shiftZ = this.chunkZ * 16 - this.room.length / 2 + 8;
        boolean flooded = dungeon.theme.flags.contains((Object)ThemeFlags.WATER);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.BeforeBuild(this, shiftX, shiftZ, flooded));
        for (int i = 0; i < this.room.length; ++i) {
            for (int j = 0; j < this.room.length; ++j) {
                int k;
                if (this.room[i][j] == 0) continue;
                Room theRoom = (Room)dungeon.rooms.get(this.room[i][j]);
                if (drawFlyingMap) {
                    if (this.astared[i][j]) {
                        DBlock.placeBlock(this.world, shiftX + i, 96, shiftZ + j, lapis);
                    } else if (this.isDoor[i][j]) {
                        DBlock.placeBlock(this.world, shiftX + i, 96, shiftZ + j, slab);
                    } else if (this.isWall[i][j]) {
                        DBlock.placeBlock(this.world, shiftX + i, 96, shiftZ + j, gold);
                    } else {
                        DBlock.placeBlock(this.world, shiftX + i, 96, shiftZ + j, glass);
                    }
                }
                if (this.nFloorY[i][j] < this.floorY[i][j]) {
                    for (k = this.nFloorY[i][j]; k < this.floorY[i][j]; ++k) {
                        if (!this.noLowDegenerate(theRoom, shiftX + i, k, shiftZ + j, i, j)) continue;
                        DBlock.place(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                    }
                }
                if (this.nFloorY[i][j] > this.floorY[i][j]) {
                    for (k = this.floorY[i][j]; k < this.nFloorY[i][j]; ++k) {
                        if (!this.noLowDegenerate(theRoom, shiftX + i, k, shiftZ + j, i, j)) continue;
                        DBlock.place(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                    }
                }
                if (this.noLowDegenerate(theRoom, shiftX + i, this.floorY[i][j] - 1, shiftZ + j, i, j)) {
                    DBlock.place(this.world, shiftX + i, this.floorY[i][j] - 1, shiftZ + j, this.floor[i][j]);
                    if (dungeon.theme.buildFoundation) {
                        int below;
                        int n = below = this.nFloorY[i][j] < this.floorY[i][j] ? this.nFloorY[i][j] - 1 : this.floorY[i][j] - 2;
                        while (!DBlock.isGroundBlock(this.world, shiftX + i, below, shiftZ + j)) {
                            DBlock.place(this.world, shiftX + i, below, shiftZ + j, dungeon.floorBlock);
                            if (--below >= 0) continue;
                        }
                    }
                }
                if (!theRoom.sky && this.noHighDegenerate(theRoom, shiftX + i, this.ceilY[i][j] + 1, shiftZ + j)) {
                    DBlock.place(this.world, shiftX + i, this.ceilY[i][j] + 1, shiftZ + j, this.ceiling[i][j]);
                }
                for (k = this.roomBottom(i, j); k <= this.ceilY[i][j]; ++k) {
                    if (!this.isWall[i][j]) {
                        DBlock.deleteBlock(this.world, shiftX + i, k, shiftZ + j, flooded);
                        continue;
                    }
                    if (!this.noHighDegenerate(theRoom, shiftX + i, k, shiftZ + j)) continue;
                    DBlock.place(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                }
                for (k = this.nCeilY[i][j]; k < this.ceilY[i][j]; ++k) {
                    if (!this.noHighDegenerate(theRoom, shiftX + i, k, shiftZ + j)) continue;
                    DBlock.place(this.world, shiftX + i, k, shiftZ + j, this.wall[i][j]);
                }
                if (this.isFence[i][j]) {
                    DBlock.place(this.world, shiftX + i, this.floorY[i][j], shiftZ + j, dungeon.fenceBlock);
                }
                if (this.isDoor[i][j]) {
                    DBlock.deleteBlock(this.world, shiftX + i, this.floorY[i][j], shiftZ + j, flooded);
                    DBlock.deleteBlock(this.world, shiftX + i, this.floorY[i][j] + 1, shiftZ + j, flooded);
                    DBlock.deleteBlock(this.world, shiftX + i, this.floorY[i][j] + 2, shiftZ + j, flooded);
                }
                if (!this.hasLiquid[i][j] || this.isWall[i][j] || this.isDoor[i][j] || this.world.func_147437_c(shiftX + i, this.floorY[i][j] - 1, shiftZ + j)) continue;
                DBlock.place(this.world, shiftX + i, this.floorY[i][j], shiftZ + j, theRoom.liquidBlock);
            }
        }
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.AfterBuild(this, shiftX, shiftZ, flooded));
        DoomlikeDungeons.profiler.endTask("Building Dungeon architecture");
        dungeon.addEntrances();
        DoomlikeDungeons.profiler.endTask("Building Dungeon in World");
    }

    private boolean noHighDegenerate(Room theRoom, int x, int y, int z) {
        return !theRoom.degenerate || !this.world.func_147437_c(x, y, z);
    }

    private boolean noLowDegenerate(Room theRoom, int x, int y, int z, int i, int j) {
        return !theRoom.degenerateFloors || !this.world.func_147437_c(x, y, z) || this.astared[i][j];
    }

    private int roomBottom(int i, int j) {
        int b = this.floorY[i][j];
        if (this.isWall[i][j] && !this.isDoor[i][j]) {
            --b;
        }
        return b;
    }

    public static void setDrawFlyingMap(boolean value) {
        drawFlyingMap = value;
    }
}

