/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.rooms;

import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.rooms.Cave;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.rooms.RoomType;

public abstract class AbstractRoom {
    public int wallBlock1;
    public int floorBlock;
    public int cielingBlock;
    public int fenceBlock;
    public int pillarBlock;
    public int liquidBlock;
    public int caveBlock;
    public boolean degenerate;
    public boolean degenerateFloors;
    public boolean sky;
    public boolean fenced;

    protected AbstractRoom() {
        this.wallBlock1 = 0;
        this.floorBlock = 0;
        this.cielingBlock = 0;
        this.fenceBlock = 0;
        this.pillarBlock = 0;
        this.liquidBlock = 0;
    }

    protected AbstractRoom(Dungeon dungeon, AbstractRoom previous) {
        if (previous != null && !dungeon.variability.use(dungeon.random)) {
            this.wallBlock1 = previous.wallBlock1;
            this.floorBlock = previous.floorBlock;
            this.cielingBlock = previous.cielingBlock;
            this.fenceBlock = previous.fenceBlock;
            this.pillarBlock = previous.pillarBlock;
            this.liquidBlock = previous.liquidBlock;
            this.caveBlock = previous.caveBlock;
        } else if (dungeon.variability.use(dungeon.random)) {
            if (dungeon.variability.use(dungeon.random)) {
                this.wallBlock1 = dungeon.theme.walls[dungeon.random.nextInt(dungeon.theme.walls.length)];
                this.floorBlock = dungeon.theme.floors[dungeon.random.nextInt(dungeon.theme.floors.length)];
                this.cielingBlock = dungeon.theme.ceilings[dungeon.random.nextInt(dungeon.theme.ceilings.length)];
                this.fenceBlock = dungeon.theme.fencing[dungeon.random.nextInt(dungeon.theme.fencing.length)];
                this.pillarBlock = dungeon.theme.pillarBlock[dungeon.random.nextInt(dungeon.theme.pillarBlock.length)];
                this.liquidBlock = dungeon.theme.liquid[dungeon.random.nextInt(dungeon.theme.liquid.length)];
                this.caveBlock = dungeon.theme.caveWalls[dungeon.random.nextInt(dungeon.theme.caveWalls.length)];
            } else {
                this.wallBlock1 = !dungeon.variability.use(dungeon.random) ? dungeon.wallBlock1 : dungeon.theme.walls[dungeon.random.nextInt(dungeon.theme.walls.length)];
                this.floorBlock = !dungeon.variability.use(dungeon.random) ? dungeon.floorBlock : dungeon.theme.floors[dungeon.random.nextInt(dungeon.theme.floors.length)];
                this.cielingBlock = !dungeon.variability.use(dungeon.random) ? dungeon.cielingBlock : dungeon.theme.ceilings[dungeon.random.nextInt(dungeon.theme.ceilings.length)];
                this.fenceBlock = !dungeon.variability.use(dungeon.random) ? dungeon.fenceBlock : dungeon.theme.fencing[dungeon.random.nextInt(dungeon.theme.fencing.length)];
                this.pillarBlock = !dungeon.variability.use(dungeon.random) ? dungeon.cornerBlock : dungeon.theme.pillarBlock[dungeon.random.nextInt(dungeon.theme.pillarBlock.length)];
                this.liquidBlock = !dungeon.variability.use(dungeon.random) ? dungeon.liquidBlock : dungeon.theme.liquid[dungeon.random.nextInt(dungeon.theme.liquid.length)];
                this.caveBlock = !dungeon.variability.use(dungeon.random) ? dungeon.caveBlock : dungeon.theme.caveWalls[dungeon.random.nextInt(dungeon.theme.caveWalls.length)];
            }
        } else {
            this.wallBlock1 = dungeon.wallBlock1;
            this.floorBlock = dungeon.floorBlock;
            this.cielingBlock = dungeon.cielingBlock;
            this.fenceBlock = dungeon.fenceBlock;
            this.pillarBlock = dungeon.cornerBlock;
            this.liquidBlock = dungeon.liquidBlock;
            this.caveBlock = dungeon.caveBlock;
        }
        if (dungeon.outside.value > 0) {
            this.sky = dungeon.outside.use(dungeon.random);
        }
        if (dungeon.degeneracy.value > 0) {
            this.degenerate = dungeon.degeneracy.use(dungeon.random);
            this.degenerateFloors = this.degenerate && dungeon.degeneracy.use(dungeon.random) && dungeon.random.nextBoolean();
        }
        this.fenced = this.sky ? dungeon.fences.use(dungeon.random) : false;
    }

    public static Room makeRoom(int beginX, int endX, int beginZ, int endZ, int floorY, int ceilY, Dungeon dungeon, Room parent, Room previous) {
        RoomType type = RoomType.ROOM;
        if (dungeon.naturals.use(dungeon.random)) {
            type = RoomType.CAVE;
        }
        switch (type) {
            case CAVE: {
                Cave base = new Cave(beginX, endX, beginZ, endZ, floorY, ceilY, dungeon, parent, previous);
                return base.plan(dungeon, parent);
            }
        }
        Room base = new Room(beginX, endX, beginZ, endZ, floorY, ceilY, dungeon, parent, previous);
        return base.plan(dungeon, parent);
    }

    public static Room makeRoom(int beginX, int endX, int beginZ, int endZ, int floorY, int ceilY, Dungeon dungeon, Room parent, Room previous, RoomType type) {
        switch (type) {
            case CAVE: {
                Cave base = new Cave(beginX, endX, beginZ, endZ, floorY, ceilY, dungeon, parent, previous);
                return base.plan(dungeon, parent);
            }
        }
        Room base = new Room(beginX, endX, beginZ, endZ, floorY, ceilY, dungeon, parent, previous);
        return base.plan(dungeon, parent);
    }
}

