/*
 * Decompiled with CFR 0.152.
 */
package texturegeneratorlib.texturestitching;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import texturegeneratorlib.TextureGeneratorLib;
import texturegeneratorlib.loader.impl.CodeRefs;

@SideOnly(value=Side.CLIENT)
public abstract class BlockTextureGenerator
implements IResourceManager {
    public String domainName;

    public BlockTextureGenerator(String domainName) {
        this.domainName = domainName;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        TextureGeneratorLib.log.info(String.format("Texture Generator added for Domain " + this.domainName, new Object[0]));
        if (event.map.func_130086_a() != 0) {
            return;
        }
        Map domainManagers = (Map)CodeRefs.fDomainResourceManagers.getInstanceField(Minecraft.func_71410_x().func_110442_L());
        if (domainManagers == null) {
            TextureGeneratorLib.log.warn("Failed to inject texture generator");
            return;
        }
        domainManagers.put(this.domainName, this);
    }

    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        Map domainManagers = (Map)CodeRefs.fDomainResourceManagers.getInstanceField(Minecraft.func_71410_x().func_110442_L());
        if (domainManagers != null) {
            domainManagers.remove(this.domainName);
        }
    }

    public Set<String> func_135055_a() {
        return ImmutableSet.of((Object)this.domainName);
    }

    public List<IResource> func_135056_b(ResourceLocation resource) throws IOException {
        return ImmutableList.of((Object)this.func_110536_a(resource));
    }

    protected static int blendRGB(int rgbOrig, int rgbBlend, int weightOrig, int weightBlend) {
        int r = ((rgbOrig >> 16 & 0xFF) * weightOrig + (rgbBlend >> 16 & 0xFF) * weightBlend) / (weightOrig + weightBlend);
        int g = ((rgbOrig >> 8 & 0xFF) * weightOrig + (rgbBlend >> 8 & 0xFF) * weightBlend) / (weightOrig + weightBlend);
        int b = ((rgbOrig & 0xFF) * weightOrig + (rgbBlend & 0xFF) * weightBlend) / (weightOrig + weightBlend);
        int a = rgbOrig >> 24 & 0xFF;
        int result = a << 24 | r << 16 | g << 8 | b;
        return result;
    }
}

