/*
 * Decompiled with CFR 0.152.
 */
package texturegeneratorlib.texturestitching;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import texturegeneratorlib.TextureGeneratorLib;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean resourceExists(ResourceLocation resourceLocation) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            if (resource != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void copyFromTextResource(ResourceLocation resourceLocation, File target) throws IOException {
        IResource defaults = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
        BufferedReader reader = new BufferedReader(new InputStreamReader(defaults.func_110527_b(), Charsets.UTF_8));
        FileWriter writer = new FileWriter(target);
        String line = reader.readLine();
        while (line != null) {
            writer.write(line + System.lineSeparator());
            line = reader.readLine();
        }
        reader.close();
        writer.close();
    }

    public static Iterable<String> getLines(ResourceLocation resource) {
        BufferedReader reader = null;
        ArrayList result = Lists.newArrayList();
        try {
            reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b(), Charsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("//")) {
                    result.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            TextureGeneratorLib.log.warn(String.format("Error reading resource %s", resource.toString()));
            return Lists.newArrayList();
        }
        return result;
    }

    public static IResource getResource(ResourceLocation location) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ResourceLocation unwrapResource(ResourceLocation wrapped) {
        if (wrapped.func_110623_a().startsWith("textures/blocks/")) {
            String path = wrapped.func_110623_a().toString();
            ResourceLocation unwrapped = new ResourceLocation(wrapped.func_110624_b(), path.substring(16, path.length() - 4));
            return unwrapped;
        }
        return new ResourceLocation(wrapped.func_110624_b(), wrapped.func_110623_a());
    }

    public static ResourceLocation getIconLocation(IIcon icon) {
        ResourceLocation shortLocation = new ResourceLocation(icon.func_94215_i());
        ResourceLocation fullLocation = new ResourceLocation(shortLocation.func_110624_b(), String.format("textures/blocks/%s.png", shortLocation.func_110623_a()));
        return fullLocation;
    }
}

