/*
 * Decompiled with CFR 0.152.
 */
package texturegeneratorlib.texturestitching;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import texturegeneratorlib.texturestitching.ResourceUtils;

public class TextureMatcher {
    public static String DEFAULT_TYPE = "default";
    public List<TextureMapping> mappings = Lists.newLinkedList();
    public Map<IIcon, String> types = Maps.newHashMap();

    public void clear() {
        this.types.clear();
    }

    public String put(TextureAtlasSprite icon) {
        if (this.types.keySet().contains(icon)) {
            return this.types.get(icon);
        }
        for (TextureMapping mapping : this.mappings) {
            if (!mapping.matches(icon)) continue;
            this.types.put((IIcon)icon, mapping.textureType);
            return mapping.textureType;
        }
        return DEFAULT_TYPE;
    }

    public String get(IIcon icon) {
        return this.types.get(icon);
    }

    public void loadMappings(ResourceLocation resource) {
        this.mappings = Lists.newLinkedList();
        for (String line : ResourceUtils.getLines(resource)) {
            String[] lineSplit = line.split("=");
            if (lineSplit.length != 2) continue;
            String[] match = lineSplit[0].split(":");
            if (match.length == 2) {
                this.mappings.add(new TextureMapping(match[0], match[1], lineSplit[1]));
                continue;
            }
            if (match.length != 1) continue;
            this.mappings.add(new TextureMapping(null, match[0], lineSplit[1]));
        }
    }

    public static class TextureMapping {
        public String matchDomain;
        public String matchName;
        public String textureType;

        public TextureMapping(String matchDomain, String matchName, String textureType) {
            this.matchDomain = matchDomain;
            this.matchName = matchName;
            this.textureType = textureType;
        }

        public boolean matches(TextureAtlasSprite icon) {
            ResourceLocation iconLocation = new ResourceLocation(icon.func_94215_i());
            if (this.matchDomain != null && !this.matchDomain.equals(iconLocation.func_110624_b())) {
                return false;
            }
            return iconLocation.func_110623_a().contains(this.matchName);
        }
    }
}

