/*
 * Decompiled with CFR 0.152.
 */
package teletubbies;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import teletubbies.Teletubbies;
import teletubbies.entity.monster.EntityZombieDipsy;
import teletubbies.entity.monster.EntityZombieLaaLaa;
import teletubbies.entity.monster.EntityZombiePo;
import teletubbies.entity.monster.EntityZombieTinkyWinky;
import teletubbies.entity.passive.EntityDipsy;
import teletubbies.entity.passive.EntityLaaLaa;
import teletubbies.entity.passive.EntityPo;
import teletubbies.entity.passive.EntityTinkyWinky;
import teletubbies.gui.config.TeletubbiesConfigurationHandler;
import teletubbies.item.LaaLaaBall;

public class TeletubbiesEventHandler {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            World world = player.field_70170_p;
            float fallDistance = player.getEntityData().func_74760_g("LaaLaaBall_fallDistance");
            if (!world.field_72995_K && player.field_70143_R >= fallDistance) {
                this.setFallDistance(player, player.field_70143_R);
            }
            if (player.func_70694_bm() != null && !world.field_72995_K) {
                String laaLaaBall;
                String hand = player.func_70694_bm().func_77977_a();
                if (hand.equals(laaLaaBall = Teletubbies.laaLaaBall.func_77658_a()) && player.field_70122_E && !player.func_70090_H()) {
                    ItemStack heldItem = player.func_70694_bm();
                    LaaLaaBall ball = (LaaLaaBall)heldItem.func_77973_b();
                    if (fallDistance >= 10.0f) {
                        float yaw = player.field_70177_z;
                        float pitch = player.field_70125_A;
                        float movingAmount = 1.0f;
                        double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * movingAmount;
                        double motionY = 1.0 + (double)(fallDistance / 90.0f);
                        double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * movingAmount;
                        player.func_70024_g(motionX, motionY, motionZ);
                        if (player instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)player));
                        }
                        player.func_70664_aZ();
                        this.setFallDistance(player, 0.0f);
                        world.func_72956_a((Entity)player, "teletubbies:ball.bounce", 0.8f, 1.0f);
                    }
                }
                if (!hand.equals(laaLaaBall) && player.field_70122_E) {
                    this.setFallDistance(player, 0.0f);
                }
                if (player.func_70090_H()) {
                    this.setFallDistance(player, 0.0f);
                }
            }
            if (player.func_70694_bm() == null) {
                this.setFallDistance(player, 0.0f);
            }
        }
    }

    public void setFallDistance(EntityPlayer player, float value) {
        player.getEntityData().func_74776_a("LaaLaaBall_fallDistance", value);
    }

    @SubscribeEvent
    public void onPlayerDamage(LivingAttackEvent event) {
        String laaLaaBall;
        String hand;
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && event.source == DamageSource.field_76379_h && (player = (EntityPlayer)event.entityLiving).func_70694_bm() != null && (hand = player.func_70694_bm().func_77977_a()).equals(laaLaaBall = Teletubbies.laaLaaBall.func_77658_a())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityZombie && TeletubbiesConfigurationHandler.zombiesAttacksTeletubbies) {
            EntityZombie Zombie = (EntityZombie)event.entity;
            Zombie.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)Zombie, EntityPo.class, 1.0, false));
            Zombie.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)Zombie, EntityLaaLaa.class, 1.0, false));
            Zombie.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)Zombie, EntityDipsy.class, 1.0, false));
            Zombie.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)Zombie, EntityTinkyWinky.class, 1.0, false));
            Zombie.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)Zombie, EntityPo.class, 0, true));
            Zombie.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)Zombie, EntityLaaLaa.class, 0, true));
            Zombie.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)Zombie, EntityDipsy.class, 0, true));
            Zombie.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)Zombie, EntityTinkyWinky.class, 0, true));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Random rand = new Random();
        int randomNumber = rand.nextInt(5) + 1;
        DamageSource damageSource = event.source;
        World world = event.entityLiving.field_70170_p;
        double posX = event.entityLiving.field_70165_t;
        double posY = event.entityLiving.field_70163_u;
        double posZ = event.entityLiving.field_70161_v;
        if (!world.field_72995_K && (damageSource.func_76346_g() instanceof EntityZombieTinkyWinky || damageSource.func_76346_g() instanceof EntityZombieDipsy || damageSource.func_76346_g() instanceof EntityZombieLaaLaa || damageSource.func_76346_g() instanceof EntityZombiePo || damageSource.func_76346_g() instanceof EntityZombie)) {
            if (event.entity instanceof EntityTinkyWinky && randomNumber == 1) {
                EntityZombieTinkyWinky zombieTinkyWinky = new EntityZombieTinkyWinky(world);
                EntityTinkyWinky.transferredToZombie = true;
                zombieTinkyWinky.func_70012_b(posX, posY, posZ, event.entityLiving.field_70177_z, event.entityLiving.field_70125_A);
                world.func_72838_d((Entity)zombieTinkyWinky);
            }
            if (event.entity instanceof EntityDipsy && randomNumber == 1) {
                EntityZombieDipsy zombieDipsy = new EntityZombieDipsy(world);
                EntityDipsy.transferredToZombie = true;
                zombieDipsy.func_70012_b(posX, posY, posZ, event.entityLiving.field_70177_z, event.entityLiving.field_70125_A);
                world.func_72838_d((Entity)zombieDipsy);
            }
            if (event.entity instanceof EntityLaaLaa && randomNumber == 1) {
                EntityZombieLaaLaa zombieLaaLaa = new EntityZombieLaaLaa(world);
                EntityLaaLaa.transferredToZombie = true;
                zombieLaaLaa.func_70012_b(posX, posY, posZ, event.entityLiving.field_70177_z, event.entityLiving.field_70125_A);
                world.func_72838_d((Entity)zombieLaaLaa);
            }
            if (event.entity instanceof EntityPo && randomNumber == 1) {
                EntityZombiePo zombiePo = new EntityZombiePo(world);
                EntityPo.transferredToZombie = true;
                zombiePo.func_70012_b(posX, posY, posZ, event.entityLiving.field_70177_z, event.entityLiving.field_70125_A);
                world.func_72838_d((Entity)zombiePo);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("Teletubbies")) {
            TeletubbiesConfigurationHandler.syncConfig();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(TickEvent.PlayerTickEvent event) {
        if (!Teletubbies.haveWarnedVersionOutOfDate && event.player.field_70170_p.field_72995_K && !Teletubbies.updateChecker.isLatestVersion() && TeletubbiesConfigurationHandler.showUpdateCheck) {
            Teletubbies.updateChecker.updateStatus(event.player);
        }
    }
}

