/*
 * Decompiled with CFR 0.152.
 */
package teletubbies.block.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import teletubbies.sounds.SpinSound;

public class TileEntityTubbyWindMill
extends TileEntity {
    private int[] masterPos = new int[3];
    private int[] topPos = new int[3];
    private Integer masterDirection = null;
    private Boolean isMaster = null;
    private Boolean isTop = null;
    private boolean isActivated = false;
    boolean isPlayingSound = false;
    private float rotationAngle = 0.0f;
    private float soundTimer = 0.0f;

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        while (this.isMaster() == null) {
            NBTTagCompound data = new NBTTagCompound();
            this.func_145839_a(data);
        }
        if (this.isMaster().booleanValue()) {
            bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 1));
        }
        return bb;
    }

    public void func_145845_h() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        this.rotationAngle += 10.0f;
        if (this.rotationAngle >= 360.0f) {
            this.rotationAngle = 0.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSound() {
        TileEntityTubbyWindMill te = (TileEntityTubbyWindMill)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        SpinSound spin = new SpinSound("teletubbies:windmill.spin", te, 1.0f, 1.0f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)spin);
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74783_a("masterPos", this.masterPos);
        data.func_74783_a("topPos", this.topPos);
        data.func_74768_a("masterDirection", this.masterDirection.intValue());
        data.func_74757_a("isMaster", this.isMaster.booleanValue());
        data.func_74757_a("isTop", this.isTop.booleanValue());
        data.func_74757_a("isActivated", this.isActivated);
        data.func_74757_a("isPlayingSound", this.isPlayingSound);
        data.func_74776_a("rotationAngle", this.rotationAngle);
        data.func_74776_a("soundTimer", this.soundTimer);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.masterPos = data.func_74759_k("masterPos");
        this.topPos = data.func_74759_k("topPos");
        this.masterDirection = data.func_74762_e("masterDirection");
        this.isMaster = data.func_74767_n("isMaster");
        this.isTop = data.func_74767_n("isTop");
        this.isActivated = data.func_74767_n("isActivated");
        this.isPlayingSound = data.func_74767_n("isPlayingSound");
        this.rotationAngle = data.func_74760_g("rotationAngle");
        this.soundTimer = data.func_74760_g("soundTimer");
    }

    public int getMasterX() {
        return this.masterPos[0];
    }

    public int getMasterY() {
        return this.masterPos[1];
    }

    public int getMasterZ() {
        return this.masterPos[2];
    }

    public int getTopX() {
        return this.topPos[0];
    }

    public int getTopY() {
        return this.topPos[1];
    }

    public int getTopZ() {
        return this.topPos[2];
    }

    public Integer getMasterDirection() {
        return this.masterDirection;
    }

    public Boolean isMaster() {
        return this.isMaster;
    }

    public Boolean isTop() {
        return this.isTop;
    }

    public boolean isActivated() {
        TileEntityTubbyWindMill master = (TileEntityTubbyWindMill)this.field_145850_b.func_147438_o(this.getMasterX(), this.getMasterY(), this.getMasterZ());
        if (master == null) {
            return false;
        }
        if (this.isMaster().booleanValue()) {
            return this.isActivated;
        }
        return master.isActivated();
    }

    public boolean isPlayingSound() {
        TileEntityTubbyWindMill master = (TileEntityTubbyWindMill)this.field_145850_b.func_147438_o(this.getMasterX(), this.getMasterY(), this.getMasterZ());
        if (master == null) {
            return false;
        }
        if (this.isMaster().booleanValue()) {
            return this.isPlayingSound;
        }
        return master.isPlayingSound();
    }

    public float rotationAngle() {
        return this.rotationAngle;
    }

    public void setMasterData(int x, int y, int z, int masterdirection, boolean ismaster) {
        this.masterPos[0] = x;
        this.masterPos[1] = y;
        this.masterPos[2] = z;
        this.masterDirection = masterdirection;
        this.isMaster = ismaster;
    }

    public void setTopData(int x, int y, int z, boolean istop) {
        this.topPos[0] = x;
        this.topPos[1] = y;
        this.topPos[2] = z;
        this.isTop = istop;
    }

    public void setIsActivated(boolean activated) {
        this.isActivated = activated;
    }

    public void setIsPlayingSound(boolean isplayingsound) {
        this.isPlayingSound = isplayingsound;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

