/*
 * Decompiled with CFR 0.152.
 */
package com.piggywiggy3.movillages.world;

import com.piggywiggy3.movillages.world.HellVillagerRegistry;
import com.piggywiggy3.movillages.world.MapGenHellVillage;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;

public class StructureHellVillagePieces {
    private static final String __OBFID = "CL_00000516";

    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"ViBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"ViDF");
        MapGenStructureIO.func_143031_a(Field2.class, (String)"ViF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"ViL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"ViPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"ViSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"ViSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"ViST");
        MapGenStructureIO.func_143031_a(House2.class, (String)"ViS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"ViStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"ViSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"ViTRH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"ViW");
    }

    public static List getStructureVillageWeightedPieceList(Random par0Random, int par1) {
        ArrayList<PieceWeight> arraylist = new ArrayList<PieceWeight>();
        arraylist.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)par0Random, (int)(2 + par1), (int)(4 + par1 * 2))));
        arraylist.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)par0Random, (int)(0 + par1), (int)(1 + par1))));
        arraylist.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a((Random)par0Random, (int)(0 + par1), (int)(2 + par1))));
        arraylist.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)par0Random, (int)(2 + par1), (int)(5 + par1 * 3))));
        arraylist.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)par0Random, (int)(0 + par1), (int)(2 + par1))));
        arraylist.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)par0Random, (int)(1 + par1), (int)(4 + par1))));
        arraylist.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)par0Random, (int)(2 + par1), (int)(4 + par1 * 2))));
        arraylist.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a((Random)par0Random, (int)0, (int)(1 + par1))));
        arraylist.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)par0Random, (int)(0 + par1), (int)(3 + par1 * 2))));
        HellVillagerRegistry.addExtraVillageComponents(arraylist, par0Random, par1);
        Iterator iterator = arraylist.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return arraylist;
    }

    private static int func_75079_a(List par0List) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight pieceweight : par0List) {
            if (pieceweight.villagePiecesLimit > 0 && pieceweight.villagePiecesSpawned < pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village func_75083_a(Start par0ComponentVillageStartPiece, PieceWeight par1StructureVillagePieceWeight, List par2List, Random par3Random, int par4, int par5, int par6, int par7, int par8) {
        Class oclass = par1StructureVillagePieceWeight.villagePieceClass;
        Object object = null;
        object = oclass == House4Garden.class ? House4Garden.func_74912_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == Church.class ? Church.func_74919_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == House1.class ? House1.func_74898_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == WoodHut.class ? WoodHut.func_74908_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == Hall.class ? Hall.func_74906_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == Field1.class ? Field1.func_74900_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == Field2.class ? Field2.func_74902_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == House2.class ? House2.func_74915_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : (oclass == House3.class ? House3.func_74921_a(par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8) : HellVillagerRegistry.getVillageComponent(par1StructureVillagePieceWeight, par0ComponentVillageStartPiece, par2List, par3Random, par4, par5, par6, par7, par8)))))))));
        return object;
    }

    private static Village getNextVillageComponent(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        int j1 = StructureHellVillagePieces.func_75079_a(par0ComponentVillageStartPiece.structureVillageWeightedPieceList);
        if (j1 <= 0) {
            return null;
        }
        int k1 = 0;
        block0: while (k1 < 5) {
            ++k1;
            int l1 = par2Random.nextInt(j1);
            for (PieceWeight pieceweight : par0ComponentVillageStartPiece.structureVillageWeightedPieceList) {
                if ((l1 -= pieceweight.villagePieceWeight) >= 0) continue;
                if (!pieceweight.canSpawnMoreVillagePiecesOfType(par7) || pieceweight == par0ComponentVillageStartPiece.structVillagePieceWeight && par0ComponentVillageStartPiece.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village village = StructureHellVillagePieces.func_75083_a(par0ComponentVillageStartPiece, pieceweight, par1List, par2Random, par3, par4, par5, par6, par7);
                if (village == null) continue;
                ++pieceweight.villagePiecesSpawned;
                par0ComponentVillageStartPiece.structVillagePieceWeight = pieceweight;
                if (!pieceweight.canSpawnMoreVillagePieces()) {
                    par0ComponentVillageStartPiece.structureVillageWeightedPieceList.remove(pieceweight);
                }
                return village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.func_74904_a(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6);
        if (structureboundingbox != null) {
            return new Torch(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6);
        }
        return null;
    }

    private static StructureComponent getNextVillageStructureComponent(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 50) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentVillageStartPiece.func_74874_b().field_78897_a) <= 112 && Math.abs(par5 - par0ComponentVillageStartPiece.func_74874_b().field_78896_c) <= 112) {
            Village village = StructureHellVillagePieces.getNextVillageComponent(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6, par7 + 1);
            if (village != null) {
                int j2;
                int j1 = (village.func_74874_b().field_78897_a + village.func_74874_b().field_78893_d) / 2;
                int k1 = (village.func_74874_b().field_78896_c + village.func_74874_b().field_78892_f) / 2;
                int l1 = village.func_74874_b().field_78893_d - village.func_74874_b().field_78897_a;
                int i2 = village.func_74874_b().field_78892_f - village.func_74874_b().field_78896_c;
                int n = j2 = l1 > i2 ? l1 : i2;
                if (par0ComponentVillageStartPiece.getWorldChunkManager().func_76940_a(j1, k1, j2 / 2 + 4, MapGenHellVillage.villageSpawnBiomes)) {
                    par1List.add(village);
                    par0ComponentVillageStartPiece.field_74932_i.add(village);
                    return village;
                }
            }
            return null;
        }
        return null;
    }

    private static StructureComponent getNextComponentVillagePath(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 3 + par0ComponentVillageStartPiece.terrainType) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentVillageStartPiece.func_74874_b().field_78897_a) <= 112 && Math.abs(par5 - par0ComponentVillageStartPiece.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = Path.func_74933_a(par0ComponentVillageStartPiece, par1List, par2Random, par3, par4, par5, par6);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                int j2;
                Path path = new Path(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6);
                int j1 = (path.func_74874_b().field_78897_a + path.func_74874_b().field_78893_d) / 2;
                int k1 = (path.func_74874_b().field_78896_c + path.func_74874_b().field_78892_f) / 2;
                int l1 = path.func_74874_b().field_78893_d - path.func_74874_b().field_78897_a;
                int i2 = path.func_74874_b().field_78892_f - path.func_74874_b().field_78896_c;
                int n = j2 = l1 > i2 ? l1 : i2;
                if (par0ComponentVillageStartPiece.getWorldChunkManager().func_76940_a(j1, k1, j2 / 2 + 4, MapGenHellVillage.villageSpawnBiomes)) {
                    par1List.add(path);
                    par0ComponentVillageStartPiece.field_74930_j.add(path);
                    return path;
                }
            }
            return null;
        }
        return null;
    }

    public static class PieceWeight {
        public Class villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;
        private static final String __OBFID = "CL_00000521";

        public PieceWeight(Class par1Class, int par2, int par3) {
            this.villagePieceClass = par1Class;
            this.villagePieceWeight = par2;
            this.villagePiecesLimit = par3;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int par1) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Torch
    extends Village {
        private static final String __OBFID = "CL_00000520";

        public Torch() {
        }

        public Torch(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
        }

        public static StructureBoundingBox func_74904_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (int)par6);
            return StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 0, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150325_L, 15, 1, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 0, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 1, 3, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 2, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 1, 3, -1, par3StructureBoundingBox);
            return true;
        }
    }

    public static abstract class Road
    extends Village {
        private static final String __OBFID = "CL_00000532";

        public Road() {
        }

        protected Road(Start par1ComponentVillageStartPiece, int par2) {
            super(par1ComponentVillageStartPiece, par2);
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private static final String __OBFID = "CL_00000519";

        public Field2() {
        }

        public Field2(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
            this.cropTypeA = this.func_151560_a(par3Random);
            this.cropTypeB = this.func_151560_a(par3Random);
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            par1NBTTagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.cropTypeA = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("CB"));
        }

        private Block func_151560_a(Random p_151560_1_) {
            switch (p_151560_1_.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field2 func_74902_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (int)par6);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new Field2(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 0, 5, 0, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 8, 5, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            for (i = 1; i <= 7; ++i) {
                this.func_151550_a(par1World, this.cropTypeA, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 1, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeA, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 2, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeB, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 4, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeB, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 5, 1, i, par3StructureBoundingBox);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.func_74871_b(par1World, j, 4, i, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150346_d, 0, j, -1, i, par3StructureBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;
        private static final String __OBFID = "CL_00000518";

        public Field1() {
        }

        public Field1(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
            this.cropTypeA = this.func_151559_a(par3Random);
            this.cropTypeB = this.func_151559_a(par3Random);
            this.cropTypeC = this.func_151559_a(par3Random);
            this.cropTypeD = this.func_151559_a(par3Random);
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            par1NBTTagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            par1NBTTagCompound.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            par1NBTTagCompound.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.cropTypeA = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("CD"));
        }

        private Block func_151559_a(Random p_151559_1_) {
            switch (p_151559_1_.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field1 func_74900_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (int)par6);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new Field1(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak, Blocks.field_150458_ak, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 0, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 6, 0, 0, 6, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 12, 0, 0, 12, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 0, 11, 0, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 8, 11, 0, 8, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j, Blocks.field_150355_j, false);
            for (i = 1; i <= 7; ++i) {
                this.func_151550_a(par1World, this.cropTypeA, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 1, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeA, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 2, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeB, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 4, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeB, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 5, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeC, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 7, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeC, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 8, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeD, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 10, 1, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, this.cropTypeD, MathHelper.func_76136_a((Random)par2Random, (int)2, (int)7), 11, 1, i, par3StructureBoundingBox);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < 13; ++j) {
                    this.func_74871_b(par1World, j, 4, i, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150346_d, 0, j, -1, i, par3StructureBoundingBox);
                }
            }
            return true;
        }
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;
        private static final String __OBFID = "CL_00000524";

        public WoodHut() {
        }

        public WoodHut(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
            this.isTallHouse = par3Random.nextBoolean();
            this.tablePosition = par3Random.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("T", this.tablePosition);
            par1NBTTagCompound.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.tablePosition = par1NBTTagCompound.func_74762_e("T");
            this.isTallHouse = par1NBTTagCompound.func_74767_n("C");
        }

        public static WoodHut func_74908_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (int)par6);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 3, 0, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d, Blocks.field_150346_d, false);
            if (this.isTallHouse) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 1, 4, 1, 2, 4, 3, Blocks.field_150364_r, Blocks.field_150364_r, false);
            } else {
                this.func_151549_a(par1World, par3StructureBoundingBox, 1, 5, 1, 2, 5, 3, Blocks.field_150364_r, Blocks.field_150364_r, false);
            }
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 1, 4, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 2, 4, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 1, 4, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 2, 4, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 4, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 4, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 3, 4, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 3, 4, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 3, 4, 3, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 0, 3, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 0, 3, 3, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 4, 0, 3, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 4, 3, 3, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 1, 3, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 0, 2, 3, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 4, 2, 3, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 3, 2, 2, par3StructureBoundingBox);
            if (this.tablePosition > 0) {
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, this.tablePosition, 1, 3, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150452_aw, 0, this.tablePosition, 2, 3, par3StructureBoundingBox);
            }
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 1, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 1, 2, 0, par3StructureBoundingBox);
            this.func_74881_a(par1World, par3StructureBoundingBox, par2Random, 1, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(par1World, 1, 0, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(par1World, 1, -1, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 1, 0, -1, par3StructureBoundingBox);
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(par1World, j, 6, i, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, j, -1, i, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Village {
        private static final String __OBFID = "CL_00000530";

        public House3() {
        }

        public House3(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
        }

        public static House3 func_74921_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (int)par6);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new House3(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int j1;
            int i1;
            int l;
            int k;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 0, 5, 8, 0, 10, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 0, 0, 8, 3, 10, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 0, 7, 2, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 5, 2, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 0, 6, 2, 3, 10, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 0, 10, 7, 3, 10, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 2, 0, 7, 3, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 2, 5, 2, 3, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 1, 8, 4, 1, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 4, 3, 4, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 2, 8, 5, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 0, 4, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 0, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 8, 4, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 8, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 8, 4, 4, par3StructureBoundingBox);
            int i = this.func_151555_a(Blocks.field_150476_ad, 3);
            int j = this.func_151555_a(Blocks.field_150476_ad, 2);
            for (k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    this.func_151550_a(par1World, Blocks.field_150476_ad, i, l, 4 + k, k, par3StructureBoundingBox);
                    if (k <= -1 && l > 1 || k <= 0 && l > 3 || k <= 1 && l > 4 && l < 6) continue;
                    this.func_151550_a(par1World, Blocks.field_150476_ad, j, l, 4 + k, 5 - k, par3StructureBoundingBox);
                }
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 4, 5, 3, 4, 10, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 7, 4, 2, 7, 4, 10, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 5, 4, 4, 5, 10, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 6, 5, 4, 6, 5, 10, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 6, 3, 5, 6, 10, Blocks.field_150344_f, Blocks.field_150344_f, false);
            k = this.func_151555_a(Blocks.field_150476_ad, 0);
            for (l = 4; l >= 1; --l) {
                this.func_151550_a(par1World, Blocks.field_150344_f, 0, l, 2 + l, 7 - l, par3StructureBoundingBox);
                for (i1 = 8 - l; i1 <= 10; ++i1) {
                    this.func_151550_a(par1World, Blocks.field_150476_ad, k, l, 2 + l, i1, par3StructureBoundingBox);
                }
            }
            l = this.func_151555_a(Blocks.field_150476_ad, 1);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 6, 6, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 7, 5, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, l, 6, 6, 4, par3StructureBoundingBox);
            for (i1 = 6; i1 <= 8; ++i1) {
                for (j1 = 5; j1 <= 10; ++j1) {
                    this.func_151550_a(par1World, Blocks.field_150476_ad, l, i1, 12 - i1, j1, par3StructureBoundingBox);
                }
            }
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 4, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 5, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 6, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 8, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 8, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 8, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 8, 2, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 8, 2, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 2, 2, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 2, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 2, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 2, 2, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 4, 4, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 5, 4, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 6, 4, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 5, 5, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 2, 3, 1, par3StructureBoundingBox);
            this.func_74881_a(par1World, par3StructureBoundingBox, par2Random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            if (this.func_151548_a(par1World, 2, 0, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(par1World, 2, -1, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, par3StructureBoundingBox);
            }
            for (i1 = 0; i1 < 5; ++i1) {
                for (j1 = 0; j1 < 9; ++j1) {
                    this.func_74871_b(par1World, j1, 7, i1, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, j1, -1, i1, par3StructureBoundingBox);
                }
            }
            for (i1 = 5; i1 < 11; ++i1) {
                for (j1 = 2; j1 < 9; ++j1) {
                    this.func_74871_b(par1World, j1, 7, i1, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, j1, -1, i1, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 4, 1, 2, 2);
            return true;
        }
    }

    public static class Start
    extends Well {
        public WorldChunkManager worldChunkMngr;
        public boolean inDesert;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List structureVillageWeightedPieceList;
        public List field_74932_i = new ArrayList();
        public List field_74930_j = new ArrayList();
        private static final String __OBFID = "CL_00000527";
        public BiomeGenBase biome;

        public Start() {
        }

        public Start(WorldChunkManager par1WorldChunkManager, int par2, Random par3Random, int par4, int par5, List par6List, int par7) {
            super(null, 0, par3Random, par4, par5);
            this.worldChunkMngr = par1WorldChunkManager;
            this.structureVillageWeightedPieceList = par6List;
            this.terrainType = par7;
            BiomeGenBase biomegenbase = par1WorldChunkManager.func_76935_a(par4, par5);
            this.inDesert = biomegenbase == BiomeGenBase.field_76769_d || biomegenbase == BiomeGenBase.field_76786_s;
            this.biome = biomegenbase;
        }

        public WorldChunkManager getWorldChunkManager() {
            return this.worldChunkMngr;
        }
    }

    public static class House2
    extends Village {
        public static final WeightedRandomChestContent[] villageBlacksmithChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 3), new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151043_k, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151034_e, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151035_b, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151040_l, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151030_Z, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151028_Y, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151165_aa, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151167_ab, 0, 1, 1, 5), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150343_Z), 0, 3, 7, 5), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150345_g), 0, 3, 7, 5), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 3), new WeightedRandomChestContent(Items.field_151138_bX, 0, 1, 1, 1), new WeightedRandomChestContent(Items.field_151136_bY, 0, 1, 1, 1), new WeightedRandomChestContent(Items.field_151125_bZ, 0, 1, 1, 1)};
        private boolean hasMadeChest;
        private static final String __OBFID = "CL_00000526";

        public House2() {
        }

        public House2(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
        }

        public static House2 func_74915_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (int)par6);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new House2(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.hasMadeChest = par1NBTTagCompound.func_74767_n("Chest");
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int j;
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 9, 0, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 0, 9, 4, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 0, 9, 5, 6, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 0, 2, 3, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 0, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 0, 3, 4, 0, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 6, 0, 4, 6, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 3, 3, 1, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 2, 3, 3, 2, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 3, 5, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 6, 5, 3, 6, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 1, 0, 5, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 9, 1, 0, 9, 3, 0, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 6, 1, 4, 9, 4, 6, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151550_a(par1World, (Block)Blocks.field_150356_k, 0, 7, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150356_k, 0, 8, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150411_aY, 0, 9, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150411_aY, 0, 9, 2, 4, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 6, 1, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150460_al, 0, 6, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150460_al, 0, 6, 3, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150334_T, 0, 8, 1, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 2, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 2, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 2, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150452_aw, 0, 2, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 1, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 3), 2, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 1), 1, 1, 4, par3StructureBoundingBox);
            if (!this.hasMadeChest) {
                int k;
                i = this.func_74862_a(1);
                j = this.func_74865_a(5, 5);
                if (par3StructureBoundingBox.func_78890_b(j, i, k = this.func_74873_b(5, 5))) {
                    this.hasMadeChest = true;
                    this.func_74879_a(par1World, par3StructureBoundingBox, par2Random, 5, 1, 5, ChestGenHooks.getItems((String)"villageBlacksmith", (Random)par2Random), ChestGenHooks.getCount((String)"villageBlacksmith", (Random)par2Random));
                }
            }
            for (i = 6; i <= 8; ++i) {
                if (this.func_151548_a(par1World, i, 0, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a || this.func_151548_a(par1World, i, -1, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a) continue;
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), i, 0, -1, par3StructureBoundingBox);
            }
            for (i = 0; i < 7; ++i) {
                for (j = 0; j < 10; ++j) {
                    this.func_74871_b(par1World, j, 6, i, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, j, -1, i, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return 3;
        }
    }

    public static class Path
    extends Road {
        private int averageGroundLevel;
        private static final String __OBFID = "CL_00000528";

        public Path() {
        }

        public Path(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
            this.averageGroundLevel = Math.max(par4StructureBoundingBox.func_78883_b(), par4StructureBoundingBox.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("Length", this.averageGroundLevel);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.averageGroundLevel = par1NBTTagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            StructureComponent structurecomponent1;
            int i;
            boolean flag = false;
            for (i = par3Random.nextInt(5); i < this.averageGroundLevel - 8; i += 2 + par3Random.nextInt(5)) {
                structurecomponent1 = this.getNextComponentNN((Start)par1StructureComponent, par2List, par3Random, 0, i);
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            for (i = par3Random.nextInt(5); i < this.averageGroundLevel - 8; i += 2 + par3Random.nextInt(5)) {
                structurecomponent1 = this.getNextComponentPP((Start)par1StructureComponent, par2List, par3Random, 0, i);
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            if (flag && par3Random.nextInt(3) > 0) {
                switch (this.field_74885_f) {
                    case 0: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 1, this.func_74877_c());
                        break;
                    }
                    case 1: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 1, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                    }
                }
            }
            if (flag && par3Random.nextInt(3) > 0) {
                switch (this.field_74885_f) {
                    case 0: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 3, this.func_74877_c());
                        break;
                    }
                    case 1: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 3, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox func_74933_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6) {
            for (int i1 = 7 * MathHelper.func_76136_a((Random)par2Random, (int)3, (int)5); i1 >= 7; i1 -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i1, (int)par6);
                if (StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            Block block = this.func_151558_b(Blocks.field_150351_n, 0);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (!par3StructureBoundingBox.func_78890_b(i, 64, j)) continue;
                    int k = par1World.func_72825_h(i, j) - 1;
                    par1World.func_147465_d(i, k, j, block, 0, 2);
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;
        private static final String __OBFID = "CL_00000523";

        public House4Garden() {
        }

        public House4Garden(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
            this.isRoofAccessible = par3Random.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.isRoofAccessible = par1NBTTagCompound.func_74767_n("Terrace");
        }

        public static House4Garden func_74912_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (int)par6);
            return StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) != null ? null : new House4Garden(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6);
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 0, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 0, 4, 4, 4, Blocks.field_150364_r, Blocks.field_150364_r, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 4, 1, 3, 4, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 3, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 3, 4, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 4, 3, 3, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 1, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 1, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 1, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 2, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 3, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 3, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 3, 1, 0, par3StructureBoundingBox);
            if (this.func_151548_a(par1World, 2, 0, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(par1World, 2, -1, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, par3StructureBoundingBox);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            if (this.isRoofAccessible) {
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 0, 5, 0, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 5, 0, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 2, 5, 0, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 3, 5, 0, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 5, 0, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 0, 5, 4, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 5, 4, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 2, 5, 4, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 3, 5, 4, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 5, 4, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 5, 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 5, 2, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 5, 3, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 0, 5, 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 0, 5, 2, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 0, 5, 3, par3StructureBoundingBox);
            }
            if (this.isRoofAccessible) {
                i = this.func_151555_a(Blocks.field_150468_ap, 3);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 3, 1, 3, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 3, 2, 3, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 3, 3, 3, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 3, 4, 3, par3StructureBoundingBox);
            }
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 2, 3, 1, par3StructureBoundingBox);
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(par1World, j, 6, i, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, j, -1, i, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Church
    extends Village {
        private static final String __OBFID = "CL_00000525";

        public Church() {
        }

        public Church(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
        }

        public static Church func_74919_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (int)par6);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new Church(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int j;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 0, 3, 0, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 0, 3, 10, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 10, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 10, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 4, 0, 4, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 0, 4, 4, 4, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 8, 3, 4, 8, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 5, 4, 3, 10, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 5, 5, 3, 5, 7, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 9, 0, 4, 9, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 0, 4, 4, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 0, 11, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 4, 11, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 2, 11, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 2, 11, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 1, 1, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 1, 1, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 2, 1, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 3, 1, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 3, 1, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 1, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 1, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 3, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 1), 1, 2, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 0), 3, 2, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 6, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 7, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 6, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 7, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 6, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 7, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 6, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 7, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 3, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 3, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 2, 4, 7, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 1, 4, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 3, 4, 6, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 2, 4, 5, par3StructureBoundingBox);
            int i = this.func_151555_a(Blocks.field_150468_ap, 4);
            for (j = 1; j <= 9; ++j) {
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 3, j, 3, par3StructureBoundingBox);
            }
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 2, 0, par3StructureBoundingBox);
            this.func_74881_a(par1World, par3StructureBoundingBox, par2Random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(par1World, 2, 0, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(par1World, 2, -1, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, par3StructureBoundingBox);
            }
            for (j = 0; j < 9; ++j) {
                for (int k = 0; k < 5; ++k) {
                    this.func_74871_b(par1World, k, 12, j, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, k, -1, j, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return 2;
        }
    }

    public static class House1
    extends Village {
        private static final String __OBFID = "CL_00000517";

        public House1() {
        }

        public House1(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
        }

        public static House1 func_74898_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (int)par6);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new House1(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int l;
            int k;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 8, 0, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 0, 8, 5, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 6, 1, 8, 6, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 7, 2, 8, 7, 3, Blocks.field_150347_e, Blocks.field_150347_e, false);
            int i = this.func_151555_a(Blocks.field_150476_ad, 3);
            int j = this.func_151555_a(Blocks.field_150476_ad, 2);
            for (k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    this.func_151550_a(par1World, Blocks.field_150476_ad, i, l, 6 + k, k, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150476_ad, j, l, 6 + k, 5 - k, par3StructureBoundingBox);
                }
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 0, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 5, 8, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 1, 0, 8, 1, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 1, 0, 7, 1, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 2, 0, 0, 4, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 2, 5, 0, 4, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 2, 5, 8, 4, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 2, 0, 8, 4, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 2, 1, 0, 4, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 2, 5, 7, 4, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 2, 1, 8, 4, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 2, 0, 7, 4, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 5, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 6, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 4, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 5, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 6, 3, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 3, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 3, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 3, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 5, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 6, 2, 5, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 4, 1, 7, 4, 1, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 4, 4, 7, 4, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 7, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 0), 7, 1, 3, par3StructureBoundingBox);
            k = this.func_151555_a(Blocks.field_150476_ad, 3);
            this.func_151550_a(par1World, Blocks.field_150476_ad, k, 6, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, k, 5, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, k, 4, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, k, 3, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 6, 1, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150452_aw, 0, 6, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 1, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150452_aw, 0, 4, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150462_ai, 0, 7, 1, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 1, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 1, 2, 0, par3StructureBoundingBox);
            this.func_74881_a(par1World, par3StructureBoundingBox, par2Random, 1, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(par1World, 1, 0, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(par1World, 1, -1, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 1, 0, -1, par3StructureBoundingBox);
            }
            for (l = 0; l < 6; ++l) {
                for (int i1 = 0; i1 < 9; ++i1) {
                    this.func_74871_b(par1World, i1, 9, l, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, i1, -1, l, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        private static final String __OBFID = "CL_00000522";

        public Hall() {
        }

        public Hall(Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par5;
            this.field_74887_e = par4StructureBoundingBox;
        }

        public static Hall func_74906_a(Start par0ComponentVillageStartPiece, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (int)par6);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)structureboundingbox) == null ? new Hall(par0ComponentVillageStartPiece, par7, par2Random, structureboundingbox, par6) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int l;
            int k;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d, Blocks.field_150346_d, false);
            this.func_151550_a(par1World, Blocks.field_150347_e, 0, 6, 0, 6, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 1, 6, 2, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 1, 6, 8, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 10, 7, 1, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 0, 0, 8, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 0, 7, 1, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 5, 7, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 2, 0, 7, 3, 0, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 2, 5, 7, 3, 5, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 1, 8, 4, 1, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 4, 4, 8, 4, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 2, 8, 5, 3, Blocks.field_150344_f, Blocks.field_150344_f, false);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 0, 4, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 0, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 8, 4, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 8, 4, 3, par3StructureBoundingBox);
            int i = this.func_151555_a(Blocks.field_150476_ad, 3);
            int j = this.func_151555_a(Blocks.field_150476_ad, 2);
            for (k = -1; k <= 2; ++k) {
                for (l = 0; l <= 8; ++l) {
                    this.func_151550_a(par1World, Blocks.field_150476_ad, i, l, 4 + k, k, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150476_ad, j, l, 4 + k, 5 - k, par3StructureBoundingBox);
                }
            }
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 0, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 8, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150364_r, 0, 8, 2, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 0, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 8, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 2, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 3, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 5, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150410_aZ, 0, 6, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 2, 1, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150452_aw, 0, 2, 2, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150344_f, 0, 1, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 3), 2, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150476_ad, this.func_151555_a(Blocks.field_150476_ad, 1), 1, 1, 3, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 0, 1, 7, 0, 3, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_151550_a(par1World, (Block)Blocks.field_150334_T, 0, 6, 1, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150334_T, 0, 6, 1, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 1, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 2, 0, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 2, 3, 1, par3StructureBoundingBox);
            this.func_74881_a(par1World, par3StructureBoundingBox, par2Random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
            if (this.func_151548_a(par1World, 2, 0, -1, par3StructureBoundingBox).func_149688_o() == Material.field_151579_a && this.func_151548_a(par1World, 2, -1, -1, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) {
                this.func_151550_a(par1World, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, par3StructureBoundingBox);
            }
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 6, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 6, 2, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 6, 3, 4, par3StructureBoundingBox);
            this.func_74881_a(par1World, par3StructureBoundingBox, par2Random, 6, 1, 5, this.func_151555_a(Blocks.field_150466_ao, 1));
            for (k = 0; k < 5; ++k) {
                for (l = 0; l < 9; ++l) {
                    this.func_74871_b(par1World, l, 7, k, par3StructureBoundingBox);
                    this.func_151554_b(par1World, Blocks.field_150347_e, 0, l, -1, k, par3StructureBoundingBox);
                }
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return par1 == 0 ? 4 : 0;
        }
    }

    static abstract class Village
    extends StructureComponent {
        protected int field_143015_k = -1;
        private int villagersSpawned;
        private boolean field_143014_b;
        private static final String __OBFID = "CL_00000531";
        private Start startPiece;

        public Village() {
        }

        protected Village(Start par1ComponentVillageStartPiece, int par2) {
            super(par2);
            if (par1ComponentVillageStartPiece != null) {
                this.field_143014_b = par1ComponentVillageStartPiece.inDesert;
                this.startPiece = par1ComponentVillageStartPiece;
            }
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74768_a("HPos", this.field_143015_k);
            par1NBTTagCompound.func_74768_a("VCount", this.villagersSpawned);
            par1NBTTagCompound.func_74757_a("Desert", this.field_143014_b);
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            this.field_143015_k = par1NBTTagCompound.func_74762_e("HPos");
            this.villagersSpawned = par1NBTTagCompound.func_74762_e("VCount");
            this.field_143014_b = par1NBTTagCompound.func_74767_n("Desert");
        }

        protected StructureComponent getNextComponentNN(Start par1ComponentVillageStartPiece, List par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 1: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
                case 2: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 3: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start par1ComponentVillageStartPiece, List par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 1: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
                case 2: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 3: {
                    return StructureHellVillagePieces.getNextVillageStructureComponent(par1ComponentVillageStartPiece, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
            }
            return null;
        }

        protected int getAverageGroundLevel(World par1World, StructureBoundingBox par2StructureBoundingBox) {
            int i = 0;
            int j = 0;
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    if (!par2StructureBoundingBox.func_78890_b(l, 64, k)) continue;
                    i += Math.max(par1World.func_72825_h(l, k), par1World.field_73011_w.func_76557_i());
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox par0StructureBoundingBox) {
            return par0StructureBoundingBox != null && par0StructureBoundingBox.field_78895_b > 10;
        }

        protected void spawnVillagers(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6) {
            if (this.villagersSpawned < par6) {
                int l1;
                int k1;
                int j1;
                for (int i1 = this.villagersSpawned; i1 < par6 && par2StructureBoundingBox.func_78890_b(j1 = this.func_74865_a(par3 + i1, par5), k1 = this.func_74862_a(par4), l1 = this.func_74873_b(par3 + i1, par5)); ++i1) {
                    ++this.villagersSpawned;
                    EntityVillager entityvillager = new EntityVillager(par1World, this.getVillagerType(i1));
                    entityvillager.func_70012_b((double)j1 + 0.5, (double)k1, (double)l1 + 0.5, 0.0f, 0.0f);
                    par1World.func_72838_d((Entity)entityvillager);
                }
            }
        }

        protected int getVillagerType(int par1) {
            return 0;
        }

        protected Block func_151558_b(Block p_151558_1_, int p_151558_2_) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, p_151558_1_, p_151558_2_);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.replacement;
            }
            if (this.field_143014_b) {
                if (p_151558_1_ == Blocks.field_150364_r || p_151558_1_ == Blocks.field_150363_s) {
                    return Blocks.field_150322_A;
                }
                if (p_151558_1_ == Blocks.field_150347_e) {
                    return Blocks.field_150322_A;
                }
                if (p_151558_1_ == Blocks.field_150344_f) {
                    return Blocks.field_150322_A;
                }
                if (p_151558_1_ == Blocks.field_150476_ad) {
                    return Blocks.field_150372_bz;
                }
                if (p_151558_1_ == Blocks.field_150446_ar) {
                    return Blocks.field_150372_bz;
                }
                if (p_151558_1_ == Blocks.field_150351_n) {
                    return Blocks.field_150322_A;
                }
            }
            return p_151558_1_;
        }

        protected int func_151557_c(Block p_151557_1_, int p_151557_2_) {
            BiomeEvent.GetVillageBlockMeta event = new BiomeEvent.GetVillageBlockMeta(this.startPiece == null ? null : this.startPiece.biome, p_151557_1_, p_151557_2_);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.replacement;
            }
            if (this.field_143014_b) {
                if (p_151557_1_ == Blocks.field_150364_r || p_151557_1_ == Blocks.field_150363_s) {
                    return 0;
                }
                if (p_151557_1_ == Blocks.field_150347_e) {
                    return 0;
                }
                if (p_151557_1_ == Blocks.field_150344_f) {
                    return 2;
                }
            }
            return p_151557_2_;
        }

        protected void func_151550_a(World p_151550_1_, Block p_151550_2_, int p_151550_3_, int p_151550_4_, int p_151550_5_, int p_151550_6_, StructureBoundingBox p_151550_7_) {
            Block block1 = this.func_151558_b(p_151550_2_, p_151550_3_);
            int i1 = this.func_151557_c(p_151550_2_, p_151550_3_);
            super.func_151550_a(p_151550_1_, block1, i1, p_151550_4_, p_151550_5_, p_151550_6_, p_151550_7_);
        }

        protected void func_151549_a(World p_151549_1_, StructureBoundingBox p_151549_2_, int p_151549_3_, int p_151549_4_, int p_151549_5_, int p_151549_6_, int p_151549_7_, int p_151549_8_, Block p_151549_9_, Block p_151549_10_, boolean p_151549_11_) {
            Block block2 = this.func_151558_b(p_151549_9_, 0);
            int k1 = this.func_151557_c(p_151549_9_, 0);
            Block block3 = this.func_151558_b(p_151549_10_, 0);
            int l1 = this.func_151557_c(p_151549_10_, 0);
            super.func_151556_a(p_151549_1_, p_151549_2_, p_151549_3_, p_151549_4_, p_151549_5_, p_151549_6_, p_151549_7_, p_151549_8_, block2, k1, block3, l1, p_151549_11_);
        }

        protected void func_151554_b(World p_151554_1_, Block p_151554_2_, int p_151554_3_, int p_151554_4_, int p_151554_5_, int p_151554_6_, StructureBoundingBox p_151554_7_) {
            Block block1 = this.func_151558_b(p_151554_2_, p_151554_3_);
            int i1 = this.func_151557_c(p_151554_2_, p_151554_3_);
            super.func_151554_b(p_151554_1_, block1, i1, p_151554_4_, p_151554_5_, p_151554_6_, p_151554_7_);
        }
    }

    public static class Well
    extends Village {
        private static final String __OBFID = "CL_00000533";

        public Well() {
        }

        public Well(Start par1ComponentVillageStartPiece, int par2, Random par3Random, int par4, int par5) {
            super(par1ComponentVillageStartPiece, par2);
            this.field_74885_f = par3Random.nextInt(4);
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(par4, 64, par5, par4 + 6 - 1, 78, par5 + 6 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(par4, 64, par5, par4 + 6 - 1, 78, par5 + 6 - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, 1, this.func_74877_c());
            StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, 3, this.func_74877_c());
            StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
            StructureHellVillagePieces.getNextComponentVillagePath((Start)par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 3, 0);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 0, 1, 4, 12, 4, Blocks.field_150347_e, (Block)Blocks.field_150358_i, false);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 12, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 3, 12, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, 12, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150350_a, 0, 3, 12, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 13, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 14, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 13, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 14, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 13, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 1, 14, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 13, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150422_aJ, 0, 4, 14, 4, par3StructureBoundingBox);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 15, 1, 4, 15, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_151550_a(par1World, Blocks.field_150351_n, 0, j, 11, i, par3StructureBoundingBox);
                    this.func_74871_b(par1World, j, 12, i, par3StructureBoundingBox);
                }
            }
            return true;
        }
    }
}

