/*
 * Decompiled with CFR 0.152.
 */
package NEILootbags.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import mal.lootbags.Bag;
import mal.lootbags.LootBags;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.item.LootbagItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEILootbagHandler
extends TemplateRecipeHandler {
    private static final int X_FIRST_ITEM = 2;
    private static final int Y_FIRST_ITEM = 51;
    private static final int ITEMS_PER_PAGE = 36;
    private static final int SPACING_X = 18;
    private static final int SPACING_Y = 20;
    private static int bagtype;
    private static int lastRecipe;
    private static int CYCLE_TIME;

    public String getRecipeName() {
        return "Lootbag's Loot";
    }

    public String getGuiTexture() {
        return "neilootbags:textures/gui/NEILootGUI1.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)130);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(ItemStack result) {
        bagtype = 0;
        block0: for (int k = 0; k < BagHandler.getHighestUsedID(); ++k) {
            Bag b = BagHandler.getBag((int)k);
            for (int i = 0; i < b.getMap().size(); ++i) {
                if (LootBags.areItemStacksEqualItem((ItemStack)b.getSpecificItem(i), (ItemStack)result, (boolean)true, (boolean)true)) {
                    this.arecipes.add(new CachedLootRecipe(k));
                    bagtype = k;
                    lastRecipe = -1;
                    continue block0;
                }
                super.loadCraftingRecipes(result);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        bagtype = 0;
        if (ingredient.func_77973_b() instanceof LootbagItem) {
            int meta = ingredient.func_77960_j();
            Bag b = BagHandler.getBag((int)meta);
            this.arecipes.add(new CachedLootRecipe(meta));
            bagtype = meta;
            lastRecipe = -1;
        } else {
            super.loadUsageRecipes(ingredient);
        }
    }

    public void drawExtras(int recipe) {
        CachedLootRecipe cachedloot = (CachedLootRecipe)((Object)this.arecipes.get(recipe));
        cachedloot.cycleOutputs(this.cycleticks, recipe);
    }

    static {
        lastRecipe = -1;
        CYCLE_TIME = 40;
    }

    public class CachedLootRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ItemStack stack;
        public int set;
        public int lastSet;
        private long cycleAt;
        public List<ItemStack> outputs;

        public CachedLootRecipe(int bagtype) {
            super((TemplateRecipeHandler)NEILootbagHandler.this);
            this.set = 0;
            this.cycleAt = -1L;
            this.outputs = new ArrayList<ItemStack>();
            Bag b = BagHandler.getBag((int)bagtype);
            for (int i = 0; i < b.getMap().size(); ++i) {
                this.outputs.add(b.getSpecificItem(i));
                this.lastSet = this.outputs.size() / 37;
            }
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)new ItemStack((Item)LootBags.lootbagItem, 1, bagtype), 75, 5);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.outputs.get(this.set * 36), 2, 51);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            int x = 2;
            int y = 51;
            for (int i = 36 * this.set; i < 36 * this.set + 36 && i < this.outputs.size(); ++i) {
                list.add(new PositionedStack((Object)this.outputs.get(i), x, y));
                if ((y += 20) < 131) continue;
                y = 51;
                x += 18;
            }
            if (list.size() > 0) {
                list.remove(0);
            }
            return list;
        }

        public void cycleOutputs(long tick, int recipe) {
            if (this.cycleAt == -1L || recipe != lastRecipe) {
                lastRecipe = recipe;
                this.cycleAt = tick + (long)CYCLE_TIME;
                return;
            }
            if (tick >= this.cycleAt) {
                if (++this.set > this.lastSet) {
                    this.set = 0;
                }
                this.cycleAt += (long)CYCLE_TIME;
            }
        }
    }
}

