/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm;

import com.builtbroken.icbm.CommonProxy;
import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.client.CreativeTabExplosives;
import com.builtbroken.icbm.client.CreativeTabMissiles;
import com.builtbroken.icbm.client.CreativeTabWarheads;
import com.builtbroken.icbm.client.ICBMCreativeTab;
import com.builtbroken.icbm.content.blast.biome.ExBiomeChange;
import com.builtbroken.icbm.content.blast.entity.slime.EntitySlimeRain;
import com.builtbroken.icbm.content.blast.explosive.BlastPathTester;
import com.builtbroken.icbm.content.blast.fragment.ExFragment;
import com.builtbroken.icbm.content.blast.item.BlockFakeCake;
import com.builtbroken.icbm.content.cow.EntityGaintCow;
import com.builtbroken.icbm.content.debug.BlockEntityDisplay;
import com.builtbroken.icbm.content.debug.BlockExplosiveMarker;
import com.builtbroken.icbm.content.fragments.EntityFragment;
import com.builtbroken.icbm.content.fragments.FragmentEventHandler;
import com.builtbroken.icbm.content.items.ItemExplosive;
import com.builtbroken.icbm.content.items.parts.ItemExplosiveParts;
import com.builtbroken.icbm.content.launcher.block.LauncherPartListener;
import com.builtbroken.icbm.content.launcher.block.TileLauncherFrame;
import com.builtbroken.icbm.content.launcher.controller.direct.TileSiloController;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.BlockAntennaParts;
import com.builtbroken.icbm.content.launcher.controller.remote.central.TileCommandController;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.TileCommandSiloConnector;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.missile.entity.EntityTypeCheckMissile;
import com.builtbroken.icbm.content.missile.json.MissileJsonProcessor;
import com.builtbroken.icbm.content.missile.parts.engine.Engines;
import com.builtbroken.icbm.content.missile.parts.engine.ItemEngineModules;
import com.builtbroken.icbm.content.missile.parts.guidance.GuidanceModules;
import com.builtbroken.icbm.content.missile.parts.guidance.ItemGuidanceModules;
import com.builtbroken.icbm.content.missile.parts.trigger.ItemTriggerModules;
import com.builtbroken.icbm.content.missile.parts.trigger.Triggers;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import com.builtbroken.icbm.content.missile.tile.TileCrashedMissile;
import com.builtbroken.icbm.content.missile.tracking.MissileTracker;
import com.builtbroken.icbm.content.rail.EntityMissileCart;
import com.builtbroken.icbm.content.rail.ItemMissileCart;
import com.builtbroken.icbm.content.rocketlauncher.ItemRocketLauncher;
import com.builtbroken.icbm.content.warhead.TileWarhead;
import com.builtbroken.icbm.server.CommandICBM;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.mod.AbstractMod;
import com.builtbroken.mc.framework.mod.ModCreativeTab;
import com.builtbroken.mc.prefab.entity.type.EntityTypeCheck;
import com.builtbroken.mc.prefab.entity.type.EntityTypeCheckRegistry;
import com.builtbroken.mc.prefab.explosive.ExplosiveHandlerGeneric;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.item.ItemBlockMetadata;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockListenerProcessor;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="icbm", name="ICBM", version="2.15.4.497", dependencies="required-after:voltzengine@[1.9.14,);after:OpenComputers")
public final class ICBM
extends AbstractMod {
    public static final String NAME = "ICBM";
    public static final String DOMAIN = "icbm";
    public static final String PREFIX = "icbm:";
    public static final String MAJOR_VERSION = "2";
    public static final String MINOR_VERSION = "15";
    public static final String REVISION_VERSION = "4";
    public static final String BUILD_VERSION = "497";
    public static final String VERSION = "2.15.4.497";
    public static final String DEPENDENCIES = "required-after:voltzengine@[1.9.14,);after:OpenComputers";
    @Mod.Instance(value="icbm")
    public static ICBM INSTANCE;
    @SidedProxy(clientSide="com.builtbroken.icbm.client.ClientProxy", serverSide="com.builtbroken.icbm.server.ServerProxy")
    public static CommonProxy proxy;
    public static boolean ANTIMATTER_BREAK_UNBREAKABLE;
    public static boolean DEBUG_MISSILE_MANAGER;
    public static float missile_firing_volume;
    public static float missile_engine_volume;
    public static float ams_gun_volume;
    public static float ams_rotation_volume;
    public static int ENTITY_ID_PREFIX;
    public final ModCreativeTab CREATIVE_TAB = new ICBMCreativeTab();
    private static boolean registerExplosives;
    public static boolean APRIL_FIRST;
    public static CreativeTabMissiles[] missileTabs;
    public static CreativeTabWarheads warheadsTab;
    public static CreativeTabExplosives explosiveTab;

    public ICBM() {
        super(DOMAIN, NAME);
        this.manager.setTab((CreativeTabs)this.CREATIVE_TAB);
        explosiveTab = new CreativeTabExplosives();
        missileTabs = new CreativeTabMissiles[]{new CreativeTabMissiles(MissileSize.MICRO), new CreativeTabMissiles(MissileSize.SMALL), new CreativeTabMissiles(MissileSize.STANDARD), new CreativeTabMissiles(MissileSize.MEDIUM)};
        warheadsTab = new CreativeTabWarheads();
        this.fireProxyPreInit = false;
        Calendar now = Calendar.getInstance();
        APRIL_FIRST = now.get(2) + 1 == 4 && now.get(5) == 1;
    }

    public void loadJsonContentHandlers() {
        super.loadJsonContentHandlers();
        JsonContentLoader.INSTANCE.add((IJsonProcessor)new MissileJsonProcessor());
        JsonBlockListenerProcessor.addBuilder((ITileEventListenerBuilder)new LauncherPartListener.Builder());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)FragmentEventHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)this);
        Engine.heatedRockRequested = true;
        Engine.requestResources();
        Engine.requestSheetMetalContent();
        Engine.requestMultiBlock();
        Engine.requestSimpleTools();
        Engine.requestCircuits();
        Engine.requestCraftingParts();
        ANTIMATTER_BREAK_UNBREAKABLE = this.getConfig().getBoolean("Antimatter_Destroy_Unbreakable", "general", true, "Allows antimatter to break blocks that are unbreakable, bedrock for example.");
        DEBUG_MISSILE_MANAGER = this.getConfig().getBoolean("Missile_Manager", "Debug", Engine.runningAsDev, "Adds additional info to the console");
        missile_firing_volume = this.getConfig().getFloat("missile_firing", "volume", 1.0f, 0.0f, 1.0f, "How loud the missile is when fired from launchers");
        missile_engine_volume = this.getConfig().getFloat("missile_engine", "volume", 1.0f, 0.0f, 1.0f, "How loud the missile engine is while running");
        ams_gun_volume = this.getConfig().getFloat("ams_gun", "volume", 1.0f, 0.0f, 4.0f, "How loud the gun firing is for the AMS turret");
        ams_rotation_volume = this.getConfig().getFloat("ams_rotation", "volume", 1.0f, 0.0f, 1.0f, "How loud the rotation audio is for the AMS turret");
        this.loader.preInit();
        ICBM_API.blockWarhead = this.manager.newBlock(TileWarhead.class, new Object[0]);
        ICBM_API.blockCrashMissile = this.manager.newBlock("icbmCrashedMissile", TileCrashedMissile.class, new Object[0]);
        ICBM_API.blockLauncherFrame = this.manager.newBlock("icbmLauncherFrame", TileLauncherFrame.class, new Object[0]);
        if (ICBM_API.blockDirectSiloController == null) {
            ICBM_API.blockDirectSiloController = this.manager.newBlock("icbmDirectSiloConnector", TileSiloController.class, new Object[0]);
        }
        ICBM_API.blockAntenna = this.manager.newBlock("icbmAntenna", BlockAntennaParts.class, ItemBlockMetadata.class);
        ICBM_API.blockCommandCentral = this.manager.newBlock("icbmCommandCentral", TileCommandController.class, new Object[0]);
        ICBM_API.blockCommandSiloConnector = this.manager.newBlock("icbmCommandSiloController", TileCommandSiloConnector.class, new Object[0]);
        ICBM_API.blockStandardLauncher = InventoryUtility.getBlock((String)"icbm:standardlauncher");
        ICBM_API.blockCake = this.manager.newBlock("ICBMxFakeCake", BlockFakeCake.class);
        if (Engine.runningAsDev) {
            ICBM_API.blockExplosiveMarker = this.manager.newBlock(BlockExplosiveMarker.class, ItemBlockMetadata.class);
            Block block = this.manager.newBlock(BlockEntityDisplay.class);
            this.manager.registerTileEntity("tileEntityDisplayDebug", block, (TileEntity)new BlockEntityDisplay.TileEntityDisplay());
        }
        if (Loader.isModLoaded((String)"assemblyline")) {
            ICBM_API.itemMissileCart = this.manager.newItem("icbmMissileCart", ItemMissileCart.class, new Object[0]);
        }
        ICBM_API.itemRocketLauncher = this.manager.newItem("rocketLauncher", ItemRocketLauncher.class, new Object[0]);
        ICBM_API.itemEngineModules = this.manager.newItem("engineModules", ItemEngineModules.class, new Object[0]);
        ICBM_API.itemGuidanceModules = this.manager.newItem("guidanceModules", ItemGuidanceModules.class, new Object[0]);
        ICBM_API.itemExplosive = this.manager.newItem("explosiveUnit", ItemExplosive.class, new Object[0]);
        ICBM_API.itemExplosivePart = this.manager.newItem("explosiveUnitParts", ItemExplosiveParts.class, new Object[0]);
        ICBM_API.itemTrigger = this.manager.newItem("icbmTriggers", ItemTriggerModules.class, new Object[0]);
        WarheadCasings.register();
        Engines.register();
        GuidanceModules.register();
        Triggers.register();
        this.CREATIVE_TAB.itemStack = new ItemStack(InventoryUtility.getItem((String)"icbm:icbmRemoteDet"));
        ICBM.warheadsTab.itemStack = new ItemStack(ICBM_API.blockWarhead);
        ICBM.explosiveTab.itemStack = ItemExplosiveParts.ExplosiveParts.GUNPOWDER_CHARGE.newItem();
        this.getProxy().registerExplosives();
    }

    public static void registerExplosives() {
        if (!registerExplosives) {
            registerExplosives = true;
            ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"Fragment", (IExplosiveHandler)new ExFragment());
            ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"ArrowFragment", (IExplosiveHandler)ExplosiveRegistry.get((String)"Fragment"));
            ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"BiomeChange", (IExplosiveHandler)new ExBiomeChange());
            if (Engine.runningAsDev) {
                ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"SimplePathTest1", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest1", BlastPathTester.class, 1));
                ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"SimplePathTest2", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest2", BlastPathTester.class, 2));
                ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"SimplePathTest3", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest3", BlastPathTester.class, 3));
                ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"SimplePathTest10", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest10", BlastPathTester.class, 10));
                ExplosiveRegistry.registerOrGetExplosive((String)DOMAIN, (String)"SimplePathTest20", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest20", BlastPathTester.class, 20));
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EntityTypeCheckRegistry.register((EntityTypeCheck)new EntityTypeCheckMissile());
        EntityRegistry.registerModEntity(EntityMissile.class, (String)"ICBMMissile", (int)this.getConfig().getInt("missile", "entityIDs", ENTITY_ID_PREFIX + 3, 0, 1000, "Internal mod entity ID to use"), (Object)((Object)this), (int)500, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityFragment.class, (String)"ICBMFragment", (int)this.getConfig().getInt("fragments", "entityIDs", ENTITY_ID_PREFIX + 5, 0, 1000, "Internal mod entity ID to use"), (Object)((Object)this), (int)500, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityMissileCart.class, (String)"ICBMMissileCart", (int)this.getConfig().getInt("missile_cart", "entityIDs", ENTITY_ID_PREFIX + 5, 0, 1000, "Internal mod entity ID to use"), (Object)((Object)this), (int)500, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntitySlimeRain.class, (String)"ICBMSlime", (int)this.getConfig().getInt("slime", "entityIDs", ENTITY_ID_PREFIX + 6, 0, 1000, "Internal mod entity ID to use"), (Object)((Object)this), (int)500, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityGaintCow.class, (String)"ICBMGCow", (int)this.getConfig().getInt("g_cow", "entityIDs", ENTITY_ID_PREFIX + 7, 0, 1000, "Internal mod entity ID to use"), (Object)((Object)this), (int)500, (int)1, (boolean)true);
        if (this.getConfig().getBoolean("registerEntitiesGlobally", "legacy", false, "Only enable this if there are issues loading older worlds containing entities from this mod.")) {
            EntityRegistry.registerGlobalEntityID(EntityMissile.class, (String)"ICBMMissile", (int)EntityRegistry.findGlobalUniqueEntityId());
            EntityRegistry.registerGlobalEntityID(EntityFragment.class, (String)"ICBMFragment", (int)EntityRegistry.findGlobalUniqueEntityId());
            EntityRegistry.registerGlobalEntityID(EntityMissileCart.class, (String)"ICBMMissileCart", (int)EntityRegistry.findGlobalUniqueEntityId());
            EntityRegistry.registerGlobalEntityID(EntitySlimeRain.class, (String)"ICBMSlime", (int)EntityRegistry.findGlobalUniqueEntityId());
        }
        this.initAPI();
        super.init(event);
    }

    protected void initAPI() {
        ICBM_API.itemMissile = (Item)Item.field_150901_e.func_82594_a("icbm:missile");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ArrayList dustCharcoal = OreDictionary.getOres((String)"dustCharcoal");
        ArrayList dustCoal = OreDictionary.getOres((String)"dustCoal");
        if (this.getConfig().getBoolean("Charcoal_gunpowder_recipe", "Extra", true, "Enables a dust recipe of sulfur, saltpeter, and charcoal to make gunpowder")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 2), new Object[]{"dustSulfur", "dustSaltpeter", Items.field_151044_h}));
        }
        if (this.getConfig().getBoolean("Charcoal_gunpowder_recipe", "Extra", true, "Enables a recipe of sulfur, saltpeter, and charcoal to make gunpowder")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 2), new Object[]{"dustSulfur", "dustSaltpeter", new ItemStack(Items.field_151044_h, 1, 1)}));
        }
        if (this.getConfig().getBoolean("Charcoal_dust_gunpowder_recipe", "Extra", true, "Enables a recipe of sulfur, saltpeter, and charcoal to make gunpowder") && dustCharcoal != null && dustCharcoal.size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 2), new Object[]{"dustSulfur", "dustSaltpeter", "dustCharcoal"}));
        }
        if (this.getConfig().getBoolean("Coal_dust_gunpowder_recipe", "Extra", true, "Enables a dust recipe of sulfur, saltpeter, and coal to make gunpowder") && dustCoal != null && dustCoal.size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 2), new Object[]{"dustSulfur", "dustSaltpeter", "dustCoal"}));
        }
        if (this.getConfig().getBoolean("Redstone_TNT_recipe", "Extra", true, "Enables a cheaper/easier tnt recipe using gunpowder surrounding a redstone dust. This recipe is designed to make it easier to craft tnt without mining a lot of material.")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Blocks.field_150335_W, new Object[]{"@@@", "@R@", "@@@", Character.valueOf('@'), Items.field_151016_H, Character.valueOf('R'), Items.field_151137_ax}));
        }
        super.postInit(event);
    }

    public CommonProxy getProxy() {
        return proxy;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new CommandICBM());
    }

    @SubscribeEvent
    public void onWorldTickEnd(TickEvent.WorldTickEvent evt) {
        MissileTracker tracker;
        if (evt.side == Side.SERVER && evt.phase == TickEvent.Phase.END && (tracker = MissileTracker.getTrackerForWorld(evt.world)) != null) {
            tracker.update(evt.world);
        }
    }

    static {
        ANTIMATTER_BREAK_UNBREAKABLE = true;
        DEBUG_MISSILE_MANAGER = false;
        missile_firing_volume = 1.0f;
        missile_engine_volume = 1.0f;
        ams_gun_volume = 1.0f;
        ams_rotation_volume = 1.0f;
        ENTITY_ID_PREFIX = 50;
    }
}

