/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.client;

import com.builtbroken.icbm.CommonProxy;
import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.client.ec.ECBiomeChange;
import com.builtbroken.icbm.client.ec.ECFragment;
import com.builtbroken.icbm.content.blast.entity.slime.EntitySlimeRain;
import com.builtbroken.icbm.content.blast.entity.slime.RenderSlimeRain;
import com.builtbroken.icbm.content.blast.explosive.BlastPathTester;
import com.builtbroken.icbm.content.cow.EntityGaintCow;
import com.builtbroken.icbm.content.cow.RenderEntityGaintCow;
import com.builtbroken.icbm.content.crafting.station.small.auto.TileSMAutoRenderListener;
import com.builtbroken.icbm.content.debug.BlockEntityDisplay;
import com.builtbroken.icbm.content.fragments.EntityFragment;
import com.builtbroken.icbm.content.fragments.RenderFragment;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.ItemRendererAntennaFrame;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TESRAntenna;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TileAntennaPart;
import com.builtbroken.icbm.content.launcher.controller.remote.display.TileSiloInterfaceClient;
import com.builtbroken.icbm.content.launcher.launcher.StandardLauncherRenderListener;
import com.builtbroken.icbm.content.launcher.listeners.TileMissileRenderListener;
import com.builtbroken.icbm.content.missile.client.RenderMissile;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.rail.EntityMissileCart;
import com.builtbroken.icbm.content.rail.RenderMissileCart;
import com.builtbroken.icbm.content.rocketlauncher.RenderRocketLauncher;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.client.SharedAssets;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IEffectData;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.render.fx.FXElectricBolt;
import com.builtbroken.mc.lib.render.fx.FXElectricBoltSpawner;
import com.builtbroken.mc.lib.render.fx.FXEnderPortalPartical;
import com.builtbroken.mc.lib.render.fx.FXSmoke;
import com.builtbroken.mc.prefab.explosive.ExplosiveHandlerGeneric;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockListenerProcessor;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean disableReflectionFX = false;

    public void loadJsonContentHandlers() {
        super.loadJsonContentHandlers();
        JsonBlockListenerProcessor.addBuilder((ITileEventListenerBuilder)new TileMissileRenderListener.Builder());
        JsonBlockListenerProcessor.addBuilder((ITileEventListenerBuilder)new StandardLauncherRenderListener.Builder());
        JsonBlockListenerProcessor.addBuilder((ITileEventListenerBuilder)new TileSMAutoRenderListener.Builder());
    }

    public void preInit() {
        super.preInit();
        ICBM_API.blockCommandSiloDisplay = ICBM.INSTANCE.getManager().newBlock("icbmCommandSiloDisplay", TileSiloInterfaceClient.class, new Object[0]);
    }

    @Override
    public void init() {
        super.init();
        SharedAssets.loadResources();
        ClientRegistry.bindTileEntitySpecialRenderer(TileAntennaPart.class, (TileEntitySpecialRenderer)new TESRAntenna());
        if (Engine.runningAsDev) {
            ClientRegistry.bindTileEntitySpecialRenderer(BlockEntityDisplay.TileEntityDisplay.class, (TileEntitySpecialRenderer)new BlockEntityDisplay.TESRDisplay());
        }
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ICBM_API.blockAntenna), (IItemRenderer)new ItemRendererAntennaFrame());
        MinecraftForgeClient.registerItemRenderer((Item)ICBM_API.itemRocketLauncher, (IItemRenderer)new RenderRocketLauncher());
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, (Render)RenderMissile.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityMissileCart.class, (Render)new RenderMissileCart());
        RenderingRegistry.registerEntityRenderingHandler(EntityFragment.class, (Render)new RenderFragment());
        RenderingRegistry.registerEntityRenderingHandler(EntitySlimeRain.class, (Render)new RenderSlimeRain());
        RenderingRegistry.registerEntityRenderingHandler(EntityGaintCow.class, (Render)new RenderEntityGaintCow());
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public int getParticleSetting() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    @Override
    public void spawnParticle(String name, World world, Pos position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
        FXSmoke fx = null;
        if (name.equals("smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance);
        } else if (name.equals("missile_smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance).setAge(100);
        } else if (name.equals("portal")) {
            fx = new FXEnderPortalPartical(world, position, red, green, blue, scale, distance);
        } else if (!name.equals("antimatter")) {
            if (name.equals("digging")) {
                fx = new EntityDiggingFX(world, position.x(), position.y(), position.z(), motionX, motionY, motionZ, Block.func_149729_e((int)((int)red)), 0, (int)green);
                fx.func_70541_f(blue);
            } else if (name.equals("shockwave")) {
                // empty if block
            }
        }
        if (fx != null) {
            fx.field_70159_w = motionX;
            fx.field_70181_x = motionY;
            fx.field_70179_y = motionZ;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void spawnRocketTail(Entity entity) {
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa != 2) {
            IMissile missile;
            Pos motion = (Pos)new Pos(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).normalize();
            Pos vel = new Pos((double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f), (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f), (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f));
            vel = (Pos)vel.multiply((IPos3D)motion);
            if (entity instanceof EntityMissile && (missile = ((EntityMissile)entity).getMissile()).getEngine() != null) {
                String contentID;
                IEffectData data;
                NBTTagCompound tag;
                Color fireColor = missile.getEngine().getEngineFireColor(entity instanceof IMissileEntity ? (IMissileEntity)entity : null, missile);
                Color smokeColor = missile.getEngine().getEngineSmokeColor(entity instanceof IMissileEntity ? (IMissileEntity)entity : null, missile);
                NBTTagCompound nbt = new NBTTagCompound();
                if (fireColor != null) {
                    tag = new NBTTagCompound();
                    tag.func_74768_a("color", fireColor.getRGB());
                    nbt.func_74782_a("fireColor", (NBTBase)tag);
                }
                if (smokeColor != null) {
                    tag = new NBTTagCompound();
                    tag.func_74768_a("color", smokeColor.getRGB());
                    nbt.func_74782_a("smokeColor", (NBTBase)tag);
                }
                if (missile instanceof IJsonGenObject && (data = ClientDataHandler.INSTANCE.getEffect((contentID = ((IJsonGenObject)missile).getContentID()) + ".engine.trail")) != null) {
                    data.trigger(((EntityMissile)entity).oldWorld(), ((EntityMissile)entity).x(), ((EntityMissile)entity).y(), ((EntityMissile)entity).z(), vel.x(), vel.y(), vel.z(), false, nbt);
                }
            }
        }
    }

    @Override
    public void playRocketAudio(Entity entity) {
        entity.field_70170_p.func_72956_a(entity, "icbm:engine.main", ICBM.missile_engine_volume, 1.0f);
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBolt(world, (IPos3D)startVec, (IPos3D)targetVec, 0L));
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec, int duration) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBoltSpawner(world, (IPos3D)startVec, (IPos3D)targetVec, 0L, duration));
    }

    @Override
    public List<Entity> getEntityFXs() {
        if (!this.disableReflectionFX) {
            try {
                EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
                List[] fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)renderer, (int)2);
                return fxLayers[0];
            }
            catch (Exception e) {
                ICBM.INSTANCE.logger().log(Level.ERROR, "Failed to use reflection on entity effects.");
                e.printStackTrace();
                this.disableReflectionFX = true;
            }
        }
        return null;
    }

    @Override
    public void registerExplosives() {
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"Fragment", (IExplosiveHandler)new ECFragment());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ArrowFragment", (IExplosiveHandler)ExplosiveRegistry.get((String)"Fragment"));
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"BiomeChange", (IExplosiveHandler)new ECBiomeChange());
        if (Engine.runningAsDev) {
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest1", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest1", BlastPathTester.class, 1));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest2", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest2", BlastPathTester.class, 2));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest3", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest3", BlastPathTester.class, 3));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest10", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest10", BlastPathTester.class, 10));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest20", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest20", BlastPathTester.class, 20));
        }
    }
}

