/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.client.blast;

import com.builtbroken.icbm.content.blast.explosive.BlastAntimatter;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.render.fx.FXSmoke;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;

public class BlastAntimatterClient
extends BlastAntimatter {
    public BlastAntimatterClient(IExplosiveHandler handler) {
        super(handler);
    }

    @Override
    public void doStartDisplay() {
        Pos center = new Pos(this.x, this.y, this.z);
        int shells = Math.min((int)this.size, 10);
        for (int shell = 0; shell < shells; ++shell) {
            int rotations = Math.min((shell + 1) * 4, 60);
            int degreePerAngle = 360 / rotations;
            for (int yaw = 0; yaw < rotations; ++yaw) {
                for (int pitch = 0; pitch < rotations; ++pitch) {
                    EulerAngle rotation = new EulerAngle((double)(yaw * degreePerAngle), (double)(pitch * degreePerAngle));
                    Pos velocity = (Pos)rotation.toPos().multiply((double)((float)shells / (float)shells * 1.0f));
                    this.world.spawnParticle("smoke", center.x(), center.y(), center.z(), velocity.x(), velocity.y(), velocity.z());
                }
            }
        }
    }

    @Override
    public void doEndDisplay() {
        double d6 = Minecraft.func_71410_x().field_71451_h.field_70165_t - this.x;
        double d7 = Minecraft.func_71410_x().field_71451_h.field_70163_u - this.y;
        double d8 = Minecraft.func_71410_x().field_71451_h.field_70161_v - this.z;
        double d9 = 20.0;
        if (!(d6 * d6 + d7 * d7 + d8 * d8 > d9 * d9)) {
            Pos center = new Pos(this.x, this.y, this.z);
            int shells = Math.min((int)this.size, 10);
            for (int shell = 0; shell < shells; ++shell) {
                int rotations = Math.min((shell + 1) * 4, 20);
                int degreePerAngle = 360 / rotations;
                for (int yaw = 0; yaw < rotations; ++yaw) {
                    for (int pitch = 0; pitch < rotations; ++pitch) {
                        EulerAngle rotation = new EulerAngle((double)(yaw * degreePerAngle), (double)(pitch * degreePerAngle));
                        Pos velocity = (Pos)rotation.toPos().multiply((double)((float)shells / (float)shells) * 0.8);
                        FXSmoke entity = new FXSmoke(this.oldWorld, (Pos)center.add((IPos3D)velocity.multiply((double)(1 + shell / 4))), velocity, Color.RED.darker(), 1.0f, 10.0, true);
                        entity.field_70145_X = true;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entity);
                    }
                }
            }
        }
    }
}

