/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.client.blast;

import com.builtbroken.icbm.content.blast.fragment.BlastFragments;
import com.builtbroken.icbm.content.blast.fragment.FragBlastType;
import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;

public class BlastFragmentsClient
extends BlastFragments {
    public BlastFragmentsClient(IExplosiveHandler handler, FragBlastType type) {
        super(handler, type);
    }

    @Override
    public void doStartDisplay() {
        if (this.size >= 2.0) {
            this.world.spawnParticle("hugeexplosion", this.x, this.y, this.z, 1.0, 0.0, 0.0);
        } else {
            this.world.spawnParticle("largeexplode", this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
    }

    @Override
    public void doEndDisplay() {
        Pos center = new Pos(this.x, this.y, this.z);
        int shells = Math.min((int)this.size, 10);
        for (int shell = 0; shell < shells; ++shell) {
            int rotations = Math.min((shell + 1) * 4, 60);
            int degreePerAngle = 360 / rotations;
            for (int yaw = 0; yaw < rotations; ++yaw) {
                for (int pitch = 0; pitch < rotations; ++pitch) {
                    EulerAngle rotation = new EulerAngle((double)(yaw * degreePerAngle), (double)(pitch * degreePerAngle));
                    Pos velocity = (Pos)rotation.toPos().multiply((double)((float)shells / (float)shells * 1.0f));
                    if (MathHelper.rand.nextBoolean()) {
                        this.world.spawnParticle("flame", center.x(), center.y(), center.z(), velocity.x(), velocity.y(), velocity.z());
                        continue;
                    }
                    this.world.spawnParticle("smoke", center.x(), center.y(), center.z(), velocity.x(), velocity.y(), velocity.z());
                }
            }
        }
    }
}

