/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.biome;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.content.blast.ExplosiveHandlerICBM;
import com.builtbroken.icbm.content.blast.biome.BlastBiome;
import com.builtbroken.jlib.data.Colors;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ExBiomeChange
extends ExplosiveHandlerICBM<BlastBiome> {
    public static final List<Integer> bannedBiomeIds = new ArrayList<Integer>();

    public ExBiomeChange() {
        super("biomeChange", 1);
    }

    public void addInfoToItem(EntityPlayer player, ItemStack stack, List<String> lines) {
        super.addInfoToItem(player, stack, lines);
        int id = ExBiomeChange.getBiomeID(stack);
        String translation = LanguageUtility.getLocal((String)(ICBM_API.itemExplosive.func_77667_c(stack) + ".id.info"));
        translation = translation.replace("%1", "" + id);
        lines.add(translation);
        translation = LanguageUtility.getLocal((String)(ICBM_API.itemExplosive.func_77667_c(stack) + ".name.info"));
        translation = translation.replace("%1", "" + (BiomeGenBase.func_150568_d((int)id) == null ? Colors.RED.code + "Error" : BiomeGenBase.func_150568_d((int)id).field_76791_y));
        lines.add(translation);
    }

    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double size, NBTTagCompound tag) {
        int id = ExBiomeChange.getBiomeID(tag);
        if (id >= 0 && id < BiomeGenBase.func_150565_n().length && BiomeGenBase.func_150568_d((int)id) != null && !bannedBiomeIds.contains(id)) {
            BlastBiome blast = new BlastBiome(this, BiomeGenBase.func_150568_d((int)id).field_76756_M);
            if (blast != null) {
                blast.setLocation(world, x, y, z);
                blast.setCause(triggerCause);
                blast.setYield(size * this.getYieldModifier());
                blast.setAdditionBlastData(tag);
            }
            return blast;
        }
        return null;
    }

    public static int getBiomeID(ItemStack stack) {
        if (stack.func_77973_b() instanceof IExplosiveItem) {
            NBTTagCompound data = ((IExplosiveItem)stack.func_77973_b()).getAdditionalExplosiveData(stack);
            return ExBiomeChange.getBiomeID(data);
        }
        return 0;
    }

    public static int getBiomeID(NBTTagCompound data) {
        if (data != null && data.func_74764_b("biomeID")) {
            return data.func_74762_e("biomeID");
        }
        return 0;
    }

    @Override
    public boolean doesDamageMissile(IMissileEntity entity, IMissile missile, IWarhead warhead, boolean warheadBlew, boolean engineBlew) {
        return engineBlew;
    }
}

