/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.effect;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketSpawnStream;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.prefab.explosive.blast.BlastSimplePath;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;

public class BlastEnderBlocks
extends BlastSimplePath<BlastEnderBlocks> {
    public BlastEnderBlocks(IExplosiveHandler handler) {
        super(handler);
    }

    public void getEffectedBlocks(List<IWorldEdit> list) {
        super.getEffectedBlocks(list);
        Iterator<IWorldEdit> it = list.iterator();
        ArrayList<BlockEdit> newList = new ArrayList<BlockEdit>();
        while (it.hasNext()) {
            Location location;
            IWorldEdit edit = it.next();
            if (Engine.runningAsDev && edit instanceof BlockEdit) {
                ((BlockEdit)edit).newBlock = ICBM_API.blockExplosiveMarker;
            }
            if ((location = this.getRandomLocationChecked()) == null) continue;
            newList.add(new BlockEdit((IWorldPosition)location).set(edit.getBlock(), edit.getBlockMetadata(), false, true));
        }
        list.addAll(newList);
    }

    protected int getRandomRange() {
        return this.oldWorld.field_73012_v.nextInt((int)(this.size * 20.0)) - this.oldWorld.field_73012_v.nextInt((int)(this.size * 20.0));
    }

    protected Location getRandomLocation() {
        return new Location(this.oldWorld, (double)this.getRandomRange() + this.blockCenter.x(), Math.max(10.0, Math.min((double)this.getRandomRange() + this.blockCenter.y(), 255.0)), (double)this.getRandomRange() + this.blockCenter.z());
    }

    protected Location getRandomLocationChecked() {
        Location location;
        int i = 0;
        do {
            location = this.getRandomLocation();
        } while (i++ < 10 && !location.isAirBlock());
        if (!location.isAirBlock()) {
            int y;
            for (y = location.yi(); y < 255 && !this.oldWorld.func_147439_a(location.xi(), y, location.zi()).isAir((IBlockAccess)this.oldWorld, location.xi(), y, location.zi()); ++y) {
            }
            location = new Location(location.world, (double)location.xi(), (double)y, (double)location.zi());
        }
        return location.isAirBlock() ? location : null;
    }

    public BlockEdit changeBlock(BlockPos location) {
        if (location.getTileEntity(this.oldWorld) == null && !location.isAirBlock(this.oldWorld)) {
            return new BlockEdit(this.oldWorld, (IPos3D)location).set(Blocks.field_150350_a, 0, false, true);
        }
        return null;
    }

    public boolean shouldPath(BlockPos location) {
        if (super.shouldPath(location)) {
            if (location.getHardness(this.oldWorld) < 0.0f) {
                return false;
            }
            if (location.getTileEntity(this.oldWorld) != null) {
                return false;
            }
            if (location.isAirBlock(this.oldWorld)) {
                return false;
            }
            Block block = location.getBlock(this.oldWorld);
            if (block == Blocks.field_150427_aO) {
                return false;
            }
            if (block == Blocks.field_150384_bq) {
                return false;
            }
            return block != Blocks.field_150378_br;
        }
        return false;
    }

    public void doStartDisplay() {
    }

    public void doEndDisplay() {
    }

    public void displayEffectForEdit(IWorldEdit blocks) {
        if (!this.oldWorld.field_72995_K) {
            Engine.packetHandler.sendToAllAround((IPacket)new PacketSpawnStream(this.oldWorld.field_73011_w.field_76574_g, this.x, this.y, this.z, blocks.x(), blocks.y(), blocks.z()), new NetworkRegistry.TargetPoint(this.oldWorld.field_73011_w.field_76574_g, blocks.x(), blocks.y(), blocks.z(), 90.0));
        }
    }

    public void playAudioForEdit(IWorldEdit blocks) {
        if (!this.oldWorld.field_72995_K) {
            this.oldWorld.func_72908_a(blocks.x(), blocks.y(), blocks.z(), "mob.endermen.portal", 2.0f, 1.0f);
        }
    }
}

