/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.gravity;

import com.builtbroken.icbm.api.blast.IBlastTileMissile;
import com.builtbroken.icbm.api.missile.ITileMissile;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.imp.transform.region.Cube;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlastGravity
extends Blast<BlastGravity>
implements IBlastTileMissile {
    private int ticks = 0;
    private int duration = 300;
    private AxisAlignedBB bounds;

    public BlastGravity(IExplosiveHandler handler) {
        super(handler);
    }

    public BlastGravity setYield(double size) {
        this.size = size;
        this.updateBounds();
        return this;
    }

    public BlastGravity setLocation(World world, double x, double y, double z) {
        super.setLocation(world, x, y, z);
        this.updateBounds();
        return this;
    }

    private void updateBounds() {
        this.bounds = new Cube(this.x - this.size, this.y - this.size, this.z - this.size, this.x + this.size, this.y + this.size, this.z + this.size).toAABB();
    }

    @Override
    public void tickBlast(ITileMissile tile, IMissile missile) {
        ++this.ticks;
        if (this.bounds == null) {
            this.updateBounds();
        }
        if (!this.oldWorld.field_72995_K) {
            List list = this.oldWorld.func_72872_a(Entity.class, this.bounds);
            for (Entity entity : list) {
                entity.func_70024_g(0.0, 0.1, 0.0);
            }
        }
        if (this.ticks >= this.duration) {
            this.killAction(false);
        }
    }

    public boolean isCompleted() {
        return super.isCompleted() || this.ticks >= this.duration;
    }
}

