/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.temp;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.data.Direction;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.data.heat.HeatedBlockRegistry;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.PlacementData;
import com.builtbroken.mc.prefab.entity.damage.DamageSources;
import com.builtbroken.mc.prefab.entity.selector.EntitySelectors;
import com.builtbroken.mc.prefab.explosive.blast.BlastSimplePath;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;

public class BlastExoThermic
extends BlastSimplePath<BlastExoThermic> {
    public int energyPerBlock = 500;

    public BlastExoThermic(IExplosiveHandler handler) {
        super(handler);
    }

    public BlockEdit changeBlock(BlockPos location) {
        Block block = location.getBlock(this.oldWorld);
        if (block != null) {
            Location loc;
            PlacementData data = HeatedBlockRegistry.getResultWarmUp((Block)block, (int)this.getTempForDistance(location.distance(this.x, this.y, this.z)));
            if (data != null && data.block() != null) {
                BlockEdit edit = new BlockEdit(this.oldWorld, (IPos3D)location);
                edit.set(data.block(), data.meta() == -1 ? 0 : data.meta(), false, true);
                return edit;
            }
            if (location.isReplaceable(this.oldWorld) && !(loc = (Location)new Location(this.oldWorld, (IPos3D)location).add(0.0, -1.0, 0.0)).isAirBlock() && loc.isSideSolid(ForgeDirection.UP)) {
                BlockEdit edit = new BlockEdit(this.oldWorld, (IPos3D)location);
                edit.set((Block)Blocks.field_150480_ab, 0, false, true);
                return edit;
            }
        }
        return null;
    }

    public boolean shouldPathTo(BlockPos last, BlockPos next, Direction dir) {
        if (super.shouldPathTo(last, next, dir)) {
            if (last.isAirBlock(this.oldWorld) && next.isAirBlock(this.oldWorld)) {
                return dir != Direction.UP;
            }
            return true;
        }
        return false;
    }

    private int getTempForDistance(double distance) {
        return 20000 - (int)(20000.0 / this.size * distance);
    }

    private int getEnergyCost(BlockPos location) {
        return -1;
    }

    public void doEffectOther(boolean beforeBlocksPlaced) {
        if (!beforeBlocksPlaced) {
            DamageSource source = DamageSources.THERMAL_INCREASE.getSource((Object)this);
            List list = EntitySelectors.LIVING_SELECTOR.selector().getEntities((IWorldPosition)this, this.size * 2.0);
            for (Entity entity : list) {
                double distance;
                int temp;
                float damage;
                if (!entity.func_70097_a(source, damage = (float)(temp = this.getTempForDistance(distance = entity.func_70011_f(this.x, this.y, this.z))) / 1000.0f)) continue;
                entity.func_70015_d((int)damage);
            }
        }
    }

    public void doStartDisplay() {
    }

    public void doEndDisplay() {
    }

    public void displayEffectForEdit(IWorldEdit blocks) {
        if (!this.oldWorld.field_72995_K) {
            this.world.spawnParticle("lava", blocks.x(), blocks.y(), blocks.z(), 0.0, 0.0, 0.0);
        }
    }

    public void playAudioForEdit(IWorldEdit blocks) {
        if (!this.oldWorld.field_72995_K) {
            this.oldWorld.func_72908_a(blocks.x(), blocks.y(), blocks.z(), "liquid.lavapop", 0.2f + this.oldWorld.field_73012_v.nextFloat() * 0.2f, 0.9f + this.oldWorld.field_73012_v.nextFloat() * 0.15f);
        }
    }
}

