/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.util;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.edit.IWorldChangeLayeredAction;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.BlockEditMove;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class BlastOrePuller
extends Blast<BlastOrePuller>
implements IWorldChangeLayeredAction {
    public static final List<Block> whiteList = new ArrayList<Block>();
    public static final List<Block> blackList = new ArrayList<Block>();
    private int layers;
    private int sideLength;
    private int sizeInt;

    public BlastOrePuller(IExplosiveHandler handler) {
        super(handler);
    }

    public BlastOrePuller setYield(double size) {
        double prev = this.size;
        super.setYield(Math.floor(size));
        if (prev != size) {
            this.calculateLayers();
        }
        return this;
    }

    public void calculateLayers() {
        this.sizeInt = (int)Math.floor(this.size);
        this.sideLength = this.sizeInt * 2 + 1;
        this.layers = this.sideLength * this.sideLength;
    }

    public void getEffectedBlocks(List<IWorldEdit> list, int layer) {
        int gridX = layer % this.sideLength;
        int gridZ = layer / this.sideLength;
        int x = gridX + this.xi() - this.sizeInt;
        int z = gridZ + this.zi() - this.sizeInt;
        for (int y = 0; y < this.yi(); ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            IWorldEdit edit = this.changeBlock(pos);
            if (edit == null) continue;
            list.add(edit);
        }
        this.createMovePositions(list);
    }

    protected void createMovePositions(List<IWorldEdit> list) {
        Iterator<IWorldEdit> it = list.iterator();
        ArrayList<BlockEdit> newList = new ArrayList<BlockEdit>();
        ArrayList<BlockPos> usedSurfacePos = new ArrayList<BlockPos>();
        while (it.hasNext()) {
            IWorldEdit edit = it.next();
            if (edit == null) {
                it.remove();
                continue;
            }
            int y = edit.yi();
            while (y++ < 255) {
                BlockPos pos = new BlockPos(edit.xi(), y, edit.zi());
                if (usedSurfacePos.contains(pos) || !pos.isReplaceable(this.oldWorld)) continue;
                usedSurfacePos.add(pos);
                break;
            }
            if (y >= 255) {
                it.remove();
                continue;
            }
            newList.add(new BlockEditMove((IWorldPosition)edit, (IWorldPosition)new Location(edit.oldWorld(), edit.x(), (double)y, edit.z())).setAir());
            it.remove();
        }
        list.addAll(newList);
    }

    protected IWorldEdit changeBlock(BlockPos pos) {
        Block block = pos.getBlock(this.oldWorld);
        if (!pos.canSeeSky(this.oldWorld)) {
            if (blackList.contains(block)) {
                return null;
            }
            if (block instanceof BlockOre || whiteList.contains(block)) {
                return new BlockEdit(this.oldWorld, (IPos3D)pos).setAir();
            }
            if (block.func_149739_a().contains("ore")) {
                ArrayList stacks = block.getDrops(this.oldWorld, pos.xi(), pos.yi(), pos.zi(), 0, 0);
                if (stacks != null) {
                    for (ItemStack stack : stacks) {
                        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                        if (result == null || !result.func_77977_a().contains("ingot")) continue;
                        whiteList.add(block);
                        return new BlockEdit(this.oldWorld, (IPos3D)pos).set(Blocks.field_150352_o);
                    }
                }
                blackList.add(block);
            }
        }
        return null;
    }

    public int getLayers() {
        return this.layers;
    }

    public boolean shouldContinueAction(int layer) {
        return !this.killExplosion;
    }
}

