/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAbstractWorkstation<I extends IInventory>
extends TileModuleMachine<I>
implements IMultiTileHost {
    private boolean _destroyingStructure = false;
    protected boolean rotating = false;
    public ForgeDirection connectedBlockSide = ForgeDirection.UP;

    public TileAbstractWorkstation(String name, Material material) {
        super(name, material);
    }

    public void onRemove(Block block, int par6) {
        super.onRemove(block, par6);
        this.breakDownStructure(true, true);
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity) {
            Pos pos = new Pos((TileEntity)tileMulti);
            if (!this.getLayoutOfMultiBlock().containsKey(pos)) {
                tileMulti.setHost(null);
            }
        } else {
            tileMulti.setHost(null);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this._destroyingStructure && !this.rotating && tileMulti instanceof TileEntity) {
            Pos pos = (Pos)new Pos((TileEntity)tileMulti).sub((IPos3D)new Pos((TileEntity)this));
            if (this.getLayoutOfMultiBlock().containsKey(pos)) {
                this.breakDownStructure(harvest, true);
                return true;
            }
        }
        return false;
    }

    protected void breakDownStructure(boolean drop, boolean destroy) {
        if (!this._destroyingStructure) {
            this._destroyingStructure = true;
            MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)drop, (boolean)true, (boolean)destroy);
            this._destroyingStructure = false;
        }
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        return this.onPlayerActivated(player, side, new Pos((double)xHit, (double)yHit, (double)zHit));
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        return this.getLayoutOfMultiBlock(this.getDirection());
    }

    public abstract HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection var1);

    public ForgeDirection getDirection() {
        return this.facing;
    }

    public void setDirection(ForgeDirection newDir) {
        this.facing = newDir;
    }

    public boolean isRotationBlocked(ForgeDirection newRotation) {
        for (IPos3D p : this.getLayoutOfMultiBlock(newRotation).keySet()) {
            TileEntity tile;
            Pos pos = (Pos)this.toPos().add(p);
            Block block = this.oldWorld().func_147439_a((int)pos.x(), (int)pos.y(), (int)pos.z());
            if (block.isAir((IBlockAccess)this.oldWorld(), (int)pos.x(), (int)pos.y(), (int)pos.z()) || (tile = pos.getTileEntity((IBlockAccess)this.oldWorld())) instanceof IMultiTile && (((IMultiTile)tile).getHost() == this || ((IMultiTile)tile).getHost() == null)) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    public void ejectCraftingItems() {
        for (int i = 0; i <= this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            InventoryUtility.dropItemStack((IWorldPosition)this.toLocation(), (ItemStack)this.func_70301_a(i));
            this.func_70299_a(i, null);
        }
    }
}

