/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.small;

import com.builtbroken.icbm.content.crafting.station.TileAbstractWorkstation;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileSmallMissileStationBase<I extends IInventory>
extends TileAbstractWorkstation<I> {
    public static final int INPUT_SLOT = 0;
    public static HashMap<IPos3D, String> upDownMap = new HashMap();
    public static HashMap<IPos3D, String> eastWestMap;
    public static HashMap<IPos3D, String> northSouthMap;

    public TileSmallMissileStationBase(String name, Material material) {
        super(name, material);
    }

    public void firstTick() {
        super.firstTick();
        this.connectedBlockSide = ForgeDirection.getOrientation((int)this.oldWorld().func_72805_g(this.xi(), this.yi(), this.zi()));
        if (!this.isRotationValid() || this.isRotationBlocked(this.facing)) {
            this.facing = this.getDirection();
        } else {
            MultiBlockHelper.buildMultiBlock((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true, (boolean)true);
        }
        this.oldWorld().func_147471_g(this.xi(), this.yi(), this.zi());
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            if (player.func_70093_af()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Inverted station rotation"));
                this.setDirection(this.getDirection().getOpposite());
            } else {
                ForgeDirection newDir = this.getNextRotation();
                if (newDir == ForgeDirection.UNKNOWN) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error connect side is not set, remove and replace block"));
                } else if (!this.isRotationBlocked(newDir)) {
                    this.setDirection(newDir);
                    player.func_146105_b((IChatComponent)new ChatComponentText("Rotated to face set to " + this.getDirection()));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Can't rotate from " + this.getDirection() + " to " + newDir + " as there are blocks in the way"));
                }
            }
        }
        return true;
    }

    public ForgeDirection getNextRotation() {
        ForgeDirection newDir = ForgeDirection.UNKNOWN;
        switch (this.connectedBlockSide) {
            case UP: 
            case DOWN: {
                if (this.facing == ForgeDirection.NORTH) {
                    newDir = ForgeDirection.EAST;
                    break;
                }
                if (this.facing == ForgeDirection.EAST) {
                    newDir = ForgeDirection.SOUTH;
                    break;
                }
                if (this.facing == ForgeDirection.SOUTH) {
                    newDir = ForgeDirection.WEST;
                    break;
                }
                newDir = ForgeDirection.NORTH;
                break;
            }
            case EAST: 
            case WEST: {
                if (this.facing == ForgeDirection.NORTH) {
                    newDir = ForgeDirection.DOWN;
                    break;
                }
                if (this.facing == ForgeDirection.DOWN) {
                    newDir = ForgeDirection.SOUTH;
                    break;
                }
                if (this.facing == ForgeDirection.SOUTH) {
                    newDir = ForgeDirection.UP;
                    break;
                }
                newDir = ForgeDirection.NORTH;
                break;
            }
            case NORTH: 
            case SOUTH: {
                newDir = this.facing == ForgeDirection.EAST ? ForgeDirection.DOWN : (this.facing == ForgeDirection.DOWN ? ForgeDirection.WEST : (this.facing == ForgeDirection.WEST ? ForgeDirection.UP : ForgeDirection.EAST));
            }
        }
        return newDir;
    }

    @Override
    public void setDirection(ForgeDirection newDir) {
        this.setDirectionDO(newDir, this.isServer());
    }

    @Override
    public ForgeDirection getDirection() {
        if (!this.isValidRotation(this.facing)) {
            for (int i = 0; i < 5; ++i) {
                if (!this.setDirectionDO(this.getNextRotation(), this.isServer())) continue;
                return this.facing;
            }
            InventoryUtility.dropBlockAsItem((World)this.oldWorld(), (int)this.xi(), (int)this.yi(), (int)this.zi(), (boolean)true);
        }
        return this.facing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setDirectionDO(ForgeDirection newDir, boolean sendPacket) {
        if (this.facing == newDir || newDir == this.connectedBlockSide || newDir == this.connectedBlockSide.getOpposite()) return false;
        if (newDir != this.facing.getOpposite()) {
            if (this.isRotationBlocked(newDir)) return false;
            this.rotating = true;
            this.breakDownStructure(false, false);
            this.facing = newDir;
            MultiBlockHelper.buildMultiBlock((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true, (boolean)true);
            MultiBlockHelper.updateStructure((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true);
            this.rotating = false;
        } else {
            this.facing = newDir;
        }
        if (!sendPacket) return true;
        this.sendDescPacket();
        return true;
    }

    @Override
    public HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection dir) {
        return TileSmallMissileStationBase.getLayoutOfMultiBlock(dir, this.connectedBlockSide);
    }

    public static HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection dir, ForgeDirection connectedBlockSide) {
        switch (connectedBlockSide) {
            case UP: 
            case DOWN: {
                if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
                    return eastWestMap;
                }
                return northSouthMap;
            }
            case EAST: 
            case WEST: {
                if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP) {
                    return upDownMap;
                }
                return northSouthMap;
            }
            case NORTH: 
            case SOUTH: {
                if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP) {
                    return upDownMap;
                }
                return eastWestMap;
            }
        }
        return eastWestMap;
    }

    public boolean isRotationValid() {
        return this.isValidRotation(this.facing);
    }

    public boolean isValidRotation(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != this.connectedBlockSide && dir != this.connectedBlockSide.getOpposite();
    }

    protected void reducePlayerHeldItem(EntityPlayer player) {
        --player.func_70694_bm().field_77994_a;
        if (player.func_70694_bm().field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
        player.field_71069_bz.func_75142_b();
    }

    static {
        upDownMap.put((IPos3D)new Pos(0.0, 1.0, 0.0), EnumMultiblock.INVENTORY.getTileName() + "#RenderBlock=false");
        upDownMap.put((IPos3D)new Pos(0.0, -1.0, 0.0), EnumMultiblock.INVENTORY.getTileName() + "#RenderBlock=false");
        eastWestMap = new HashMap();
        eastWestMap.put((IPos3D)new Pos(1.0, 0.0, 0.0), EnumMultiblock.INVENTORY.getTileName() + "#RenderBlock=false");
        eastWestMap.put((IPos3D)new Pos(-1.0, 0.0, 0.0), EnumMultiblock.INVENTORY.getTileName() + "#RenderBlock=false");
        northSouthMap = new HashMap();
        northSouthMap.put((IPos3D)new Pos(0.0, 0.0, 1.0), EnumMultiblock.INVENTORY.getTileName() + "#RenderBlock=false");
        northSouthMap.put((IPos3D)new Pos(0.0, 0.0, -1.0), EnumMultiblock.INVENTORY.getTileName() + "#RenderBlock=false");
    }
}

