/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.small;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.crafting.IModularMissileItem;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.crafting.station.small.ItemBlockMissileStation;
import com.builtbroken.icbm.content.crafting.station.small.TileSmallMissileStationBase;
import com.builtbroken.icbm.content.missile.data.missile.Missile;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.parts.engine.RocketEngine;
import com.builtbroken.icbm.content.missile.parts.guidance.Guidance;
import com.builtbroken.icbm.content.missile.parts.warhead.Warhead;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.api.tile.IRotatable;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.framework.recipe.item.RecipeTool;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSmallMissileWorkstation
extends TileSmallMissileStationBase
implements IPacketIDReceiver,
IRotatable,
IPostInit {
    protected IMissile missile;

    public TileSmallMissileWorkstation() {
        super("missileWorkstation", Material.field_151573_f);
        this.resistance = 10.0f;
        this.hardness = 10.0f;
        this.itemBlock = ItemBlockMissileStation.class;
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
        this.isOpaque = false;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 1);
    }

    public void onPostInit() {
        Object[] objectArray = new Object[13];
        objectArray[0] = "RRR";
        objectArray[1] = "HCD";
        objectArray[2] = "PPP";
        objectArray[3] = Character.valueOf('R');
        objectArray[4] = "rodIron";
        objectArray[5] = Character.valueOf('P');
        objectArray[6] = "plateIron";
        objectArray[7] = Character.valueOf('H');
        objectArray[8] = Engine.itemSimpleCraftingTools.getHammer();
        objectArray[9] = Character.valueOf('D');
        objectArray[10] = Engine.itemSimpleCraftingTools.getDrill();
        objectArray[11] = Character.valueOf('C');
        objectArray[12] = "circuitBasic";
        GameRegistry.addRecipe((IRecipe)new RecipeTool(new ItemStack(ICBM_API.blockMissileWorkstation), objectArray));
    }

    public Tile newTile() {
        return new TileSmallMissileWorkstation();
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (slot == 0) {
            if (item == null) {
                this.missile = null;
            } else if (item.func_77973_b() instanceof IModularMissileItem && !InventoryUtility.stacksMatchExact((ItemStack)this.func_70301_a(slot), (ItemStack)item)) {
                this.missile = ((IModularMissileItem)item.func_77973_b()).toMissile(item);
            }
            this.sendDescPacket();
        }
    }

    @Override
    public void ejectCraftingItems() {
    }

    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            if (player.func_70694_bm() != null) {
                if (this.getMissileItem() == null) {
                    if (this.func_94041_b(0, player.func_70694_bm())) {
                        if (InventoryUtility.addItemToSlot((EntityPlayer)player, (IInventory)this, (int)0)) {
                            this.updateMissile();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("hmm, something seems wrong."));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("I don't think that goes into here."));
                    }
                } else if (this.getMissile() != null) {
                    IModule module = null;
                    if (player.func_70694_bm().func_77973_b() instanceof IModuleItem) {
                        module = ((IModuleItem)player.func_70694_bm().func_77973_b()).getModule(player.func_70694_bm());
                    }
                    if (module instanceof Guidance) {
                        if (this.getMissile().getGuidance() == null) {
                            this.getMissile().setGuidance((Guidance)module);
                            --player.func_70694_bm().field_77994_a;
                            if (player.func_70694_bm().field_77994_a <= 0) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            }
                            player.field_71069_bz.func_75142_b();
                            this.updateMissileItem();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Guidance already set, right click with empty hand to remove."));
                        }
                    } else if (module instanceof RocketEngine) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Try clicking the back of the missile"));
                    } else if (module instanceof Warhead) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Try clicking the front of the missile"));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("That doesn't go onto a missile"));
                    }
                }
            } else if (player.func_70093_af()) {
                InventoryUtility.removeItemFromSlot((EntityPlayer)player, (IInventory)this, (int)0);
                this.updateMissile();
            } else if (this.getMissile() != null && this.getMissile().getGuidance() != null) {
                ItemStack stack = this.getMissile().getGuidance().toStack();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                this.getMissile().setGuidance(null);
                this.updateMissileItem();
                player.field_71069_bz.func_75142_b();
            }
        }
        return true;
    }

    @Override
    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        if (this.isServer()) {
            Pos pos = (Pos)new Pos((TileEntity)tile).sub((double)this.xi(), (double)this.yi(), (double)this.zi());
            if (this.getLayoutOfMultiBlock().containsKey(pos)) {
                if (this.getMissile() != null) {
                    IModule module = null;
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IModuleItem) {
                        module = ((IModuleItem)player.func_70694_bm().func_77973_b()).getModule(player.func_70694_bm());
                    }
                    if (this.isWarheadSide(pos)) {
                        if (module == null) {
                            if (player.func_70694_bm() == null && this.getMissile().getWarhead() != null) {
                                ItemStack stack = this.getMissile().getWarhead().toStack();
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                                this.getMissile().setWarhead(null);
                                this.updateMissileItem();
                                player.field_71069_bz.func_75142_b();
                            }
                        } else if (module instanceof Warhead) {
                            if (this.missile.getWarhead() == null) {
                                this.getMissile().setWarhead((Warhead)module);
                                this.reducePlayerHeldItem(player);
                                this.updateMissileItem();
                            } else {
                                player.func_146105_b((IChatComponent)new ChatComponentText("Warhead already installed."));
                            }
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Only warheads can fit on the tip."));
                        }
                    } else if (module == null) {
                        if (player.func_70694_bm() == null && this.getMissile().getEngine() != null) {
                            ItemStack stack = this.getMissile().getEngine().toStack();
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                            this.getMissile().setEngine(null);
                            this.updateMissileItem();
                            player.field_71069_bz.func_75142_b();
                        }
                    } else if (module instanceof RocketEngine) {
                        if (this.missile.getEngine() == null) {
                            this.getMissile().setEngine((RocketEngine)module);
                            this.reducePlayerHeldItem(player);
                            this.updateMissileItem();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Engine already installed."));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Only engines can fit in the end."));
                    }
                } else if (player.func_70694_bm() != null) {
                    return this.onPlayerRightClick(player, side, new Pos((double)xHit, (double)yHit, (double)zHit));
                }
            }
        }
        return true;
    }

    private boolean isWarheadSide(Pos pos) {
        if (this.facing == ForgeDirection.NORTH || this.facing == ForgeDirection.SOUTH) {
            return pos.toForgeDirection() == this.getDirection().getOpposite();
        }
        return pos.toForgeDirection() == this.getDirection();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IModularMissileItem && slot == 0) {
            IMissile missile = ((IModularMissileItem)stack.func_77973_b()).toMissile(stack);
            return missile.getMissileSize() == MissileSize.SMALL.ordinal();
        }
        return false;
    }

    public IMissile getMissile() {
        if (this.getMissileItem() != null && this.getMissileItem().func_77973_b() instanceof IMissileItem && this.missile == null) {
            this.missile = ((IMissileItem)this.getMissileItem().func_77973_b()).toMissile(this.getMissileItem());
        }
        return this.missile;
    }

    public ItemStack getMissileItem() {
        return this.func_70301_a(0);
    }

    public PacketTile getDescPacket() {
        if (this.getMissileItem() != null) {
            return new PacketTile((TileEntity)this, new Object[]{1, (byte)this.facing.ordinal(), this.getMissileItem()});
        }
        return new PacketTile((TileEntity)this, new Object[]{1, (byte)this.facing.ordinal(), new ItemStack(Items.field_151034_e)});
    }

    public void updateMissile() {
        this.missile = this.getMissileItem() != null ? new Missile(this.getMissileItem()) : null;
        this.sendDescPacket();
    }

    public void updateMissileItem() {
        if (this.getMissile() != null) {
            this.func_70299_a(0, this.getMissile().toStack());
        }
    }
}

