/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.small;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.station.small.TileSmallMissileWorkstation;
import com.builtbroken.icbm.content.missile.client.RenderMissile;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IModelState;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileSmallMissileWorkstationClient
extends TileSmallMissileWorkstation
implements ISimpleItemRenderer {
    private AxisAlignedBB bounds;

    @Override
    public Tile newTile() {
        return new TileSmallMissileWorkstationClient();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.isClient() && this.field_145850_b != null && id == 1) {
            this.facing = ForgeDirection.getOrientation((int)buf.readByte());
            this.bounds = null;
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            if (InventoryUtility.stacksMatch((ItemStack)stack, (ItemStack)new ItemStack(Items.field_151034_e))) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(0, stack);
            }
            this.field_145850_b.func_147471_g(this.xi(), this.yi(), this.zi());
            return true;
        }
        return false;
    }

    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.1f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScaled((double)0.7f, (double)0.7f, (double)0.7f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_WORKSTATION_TEXTURE2);
        Assets.SMALL_MISSILE_STATION_MODEL2.renderAll();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        TileSmallMissileWorkstationClient.renderDynamic(pos, new Pos(1.0, 0.0, 2.0), this.connectedBlockSide, this.getDirection(), this.getMissile(), frame, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderDynamic(Pos pos, Pos offset, ForgeDirection connectedBlockSide, ForgeDirection direction, IMissile missile, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(pos.xf() + offset.xf()), (float)(pos.yf() + offset.yf()), (float)(pos.zf() + offset.zf()));
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_WORKSTATION_TEXTURE2);
        int tableX = 2;
        switch (connectedBlockSide) {
            case UP: {
                if (direction == ForgeDirection.EAST) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (direction == ForgeDirection.WEST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)2.0f);
                    break;
                }
                if (direction != ForgeDirection.SOUTH) break;
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)1.0f);
                if (direction == ForgeDirection.WEST) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (direction == ForgeDirection.EAST) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)2.0f);
                    break;
                }
                if (direction != ForgeDirection.SOUTH) break;
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                if (direction == ForgeDirection.DOWN) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                } else if (direction == ForgeDirection.UP) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)2.0f);
                }
                if (direction != ForgeDirection.SOUTH) break;
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case WEST: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                if (direction == ForgeDirection.UP) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (direction == ForgeDirection.DOWN) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)2.0f);
                    break;
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                if (direction != ForgeDirection.SOUTH) break;
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
                if (direction == ForgeDirection.DOWN) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (direction == ForgeDirection.EAST) {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                if (direction != ForgeDirection.UP) break;
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)2.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)-1.0f, (float)-2.0f, (float)1.0f);
                if (direction == ForgeDirection.UP) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (direction == ForgeDirection.EAST) {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                if (direction != ForgeDirection.DOWN) break;
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)2.0f);
            }
        }
        Assets.SMALL_MISSILE_STATION_MODEL2.renderAll();
        GL11.glTranslatef((float)tableX, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (missile != null) {
            GL11.glPushMatrix();
            TileSmallMissileWorkstationClient.renderMissile(pos, missile, connectedBlockSide, direction);
            GL11.glPopMatrix();
        }
    }

    public static void renderMissile(Pos pos, IMissile missmissileile, ForgeDirection connectedBlockSide, ForgeDirection direction) {
        TileSmallMissileWorkstationClient.renderMissile(pos.xf(), pos.yf(), pos.zf(), missmissileile, connectedBlockSide, direction);
    }

    public static void renderMissile(float xx, float yy, float zz, IMissile missile, ForgeDirection connectedBlockSide, ForgeDirection direction) {
        GL11.glTranslatef((float)(xx + 0.5f), (float)(yy + 0.5f), (float)(zz + 0.5f));
        GL11.glScaled((double)1.0, (double)0.9, (double)1.0);
        switch (connectedBlockSide) {
            case UP: 
            case DOWN: {
                TileSmallMissileWorkstationClient.handleMissileRotationUD(direction);
                break;
            }
            case EAST: 
            case WEST: {
                TileSmallMissileWorkstationClient.handleMissileRotationEW(direction);
                break;
            }
            case NORTH: 
            case SOUTH: {
                TileSmallMissileWorkstationClient.handleMissileRotationNS(direction);
            }
        }
        GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
        if (missile instanceof IJsonGenObject) {
            RenderData data = ClientDataHandler.INSTANCE.getRenderData(((IJsonGenObject)missile).getContentID());
            if (data != null) {
                ArrayList<String> parts = new ArrayList<String>();
                parts.add("missile.body");
                if (missile.getWarhead() != null) {
                    parts.add("missile.warhead");
                    if (missile.getWarhead().getExplosive() != null) {
                        parts.add("missile.warhead.ex");
                    }
                }
                if (missile.getGuidance() != null) {
                    parts.add("missile.guidance");
                }
                if (missile.getEngine() != null) {
                    parts.add("missile.engine");
                }
                for (String stateID : parts) {
                    IRenderState state = data.getState(stateID);
                    if (!(state instanceof IModelState)) continue;
                    ((IModelState)state).render(false, 0.0f, 0.0f, 0.0f);
                }
            }
        } else {
            RenderMissile.renderMissile(missile, 0.0f, 0.0f, null);
        }
    }

    public static void handleMissileRotationUD(ForgeDirection direction) {
        switch (direction) {
            case EAST: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static void handleMissileRotationEW(ForgeDirection direction) {
        switch (direction) {
            case UP: {
                break;
            }
            case DOWN: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static void handleMissileRotationNS(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bounds == null) {
            switch (this.connectedBlockSide) {
                case UP: 
                case DOWN: {
                    if (this.facing == ForgeDirection.EAST || this.facing == ForgeDirection.WEST) {
                        this.bounds = new Cube(-1.0, 0.0, 0.0, 1.0, 0.0, 0.0).add((IPos3D)this.toPos()).toAABB();
                        break;
                    }
                    this.bounds = new Cube(0.0, 0.0, -1.0, 0.0, 0.0, 1.0).add((IPos3D)this.toPos()).toAABB();
                    break;
                }
                case EAST: 
                case WEST: {
                    if (this.facing == ForgeDirection.DOWN || this.facing == ForgeDirection.UP) {
                        this.bounds = new Cube(0.0, -1.0, 0.0, 0.0, 1.0, 0.0).add((IPos3D)this.toPos()).toAABB();
                        break;
                    }
                    this.bounds = new Cube(0.0, 0.0, -1.0, 0.0, 0.0, 1.0).add((IPos3D)this.toPos()).toAABB();
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.bounds = this.facing == ForgeDirection.DOWN || this.facing == ForgeDirection.UP ? new Cube(0.0, -1.0, 0.0, 0.0, 1.0, 0.0).add((IPos3D)this.toPos()).toAABB() : new Cube(0.0, 0.0, -1.0, 0.0, 0.0, 1.0).add((IPos3D)this.toPos()).toAABB();
                }
            }
            this.bounds = super.getRenderBoundingBox();
        }
        return this.bounds;
    }
}

