/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.small.auto;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.modules.IGuidance;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.api.modules.IRocketEngine;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.content.crafting.station.small.auto.ContainerSMAutoCraft;
import com.builtbroken.icbm.content.crafting.station.small.auto.GuiSMAutoCraft;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.mc.api.automation.IAutomatedCrafter;
import com.builtbroken.mc.api.automation.IAutomation;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.access.IRotation;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.prefab.inventory.ExternalInventory;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.logic.TileMachineNode;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSMAutoCraft
extends TileMachineNode<ExternalInventory>
implements IPacketIDReceiver,
IGuiTile,
IAutomatedCrafter<ExternalInventory>,
IRotation {
    public static final int INPUT_SLOT = 0;
    public static final int WARHEAD_SLOT = 1;
    public static final int GUIDANCE_SLOT = 2;
    public static final int ENGINE_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] OUTPUT_SLOTS = new int[]{4};
    protected boolean isAutocrafting = false;
    protected boolean requiresWarhead = true;
    protected boolean requiresEngine = true;
    protected boolean requiresGuidance = true;
    protected boolean checkForCraft = false;
    protected IMissile completedMissile;
    protected IMissile startedMissile;
    private ForgeDirection rotationCache;

    public TileSMAutoCraft() {
        super("worktable.missile", "icbm");
    }

    protected ExternalInventory createInventory() {
        return new ExternalInventory((IInventoryProvider)this, 5);
    }

    public void update(long ticks) {
        super.update(ticks);
        if (this.isServer() && ticks % 10L == 0L && this.isAutocrafting && this.checkForCraft) {
            this.checkForCraft = false;
            if (this.canCraft()) {
                this.doCrafting();
            }
        }
    }

    public void doCrafting() {
        IModule module;
        if (this.getInputStack() != null && (module = this.toModule(this.getInputStack())) instanceof IMissile) {
            IMissile prev = (IMissile)module;
            IMissile result = this.getCraftedMissile();
            if (result != null) {
                if (prev.getWarhead() == null && result.getWarhead() != null) {
                    ((ExternalInventory)this.getInventory()).func_70298_a(1, 1);
                }
                if (prev.getGuidance() == null && result.getGuidance() != null) {
                    ((ExternalInventory)this.getInventory()).func_70298_a(2, 1);
                }
                if (prev.getEngine() == null && result.getEngine() != null) {
                    ((ExternalInventory)this.getInventory()).func_70298_a(3, 1);
                }
                ((ExternalInventory)this.getInventory()).func_70299_a(4, result.toStack());
                ((ExternalInventory)this.getInventory()).func_70298_a(0, 1);
            }
        }
    }

    public boolean canCraft() {
        IMissile result = this.getCraftedMissile();
        if (result != null) {
            if (this.isAutocrafting) {
                if (this.requiresWarhead && result.getWarhead() == null) {
                    return false;
                }
                if (this.requiresGuidance && result.getGuidance() == null) {
                    return false;
                }
                if (this.requiresEngine && result.getEngine() == null) {
                    return false;
                }
            }
            return this.getOutputStack() == null || InventoryUtility.stacksMatch((ItemStack)this.getOutputStack(), (ItemStack)result.toStack()) && InventoryUtility.roomLeftInSlot((IInventory)this.getInventory(), (int)0) > 0;
        }
        return false;
    }

    public float getCraftingProgress() {
        return 0.0f;
    }

    public List<ItemStack> getRequiredItems() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack insertRequiredItem(ItemStack stack, IAutomation entity, ForgeDirection side) {
        return stack;
    }

    public ItemStack insertRequiredItem(ItemStack stack, int slot, IAutomation entity, ForgeDirection side) {
        if (this.isAutocrafting && stack != null) {
            IModule module = this.toModule(stack);
            if (0 == slot) {
                if (module instanceof IMissile && this.getInputStack() == null) {
                    ((ExternalInventory)this.getInventory()).func_70299_a(0, module.toStack());
                    --stack.field_77994_a;
                    return stack.field_77994_a <= 0 ? null : stack;
                }
            } else if (1 == slot) {
                if (module instanceof IWarhead && this.getWarheadStack() == null) {
                    ((ExternalInventory)this.getInventory()).func_70299_a(1, module.toStack());
                    --stack.field_77994_a;
                    return stack.field_77994_a <= 0 ? null : stack;
                }
            } else if (2 == slot) {
                if (module instanceof IGuidance && this.getGuidanceStack() == null) {
                    ((ExternalInventory)this.getInventory()).func_70299_a(2, module.toStack());
                    --stack.field_77994_a;
                    return stack.field_77994_a <= 0 ? null : stack;
                }
            } else if (3 == slot && module instanceof IRocketEngine && this.getEngineStack() == null) {
                ((ExternalInventory)this.getInventory()).func_70299_a(3, module.toStack());
                --stack.field_77994_a;
                return stack.field_77994_a <= 0 ? null : stack;
            }
        }
        return stack;
    }

    protected IModule toModule(ItemStack stack) {
        ItemStack insert = stack.func_77946_l();
        insert.field_77994_a = 1;
        if (stack.func_77973_b() instanceof IModuleItem) {
            return ((IModuleItem)stack.func_77973_b()).getModule(insert);
        }
        return MissileModuleBuilder.INSTANCE.build(insert);
    }

    public int[] getCraftingOutputSlots(IAutomation entity, ForgeDirection side) {
        return OUTPUT_SLOTS;
    }

    public int[] getCraftingInputSlots(IAutomation entity, ForgeDirection side) {
        return INPUT_SLOTS;
    }

    public boolean canRemove(ItemStack stack, ForgeDirection side) {
        return true;
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        this.checkForCraft = true;
        this.sendDescPacket();
    }

    public IMissile getCraftedMissile() {
        IModule module;
        ItemStack inputStack = this.getInputStack();
        ItemStack warheadStack = this.getWarheadStack();
        ItemStack guidanceStack = this.getGuidanceStack();
        ItemStack engineStack = this.getEngineStack();
        if (inputStack != null && (module = this.toModule(inputStack)) instanceof IMissile) {
            IMissile missile = (IMissile)module;
            if ((!this.isAutocrafting || this.requiresWarhead) && warheadStack != null && missile.getWarhead() == null && (module = this.toModule(warheadStack)) instanceof IWarhead) {
                missile.setWarhead((IWarhead)module);
            }
            if ((!this.isAutocrafting || this.requiresGuidance) && guidanceStack != null && missile.getGuidance() == null && (module = this.toModule(guidanceStack)) instanceof IGuidance) {
                missile.setGuidance((IGuidance)module);
            }
            if ((!this.isAutocrafting || this.requiresEngine) && engineStack != null && missile.getEngine() == null && (module = this.toModule(engineStack)) instanceof IRocketEngine) {
                missile.setEngine((IRocketEngine)module);
            }
            return missile;
        }
        return null;
    }

    public ItemStack getCraftResult() {
        IMissile result = this.getCraftedMissile();
        return result != null ? result.toStack() : null;
    }

    public boolean canStore(ItemStack stack, ForgeDirection side) {
        if (stack != null) {
            IModule module = this.toModule(stack);
            return module instanceof IMissile || module instanceof IWarhead || module instanceof IGuidance || module instanceof IRocketEngine;
        }
        return false;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        if (stack != null) {
            IModule module = this.toModule(stack);
            if (0 == slot) {
                return module instanceof IMissile;
            }
            if (1 == slot) {
                return module instanceof IWarhead;
            }
            if (2 == slot) {
                return module instanceof IGuidance;
            }
            if (3 == slot) {
                return module instanceof IRocketEngine;
            }
        }
        return false;
    }

    public boolean canRemove(ItemStack stack, int slot, ForgeDirection side) {
        return slot == 4;
    }

    protected ItemStack getWarheadStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(1);
    }

    protected ItemStack getGuidanceStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(2);
    }

    protected ItemStack getEngineStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(3);
    }

    protected ItemStack getInputStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(0);
    }

    protected ItemStack getOutputStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(4);
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isServer()) {
                if (id == 1) {
                    this.doCrafting();
                    return true;
                }
                if (id == 2) {
                    player.openGui((Object)ICBM.INSTANCE, buf.readInt(), (World)this.world().unwrap(), this.xi(), this.yi(), this.zi());
                    return true;
                }
                if (id == 3) {
                    this.isAutocrafting = buf.readBoolean();
                    this.requiresWarhead = buf.readBoolean();
                    this.requiresGuidance = buf.readBoolean();
                    this.requiresEngine = buf.readBoolean();
                    this._doUpdateGuiUsers();
                    return true;
                }
            } else if (id == 5) {
                this.isAutocrafting = buf.readBoolean();
                this.requiresWarhead = buf.readBoolean();
                this.requiresGuidance = buf.readBoolean();
                this.requiresEngine = buf.readBoolean();
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof GuiSMAutoCraft) {
                    screen.func_73866_w_();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        NBTTagCompound tag = ((ExternalInventory)this.getInventory()).save(new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        ExternalInventory clientRenderInv = new ExternalInventory((IInventoryProvider)this, ((ExternalInventory)this.getInventory()).func_70302_i_());
        clientRenderInv.load(ByteBufUtils.readTag((ByteBuf)buf));
        ItemStack outputStack = clientRenderInv.func_70301_a(4);
        if (outputStack != null) {
            IModule module = this.toModule(outputStack);
            if (module instanceof IMissile) {
                this.completedMissile = (IMissile)module;
            }
        } else {
            this.completedMissile = null;
        }
        ExternalInventory tempInv = (ExternalInventory)this.getInventory();
        this.inventory_module = clientRenderInv;
        this.startedMissile = this.getCraftedMissile();
        this.inventory_module = tempInv;
    }

    public void _doUpdateGuiUsers() {
        this.sendPacketToGuiUsers(this.getHost().getPacketForData(new Object[]{5, this.isAutocrafting, this.requiresWarhead, this.requiresGuidance, this.requiresEngine}));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerSMAutoCraft(player, this, ID);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiSMAutoCraft(player, this, ID);
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.isAutocrafting = this.getBoolean(nbt, "isAutocrafting", false);
        this.requiresWarhead = this.getBoolean(nbt, "requiresWarhead", true);
        this.requiresEngine = this.getBoolean(nbt, "requiresEngine", true);
        this.requiresGuidance = this.getBoolean(nbt, "requiresGuidance", true);
        this.checkForCraft = this.getBoolean(nbt, "checkForCraft", false);
    }

    private boolean getBoolean(NBTTagCompound nbt, String key, boolean b) {
        return nbt.func_74764_b(key) ? nbt.func_74767_n("isAutocrafting") : b;
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("isAutocrafting", this.isAutocrafting);
        nbt.func_74757_a("requiresWarhead", this.requiresWarhead);
        nbt.func_74757_a("requiresEngine", this.requiresEngine);
        nbt.func_74757_a("requiresGuidance", this.requiresGuidance);
        nbt.func_74757_a("checkForCraft", this.checkForCraft);
        return nbt;
    }

    public void sendCraftingPacket() {
        this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{1}));
    }

    public void sendGUIDataUpdate() {
        this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{3, this.isAutocrafting, this.requiresWarhead, this.requiresGuidance, this.requiresEngine}));
    }

    public ForgeDirection getDirection() {
        if (this.rotationCache == null) {
            this.rotationCache = ForgeDirection.getOrientation((int)this.getHost().getHostMeta()).getOpposite();
        }
        return this.rotationCache;
    }
}

