/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.warhead;

import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.api.warhead.ITrigger;
import com.builtbroken.icbm.api.warhead.ITriggerAccepter;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.station.warhead.ContainerWarheadStation;
import com.builtbroken.icbm.content.crafting.station.warhead.TileWarheadStation;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.prefab.gui.GuiButton2;
import com.builtbroken.mc.prefab.gui.GuiContainerBase;
import com.builtbroken.mc.prefab.gui.buttons.GuiButton9px;
import com.builtbroken.mc.prefab.gui.buttons.GuiImageButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiWarheadStation
extends GuiContainerBase {
    private static final ResourceLocation guiTexture0 = new ResourceLocation("icbm", "textures/gui/warhead.workstation.0.png");
    private static final ResourceLocation guiTexture1 = new ResourceLocation("icbm", "textures/gui/warhead.workstation.1.png");
    private static final ResourceLocation guiTexture2 = new ResourceLocation("icbm", "textures/gui/warhead.workstation.2.png");
    private static final ResourceLocation guiTexture3 = new ResourceLocation("icbm", "textures/gui/warhead.workstation.3.png");
    private final TileWarheadStation tile;
    private final int id;
    private GuiButton2 craftButton;
    private GuiButton2 autoCraftButton;
    private GuiButton2 requireTriggerButton;
    private GuiButton2 requireExplosiveButton;
    private GuiImageButton craftingWindowButton;
    private GuiImageButton explosiveWindowButton;
    private GuiImageButton triggerWindowButton;
    private GuiImageButton autocraftingButton;

    public GuiWarheadStation(EntityPlayer player, TileWarheadStation tile, int id) {
        super((Container)new ContainerWarheadStation(player, tile, id));
        this.tile = tile;
        this.id = id;
        switch (id) {
            case 0: {
                this.baseTexture = guiTexture0;
                break;
            }
            case 1: {
                this.baseTexture = guiTexture1;
                break;
            }
            case 2: {
                this.baseTexture = guiTexture2;
                break;
            }
            case 3: {
                this.baseTexture = guiTexture3;
                break;
            }
            case 4: {
                this.baseTexture = guiTexture3;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.craftingWindowButton = (GuiImageButton)this.addButton((GuiButton)GuiImageButton.newButton18((int)1, (int)(this.field_147003_i - 18), (int)(this.field_147009_r + 5), (int)0, (int)0).setTexture(Assets.GUI_BUTTONS));
        this.explosiveWindowButton = (GuiImageButton)this.addButton((GuiButton)GuiImageButton.newButton18((int)2, (int)(this.field_147003_i - 18), (int)(this.field_147009_r + 5 + 19), (int)1, (int)0).setTexture(Assets.GUI_BUTTONS));
        this.triggerWindowButton = (GuiImageButton)this.addButton((GuiButton)GuiImageButton.newButton18((int)3, (int)(this.field_147003_i - 18), (int)(this.field_147009_r + 5 + 38), (int)3, (int)0).setTexture(Assets.GUI_BUTTONS));
        this.autocraftingButton = (GuiImageButton)this.addButton((GuiButton)GuiImageButton.newButton18((int)4, (int)(this.field_147003_i - 18), (int)(this.field_147009_r + 5 + 57), (int)2, (int)0).setTexture(Assets.GUI_BUTTONS));
        switch (this.id) {
            case 0: {
                this.craftButton = (GuiButton2)this.addButton((GuiButton)new GuiButton2(0, this.field_147003_i + 80, this.field_147009_r + 23, 50, 20, "Craft"));
                this.field_146292_n.add(GuiButton9px.newMinusButton((int)11, (int)(this.field_147003_i + 102), (int)(this.field_147009_r + 70)));
                this.field_146292_n.add(GuiButton9px.newPlusButton((int)10, (int)(this.field_147003_i + 102), (int)(this.field_147009_r + 52)));
                this.craftingWindowButton.disable();
                break;
            }
            case 1: {
                this.explosiveWindowButton.disable();
                break;
            }
            case 2: {
                this.triggerWindowButton.disable();
                break;
            }
            case 3: {
                this.autoCraftButton = (GuiButton2)this.addButton((GuiButton)new GuiButton2(12, this.field_147003_i + 12, this.field_147009_r + 20, 120, 20, this.tile.isAutocrafting ? "Disable Autocrafting" : "Enable Autocrafting"));
                this.requireTriggerButton = (GuiButton2)this.addButton((GuiButton)new GuiButton2(13, this.field_147003_i + 105, this.field_147009_r + 42, 20, 20, this.tile.requireTrigger ? "[X]" : "[ ]"));
                this.requireExplosiveButton = (GuiButton2)this.addButton((GuiButton)new GuiButton2(14, this.field_147003_i + 105, this.field_147009_r + 64, 20, 20, this.tile.requireExplosive ? "[X]" : "[ ]"));
                this.autocraftingButton.disable();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.id == 0) {
            if (this.tile.canCraft()) {
                this.craftButton.enable();
            } else {
                this.craftButton.disable();
            }
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        for (Object object : this.field_147002_h.field_75151_b) {
            this.drawSlot((Slot)object);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        switch (this.id) {
            case 0: {
                this.drawString("Warhead Workstation", 50, 7);
                this.drawString("Explosives to use:", 5, 62);
                this.drawString("" + this.tile.explosiveStackSizeRequired, 104, 62);
                break;
            }
            case 1: {
                this.drawString("Explosive Configuration", 33, 7);
                this.drawString("Not implemented yet", 33, 30);
                break;
            }
            case 2: {
                this.drawString("Trigger Configuration", 33, 7);
                if (this.tile.getTriggerStack() != null) {
                    this.drawString("No options for this trigger", 25, 50);
                    break;
                }
                if (this.tile.getWarheadStack() != null) {
                    ItemStack stack = this.tile.getWarheadStack();
                    if (stack.func_77973_b() instanceof IModuleItem) {
                        IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                        if (module != null && module instanceof IWarhead) {
                            if (module instanceof ITriggerAccepter) {
                                ITrigger trigger = ((ITriggerAccepter)module).getTrigger();
                                if (trigger != null) {
                                    this.drawString("No options for this trigger", 25, 50);
                                    break;
                                }
                                this.drawString("No options for this trigger", 25, 50);
                                break;
                            }
                            this.drawString("Warhead does not support triggers", 25, 50);
                            break;
                        }
                        this.drawString("Failed to read warhead data", 25, 50);
                        break;
                    }
                    this.drawString("Insert trigger for options", 25, 50);
                    break;
                }
                this.drawString("Insert trigger for options", 25, 50);
                break;
            }
            case 3: {
                this.drawString("Autocrafting Settings", 10, 7);
                this.drawString("Require Explosive:", 12, 47);
                this.drawString("Require Trigger:", 12, 67);
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        int buttonId = button.field_146127_k;
        if (buttonId == 0) {
            this.tile.sendCraftingPacket();
        } else if (buttonId > 0 && buttonId < 5 && buttonId - 1 != this.id) {
            this.tile.switchTab(buttonId - 1);
        } else if (buttonId == 10) {
            if (this.tile.explosiveStackSizeRequired < 64) {
                ++this.tile.explosiveStackSizeRequired;
                this.tile.sendGUIDataUpdate();
            }
        } else if (buttonId == 11) {
            if (this.tile.explosiveStackSizeRequired > 1) {
                --this.tile.explosiveStackSizeRequired;
                this.tile.sendGUIDataUpdate();
            }
        } else if (buttonId == 12) {
            this.tile.isAutocrafting = !this.tile.isAutocrafting;
            this.autoCraftButton.field_146126_j = this.tile.isAutocrafting ? "Disable Autocrafting" : "Enable Autocrafting";
            this.tile.sendGUIDataUpdate();
        } else if (buttonId == 13) {
            this.tile.requireTrigger = !this.tile.requireTrigger;
            this.requireTriggerButton.field_146126_j = this.tile.requireTrigger ? "[x]" : "[ ]";
            this.tile.sendGUIDataUpdate();
        } else if (buttonId == 14) {
            this.tile.requireExplosive = !this.tile.requireExplosive;
            this.requireExplosiveButton.field_146126_j = this.tile.requireExplosive ? "[x]" : "[ ]";
            this.tile.sendGUIDataUpdate();
        }
    }
}

