/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.warhead;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.api.warhead.ITrigger;
import com.builtbroken.icbm.api.warhead.ITriggerAccepter;
import com.builtbroken.icbm.api.warhead.IWarheadItem;
import com.builtbroken.icbm.content.crafting.station.warhead.ContainerWarheadStation;
import com.builtbroken.icbm.content.crafting.station.warhead.GuiWarheadStation;
import com.builtbroken.mc.api.automation.IAutomatedCrafter;
import com.builtbroken.mc.api.automation.IAutomation;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.access.IRotation;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.inventory.ExternalInventory;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.logic.TileMachineNode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWarheadStation
extends TileMachineNode<ExternalInventory>
implements IPacketIDReceiver,
IGuiTile,
IAutomatedCrafter<ExternalInventory>,
IRotation {
    public static final int WARHEAD_SLOT = 0;
    public static final int EXPLOSIVE_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int TRIGGER_SLOT = 3;
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 3};
    public static final int[] OUTPUT_SLOTS = new int[]{2};
    protected boolean isAutocrafting = false;
    protected boolean requireExplosive = true;
    protected boolean requireTrigger = false;
    protected boolean checkForCraft = false;
    protected int explosiveStackSizeRequired = 1;
    private ForgeDirection rotationCache;

    public TileWarheadStation() {
        super("worktable.warhead", "icbm");
    }

    protected ExternalInventory createInventory() {
        return new ExternalInventory((IInventoryProvider)this, 4);
    }

    public void update(long ticks) {
        super.update(ticks);
        if (this.isServer() && ticks % 10L == 0L && this.checkForCraft && this.isAutocrafting) {
            this.checkForCraft = false;
            if (this.canCraft()) {
                this.doCrafting();
            }
        }
    }

    public void doCrafting() {
        IWarhead warhead;
        ItemStack warheadStack = this.getWarheadStack();
        ItemStack explosiveStack = this.getExplosiveStack();
        ItemStack outputStack = this.getOutputStack();
        ItemStack triggerStack = this.getTriggerStack();
        if (warheadStack != null && warheadStack.func_77973_b() instanceof IWarheadItem && ExplosiveRegistry.get((ItemStack)explosiveStack) != null && (outputStack == null || outputStack.field_77994_a < outputStack.func_77976_d()) && (warhead = ((IWarheadItem)warheadStack.func_77973_b()).getModule(warheadStack)) != null && warhead.hasSpaceForExplosives(explosiveStack)) {
            int insert = Math.min(this.explosiveStackSizeRequired, Math.min(explosiveStack.field_77994_a, warhead.getSpaceForExplosives()));
            if (warhead.getExplosiveStack() == null) {
                ItemStack insertStack = explosiveStack.func_77946_l();
                insertStack.field_77994_a = insert;
                warhead.setExplosiveStack(insertStack);
            } else {
                warhead.getExplosiveStack().field_77994_a += insert;
                warhead.setExplosiveStack(warhead.getExplosiveStack());
            }
            if (triggerStack != null && warhead instanceof ITriggerAccepter && ((ITriggerAccepter)((Object)warhead)).getTrigger() == null) {
                triggerStack = ((ITriggerAccepter)((Object)warhead)).setTrigger(triggerStack);
            }
            ItemStack newWarhead = warhead.toStack();
            if (outputStack == null || InventoryUtility.stacksMatch((ItemStack)newWarhead, (ItemStack)outputStack)) {
                explosiveStack.field_77994_a -= insert;
                if (explosiveStack.field_77994_a <= 0) {
                    ((ExternalInventory)this.getInventory()).func_70299_a(1, null);
                } else {
                    ((ExternalInventory)this.getInventory()).func_70299_a(1, explosiveStack);
                }
                --warheadStack.field_77994_a;
                if (warheadStack.field_77994_a <= 0) {
                    ((ExternalInventory)this.getInventory()).func_70299_a(0, null);
                } else {
                    ((ExternalInventory)this.getInventory()).func_70299_a(0, warheadStack);
                }
                ((ExternalInventory)this.getInventory()).func_70299_a(3, triggerStack);
                if (this.getOutputStack() == null) {
                    ((ExternalInventory)this.getInventory()).func_70299_a(2, newWarhead);
                } else {
                    ++outputStack.field_77994_a;
                    ((ExternalInventory)this.getInventory()).func_70299_a(2, outputStack);
                }
            }
        }
    }

    public boolean canCraft() {
        IWarhead result;
        if (this.getWarheadStack() != null && (result = this.getCraftResultAsWarhead()) != null) {
            if (this.isAutocrafting) {
                if (this.requireTrigger && result instanceof ITriggerAccepter && ((ITriggerAccepter)((Object)result)).getTrigger() == null) {
                    return false;
                }
                if (this.requireExplosive) {
                    if (result.getExplosiveStack() == null) {
                        return false;
                    }
                    if (result.getExplosiveStack().field_77994_a < this.explosiveStackSizeRequired) {
                        return false;
                    }
                }
            }
            return this.getOutputStack() == null || InventoryUtility.stacksMatch((ItemStack)this.getCraftResult(), (ItemStack)result.toStack()) && InventoryUtility.roomLeftInSlot((IInventory)this.getInventory(), (int)2) > 0;
        }
        return false;
    }

    public float getCraftingProgress() {
        return 0.0f;
    }

    public List<ItemStack> getRequiredItems() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack insertRequiredItem(ItemStack stack, IAutomation entity, ForgeDirection side) {
        if (this.isAutocrafting && stack != null) {
            if (stack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                if (module instanceof IWarhead) {
                    if (this.getWarheadStack() == null) {
                        ItemStack insert = stack.func_77946_l();
                        insert.field_77994_a = 1;
                        ((ExternalInventory)this.getInventory()).func_70299_a(0, insert);
                        --stack.field_77994_a;
                        this.checkForCraft = true;
                        return stack;
                    }
                } else if (module instanceof ITrigger && this.getTriggerStack() == null) {
                    ItemStack insert = stack.func_77946_l();
                    insert.field_77994_a = 1;
                    ((ExternalInventory)this.getInventory()).func_70299_a(3, insert);
                    --stack.field_77994_a;
                    this.checkForCraft = true;
                    return stack;
                }
            } else if (ExplosiveRegistry.get((ItemStack)stack) != null && this.getTriggerStack() == null) {
                ItemStack insert = stack.func_77946_l();
                insert.field_77994_a = 1;
                ((ExternalInventory)this.getInventory()).func_70299_a(1, insert);
                --stack.field_77994_a;
                this.checkForCraft = true;
                return stack;
            }
        }
        return stack;
    }

    public ItemStack insertRequiredItem(ItemStack stack, int slot, IAutomation entity, ForgeDirection side) {
        if (this.isAutocrafting && stack != null) {
            if ((slot == 0 || slot == 3) && stack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                if (slot == 0 && module instanceof IWarhead) {
                    if (this.getWarheadStack() == null) {
                        ItemStack insert = stack.func_77946_l();
                        insert.field_77994_a = 1;
                        ((ExternalInventory)this.getInventory()).func_70299_a(0, insert);
                        --stack.field_77994_a;
                        this.checkForCraft = true;
                        return stack.field_77994_a <= 0 ? null : stack;
                    }
                } else if (slot == 3 && module instanceof ITrigger && this.getTriggerStack() == null) {
                    ItemStack insert = stack.func_77946_l();
                    insert.field_77994_a = 1;
                    ((ExternalInventory)this.getInventory()).func_70299_a(3, insert);
                    --stack.field_77994_a;
                    this.checkForCraft = true;
                    return stack.field_77994_a <= 0 ? null : stack;
                }
            } else if (slot == 1 && ExplosiveRegistry.get((ItemStack)stack) != null) {
                if (this.getExplosiveStack() == null) {
                    ItemStack insert = stack.func_77946_l();
                    insert.field_77994_a = 1;
                    ((ExternalInventory)this.getInventory()).func_70299_a(1, insert);
                    --stack.field_77994_a;
                    this.checkForCraft = true;
                    return stack.field_77994_a <= 0 ? null : stack;
                }
                if (InventoryUtility.stacksMatch((ItemStack)stack, (ItemStack)this.getExplosiveStack())) {
                    ItemStack explosiveStack = this.getExplosiveStack();
                    if (explosiveStack.field_77994_a >= this.explosiveStackSizeRequired) {
                        return stack;
                    }
                    int insert = Math.min(this.explosiveStackSizeRequired, InventoryUtility.roomLeftInSlot((IInventory)this.getInventory(), (int)1));
                    insert = Math.min(stack.field_77994_a, insert);
                    explosiveStack.field_77994_a += insert;
                    ((ExternalInventory)this.getInventory()).func_70299_a(1, explosiveStack);
                    stack.field_77994_a -= insert;
                    this.checkForCraft = true;
                    return stack.field_77994_a <= 0 ? null : stack;
                }
            }
        }
        return stack;
    }

    public int[] getCraftingOutputSlots(IAutomation entity, ForgeDirection side) {
        return OUTPUT_SLOTS;
    }

    public int[] getCraftingInputSlots(IAutomation entity, ForgeDirection side) {
        return INPUT_SLOTS;
    }

    public boolean canStore(ItemStack stack, ForgeDirection side) {
        if (stack.func_77973_b() instanceof IModuleItem) {
            IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
            return module instanceof IWarhead || module instanceof ITrigger;
        }
        return ExplosiveRegistry.get((ItemStack)stack) != null;
    }

    public boolean canRemove(ItemStack stack, ForgeDirection side) {
        return true;
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        this.checkForCraft = true;
        this.sendDescPacket();
    }

    public IWarhead getCraftResultAsWarhead() {
        IWarhead warhead;
        ItemStack warheadStack = this.getWarheadStack();
        ItemStack explosiveStack = this.getExplosiveStack();
        ItemStack triggerStack = this.getTriggerStack();
        if (warheadStack != null && warheadStack.func_77973_b() instanceof IWarheadItem && (warhead = ((IWarheadItem)warheadStack.func_77973_b()).getModule(warheadStack)) != null) {
            if ((!this.isAutocrafting || this.requireExplosive) && ExplosiveRegistry.get((ItemStack)explosiveStack) != null && warhead.hasSpaceForExplosives(explosiveStack)) {
                int insert = Math.min(this.explosiveStackSizeRequired, Math.min(explosiveStack.field_77994_a, warhead.getSpaceForExplosives()));
                if (warhead.getExplosiveStack() == null) {
                    ItemStack insertStack = explosiveStack.func_77946_l();
                    insertStack.field_77994_a = insert;
                    warhead.setExplosiveStack(insertStack);
                } else {
                    warhead.getExplosiveStack().field_77994_a += insert;
                    warhead.setExplosiveStack(warhead.getExplosiveStack());
                }
            }
            if ((!this.isAutocrafting || this.requireTrigger) && triggerStack != null && warhead instanceof ITriggerAccepter && ((ITriggerAccepter)((Object)warhead)).getTrigger() == null) {
                ((ITriggerAccepter)((Object)warhead)).setTrigger(triggerStack);
            }
            return warhead;
        }
        return null;
    }

    public ItemStack getCraftResult() {
        IWarhead result = this.getCraftResultAsWarhead();
        return result != null ? result.toStack() : null;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        if (stack != null) {
            if (0 == slot) {
                return stack.func_77973_b() instanceof IModuleItem && ((IModuleItem)stack.func_77973_b()).getModule(stack) instanceof IWarhead;
            }
            if (1 == slot) {
                return ExplosiveRegistry.get((ItemStack)stack) != null;
            }
            if (3 == slot) {
                return stack.func_77973_b() instanceof IModuleItem && ((IModuleItem)stack.func_77973_b()).getModule(stack) instanceof ITrigger;
            }
        }
        return false;
    }

    public boolean canRemove(ItemStack stack, int slot, ForgeDirection side) {
        return slot == 2;
    }

    protected ItemStack getWarheadStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(0);
    }

    protected ItemStack getExplosiveStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(1);
    }

    protected ItemStack getOutputStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(2);
    }

    protected ItemStack getTriggerStack() {
        return ((ExternalInventory)this.getInventory()).func_70301_a(3);
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isServer()) {
                if (id == 1) {
                    this.doCrafting();
                    return true;
                }
                if (id == 2) {
                    int guiID = buf.readInt();
                    player.openGui((Object)ICBM.INSTANCE, guiID, (World)this.world().unwrap(), this.xi(), this.yi(), this.zi());
                    return true;
                }
                if (id == 3) {
                    this.isAutocrafting = buf.readBoolean();
                    this.explosiveStackSizeRequired = Math.min(Math.max(1, buf.readInt()), 64);
                    this.requireExplosive = buf.readBoolean();
                    this.requireTrigger = buf.readBoolean();
                    this._doUpdateGuiUsers();
                    return true;
                }
            } else if (id == 5) {
                this.isAutocrafting = buf.readBoolean();
                this.explosiveStackSizeRequired = buf.readInt();
                this.requireExplosive = buf.readBoolean();
                this.requireTrigger = buf.readBoolean();
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof GuiWarheadStation) {
                    screen.func_73866_w_();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
    }

    public void sendCraftingPacket() {
        this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{1}));
    }

    public void sendGUIDataUpdate() {
        this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{3, this.isAutocrafting, this.explosiveStackSizeRequired, this.requireExplosive, this.requireTrigger}));
    }

    public void switchTab(int tab) {
        this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{2, tab}));
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.isAutocrafting = this.getBoolean(nbt, "isAutocrafting", false);
        this.requireExplosive = this.getBoolean(nbt, "requireExplosive", true);
        this.requireTrigger = this.getBoolean(nbt, "requireTrigger", false);
        this.checkForCraft = this.getBoolean(nbt, "checkForCraft", false);
        if (nbt.func_74764_b("explosiveStackSizeRequired")) {
            this.explosiveStackSizeRequired = nbt.func_74762_e("explosiveStackSizeRequired");
        }
    }

    private boolean getBoolean(NBTTagCompound nbt, String key, boolean b) {
        return nbt.func_74764_b(key) ? nbt.func_74767_n(key) : b;
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("isAutocrafting", this.isAutocrafting);
        nbt.func_74757_a("requireExplosive", this.requireExplosive);
        nbt.func_74757_a("requireTrigger", this.requireTrigger);
        nbt.func_74757_a("checkForCraft", this.checkForCraft);
        nbt.func_74768_a("explosiveStackSizeRequired", this.explosiveStackSizeRequired);
        return nbt;
    }

    public void _doUpdateGuiUsers() {
        this.sendPacketToGuiUsers(this.getHost().getPacketForData(new Object[]{5, this.isAutocrafting, this.explosiveStackSizeRequired, this.requireExplosive, this.requireTrigger}));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerWarheadStation(player, this, ID);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiWarheadStation(player, this, ID);
    }

    public ForgeDirection getDirection() {
        if (this.rotationCache == null) {
            this.rotationCache = ForgeDirection.getOrientation((int)this.getHost().getHostMeta()).getOpposite();
        }
        return this.rotationCache;
    }
}

