/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.fragments;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.fragments.DamageFragment;
import com.builtbroken.icbm.content.fragments.FragmentType;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.api.data.EnumProjectileTypes;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.prefab.entity.EntityProjectile;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class EntityFragment
extends EntityProjectile
implements IEntityAdditionalSpawnData {
    public static final double GLASS_BREAK_VELOCITY = 0.1;
    private FragmentType fragmentType;
    private ItemStack fragmentMaterial;
    private Cube renderShape;

    public EntityFragment(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.setRenderShape(new Cube(0.0, 0.0, 0.0, 0.05 + (double)MathUtility.rand.nextFloat() * 0.3, 0.05 + (double)MathUtility.rand.nextFloat() * 0.3, 0.05 + (double)MathUtility.rand.nextFloat() * 0.3));
    }

    public EntityFragment(World world, FragmentType fragmentType) {
        this(world);
        this.setFragmentType(fragmentType);
    }

    public EntityFragment(World world, FragmentType fragmentType, Item block) {
        this(world);
        this.setFragmentType(fragmentType);
        this.setFragmentMaterial(block);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isOnFire()) {
            Pos orginalVel = (Pos)((Pos)new Pos(this.field_70159_w, this.field_70181_x, this.field_70179_y).normalize()).multiply(-0.1);
            IWorld world = Engine.minecraft.getWorld(this.field_70170_p.field_73011_w.field_76574_g);
            Pos vel = (Pos)orginalVel.addRandom(this.field_70170_p.field_73012_v, 0.1);
            world.spawnParticle("fire", this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)vel.xf(), (double)vel.yf(), (double)vel.zf());
            vel = (Pos)orginalVel.addRandom(this.field_70170_p.field_73012_v, 0.1);
            world.spawnParticle("fire", this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)vel.xf(), (double)vel.yf(), (double)vel.zf());
            vel = (Pos)orginalVel.addRandom(this.field_70170_p.field_73012_v, 0.1);
            world.spawnParticle("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)vel.xf(), (double)vel.yf(), (double)vel.zf());
            vel = (Pos)orginalVel.addRandom(this.field_70170_p.field_73012_v, 0.1);
            world.spawnParticle("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)vel.xf(), (double)vel.yf(), (double)vel.zf());
        }
    }

    public boolean isOnFire() {
        return this.getFragmentType() != null && this.getFragmentType() == FragmentType.BLAZE || this.func_70027_ad();
    }

    protected void handleBlockCollision(MovingObjectPosition movingobjectposition) {
        this.xTile = movingobjectposition.field_72311_b;
        this.yTile = movingobjectposition.field_72312_c;
        this.zTile = movingobjectposition.field_72309_d;
        this.sideTile = movingobjectposition.field_72310_e;
        this.inBlockID = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        if (this.inBlockID.field_149782_v > -1.0f && this.inBlockID.field_149782_v < 100.0f) {
            if (this.inBlockID.field_149764_J == Material.field_151592_s || this.inBlockID.field_149764_J == Material.field_151580_n || this.inBlockID.field_149764_J == Material.field_151584_j) {
                if ((double)this.getSpeed() > 0.1) {
                    this.field_70170_p.func_147468_f(this.xTile, this.yTile, this.zTile);
                    this.field_70159_w -= this.field_70159_w * (double)(this.inBlockID.field_149782_v / 100.0f);
                    this.field_70181_x -= this.field_70181_x * (double)(this.inBlockID.field_149782_v / 100.0f);
                    this.field_70179_y -= this.field_70179_y * (double)(this.inBlockID.field_149782_v / 100.0f);
                } else {
                    this.func_70106_y();
                }
                return;
            }
            if (this.inBlockID == Blocks.field_150335_W && this.getFragmentType() == FragmentType.BLAZE) {
                this.field_70170_p.func_147468_f(this.xTile, this.yTile, this.zTile);
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.field_70170_p, (double)((float)this.xTile + 0.5f), (double)((float)this.yTile + 0.5f), (double)((float)this.zTile + 0.5f), this.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)this.shootingEntity : null);
                entitytntprimed.field_70516_a = this.field_70170_p.field_73012_v.nextInt(20) + 3;
                this.field_70170_p.func_72838_d((Entity)entitytntprimed);
                this.func_70106_y();
                return;
            }
        }
        this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
        float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)velocity * (double)0.05f;
        this.field_70163_u -= this.field_70181_x / (double)velocity * (double)0.05f;
        this.field_70161_v -= this.field_70179_y / (double)velocity * (double)0.05f;
        if (!this.inGround && this.isOnFire() && this.field_70170_p.field_73012_v.nextBoolean()) {
            Pos firePos = (Pos)new Pos(movingobjectposition).add(ForgeDirection.getOrientation((int)movingobjectposition.field_72310_e));
            if (firePos.isReplaceable(this.field_70170_p) && this.inBlockID != Blocks.field_150355_j && this.inBlockID != Blocks.field_150358_i && !(this.inBlockID instanceof IFluidBlock) && !(this.inBlockID instanceof BlockLiquid)) {
                firePos.setBlock(this.field_70170_p, (Block)Blocks.field_150480_ab);
                this.field_70170_p.func_147471_g(firePos.xi(), firePos.yi(), firePos.zi());
            }
            if (this.getFragmentType() == FragmentType.BLAZE) {
                this.func_70106_y();
                return;
            }
        }
        this.inGround = true;
        if (this.inBlockID.func_149688_o() != Material.field_151579_a) {
            this.inBlockID.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
        this.onImpactTile();
    }

    protected void onImpactTile() {
        this.inGroundKillTime = 20 + this.field_70170_p.field_73012_v.nextInt(300);
        if (this.getFragmentType() != FragmentType.BLOCK) {
            this.inGroundKillTime = 2000;
        }
    }

    protected void onImpactEntity(Entity entityHit, float velocity) {
        if (!(entityHit instanceof EntityFragment)) {
            float vel_horizontal;
            if (this.getFragmentType() == null) {
                return;
            }
            float damage = 1.0f;
            if (this.getFragmentType() == FragmentType.BLOCK && this.getFragmentItem() != null) {
                damage = this.getDamageForFragment() * velocity;
            }
            if (this.func_70027_ad()) {
                entityHit.func_70015_d(5);
            }
            if (entityHit.func_70097_a((DamageSource)new DamageFragment(this.getFragmentType().name().toLowerCase(), entityHit, (Entity)this), damage) && entityHit instanceof EntityLivingBase && (vel_horizontal = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                entityHit.func_70024_g(this.field_70159_w * (double)0.6f / (double)vel_horizontal, 0.1, this.field_70179_y * (double)0.6f / (double)vel_horizontal);
            }
            this.func_70106_y();
        }
    }

    public float getDamageForFragment() {
        if (this.getFragmentItem() != null) {
            if (this.getFragmentType() == FragmentType.BLOCK) {
                Block block = Block.func_149634_a((Item)this.getFragmentItem());
                return block.field_149782_v;
            }
            if (this.getFragmentItem() instanceof ItemSword) {
                return ((ItemSword)this.getFragmentItem()).func_150931_i();
            }
        }
        return 1.0f;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        NBTTagCompound itemSave;
        ItemStack stack;
        int i;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("fragmentType") && (i = nbt.func_74762_e("fragmentType")) > 0 && i < FragmentType.values().length) {
            this.setFragmentType(FragmentType.values()[i]);
        }
        if (nbt.func_74764_b("blockToMimic")) {
            this.setFragmentMaterial(Block.func_149729_e((int)nbt.func_74762_e("blockToMimic")));
        }
        if (nbt.func_74764_b("itemToMimic") && (stack = ItemStack.func_77949_a((NBTTagCompound)(itemSave = nbt.func_74775_l("itemToMimic")))) != null && stack.func_77973_b() != null) {
            this.setFragmentMaterial(stack);
        }
        if (nbt.func_74764_b("renderShape")) {
            this.setRenderShape(new Cube(nbt.func_74775_l("renderShape")));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getFragmentType() != null) {
            nbt.func_74768_a("fragmentType", this.getFragmentType().ordinal());
        }
        if (this.getFragmentMaterial() != null) {
            nbt.func_74782_a("itemToMimic", (NBTBase)this.getFragmentMaterial().func_77955_b(new NBTTagCompound()));
        }
        if (this.getRenderShape() != null) {
            nbt.func_74782_a("renderShape", (NBTBase)this.getRenderShape().toNBT());
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.getFragmentType() != null) {
            buffer.writeByte(this.getFragmentType().ordinal());
        } else {
            buffer.writeByte(-1);
        }
        if (this.getFragmentMaterial() != null) {
            buffer.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.getFragmentMaterial().func_77955_b(new NBTTagCompound()));
        } else {
            buffer.writeBoolean(false);
        }
        if (this.getRenderShape() != null) {
            buffer.writeBoolean(true);
            this.getRenderShape().writeBytes(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            byte index = additionalData.readByte();
            if (index >= 0 && index < FragmentType.values().length) {
                this.setFragmentType(FragmentType.values()[index]);
            }
            if (additionalData.readBoolean()) {
                this.setFragmentMaterial(ItemStack.func_77949_a((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)additionalData)));
            }
            if (additionalData.readBoolean()) {
                this.setRenderShape(new Cube(additionalData));
            }
        }
        catch (Exception e) {
            ICBM.INSTANCE.logger().error("Failed to read spawn data for " + (Object)((Object)this));
        }
    }

    public String toString() {
        return "EntityFragment[ dim@" + (this.field_70170_p != null && this.field_70170_p.field_73011_w != null ? Integer.valueOf(this.field_70170_p.field_73011_w.field_76574_g) : "null") + " " + this.field_70165_t + "x " + this.field_70163_u + "y " + this.field_70161_v + "z | " + (Object)((Object)this.getFragmentType()) + "]@" + this.hashCode();
    }

    public EnumProjectileTypes getProjectileType() {
        return EnumProjectileTypes.FRAGMENT;
    }

    public FragmentType getFragmentType() {
        return this.fragmentType;
    }

    public void setFragmentType(FragmentType fragmentType) {
        this.fragmentType = fragmentType;
    }

    public Item getFragmentItem() {
        return this.getFragmentMaterial() != null ? this.getFragmentMaterial().func_77973_b() : null;
    }

    public Block getFragmentBlock() {
        Item item = this.getFragmentItem();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public ItemStack getFragmentMaterial() {
        return this.fragmentMaterial;
    }

    public void setFragmentMaterial(Item fragmentMaterial) {
        this.fragmentMaterial = new ItemStack(fragmentMaterial, 1, 0);
    }

    public void setFragmentMaterial(ItemStack fragmentMaterial) {
        this.fragmentMaterial = fragmentMaterial;
    }

    public void setFragmentMaterial(Block fragmentMaterial) {
        this.fragmentMaterial = new ItemStack(fragmentMaterial, 1, 0);
    }

    public Cube getRenderShape() {
        return this.renderShape;
    }

    public void setRenderShape(Cube renderShape) {
        this.renderShape = renderShape;
    }
}

