/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.items;

import com.builtbroken.jlib.lang.TextColor;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.items.listeners.IItemActivationListener;
import com.builtbroken.mc.api.items.tools.IPassCodeItem;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.codegen.annotations.ItemWrapped;
import com.builtbroken.mc.framework.item.ItemNode;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

@ItemWrapped(className=".gen.ItemWrapperLinkTool", wrappers="IWorldPos;EnergyUE")
public class ItemLinkTool
extends ItemNode
implements IPassCodeItem,
IItemActivationListener {
    public ItemLinkTool() {
        super("icbm", "siloLinker");
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player != null && player.func_70093_af()) {
            stack.func_77982_d(null);
            stack.func_77964_b(0);
            LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.cleared");
            player.field_71069_bz.func_75142_b();
        }
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hit_x, float hit_y, float hit_z) {
        if (player != null && stack != null && stack.func_77973_b() instanceof IWorldPosItem) {
            Location storedLocation;
            IMultiTileHost host;
            if (world.field_72995_K) {
                return true;
            }
            Location location = new Location(world, (double)x, (double)y, (double)z);
            TileEntity tile = location.getTileEntity();
            if (tile instanceof IMultiTile && (host = ((IMultiTile)tile).getHost()) instanceof TileEntity) {
                tile = (TileEntity)host;
            }
            if (player.func_70093_af()) {
                storedLocation = ((IWorldPosItem)stack.func_77973_b()).getLocation(stack);
                if (storedLocation != null && storedLocation.equals((Object)location)) {
                    LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.error.data.stored");
                    return true;
                }
                ((IWorldPosItem)stack.func_77973_b()).setLocation(stack, (IWorldPosition)location);
                LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.pos.set");
                if (tile instanceof IPassCode) {
                    this.setCode(stack, ((IPassCode)tile).getCode());
                } else if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof IPassCode) {
                    this.setCode(stack, ((IPassCode)((ITileNodeHost)tile).getTileNode()).getCode());
                }
                stack.func_77964_b(1);
                player.field_71069_bz.func_75142_b();
                return true;
            }
            storedLocation = ((IWorldPosItem)stack.func_77973_b()).getLocation(stack);
            if (storedLocation != null) {
                if (!storedLocation.equals((Object)location)) {
                    if (!storedLocation.isAboveBedrock()) {
                        LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.error.pos.invalid");
                        return true;
                    }
                    if (tile instanceof ILinkable || tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof ILinkable) {
                        ILinkable linkable = tile instanceof ILinkable ? (ILinkable)tile : (ILinkable)((ITileNodeHost)tile).getTileNode();
                        String result = linkable.link(storedLocation, this.getCode(stack));
                        if (result != null && !result.isEmpty()) {
                            if (result.contains("error")) {
                                String translation = LanguageUtility.getLocalName((String)result);
                                if (translation == null || translation.isEmpty()) {
                                    translation = "Error";
                                }
                                player.func_146105_b((IChatComponent)new ChatComponentText(TextColor.RED.getColorString() + translation));
                            } else {
                                LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)result);
                            }
                        } else {
                            LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.completed");
                        }
                        return true;
                    }
                    LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.error.pos.invalid");
                    return true;
                }
                LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.error.pos.loop");
                return true;
            }
            LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)"link.error.pos.invalid");
            return true;
        }
        return false;
    }

    public short getCode(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IWorldPosItem && stack.func_77942_o() && stack.func_77978_p().func_74764_b("passShort")) {
            return stack.func_77978_p().func_74765_d("passShort");
        }
        return 0;
    }

    public void setCode(ItemStack stack, short code) {
        if (stack != null && stack.func_77973_b() instanceof IWorldPosItem) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74777_a("passShort", code);
        }
    }
}

