/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher;

import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.mc.api.ISave;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LauncherReport
implements ISave {
    public UUID entityUUID;
    public IMissile missile;
    public boolean impacted;
    public long launchTime = 0L;
    public long deathTime = 0L;

    public LauncherReport(EntityMissile missile) {
        this.entityUUID = missile.func_110124_au();
        this.missile = missile.getMissile();
        this.launchTime = System.nanoTime();
    }

    public LauncherReport(NBTTagCompound nbt) {
        this.load(nbt);
    }

    public void load(NBTTagCompound nbt) {
        ItemStack missileStack;
        if (nbt.func_74764_b("missile") && (missileStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("missile"))) != null && missileStack.func_77973_b() instanceof IMissileItem) {
            this.missile = ((IMissileItem)missileStack.func_77973_b()).toMissile(missileStack);
        }
        if (nbt.func_74764_b("start")) {
            this.launchTime = nbt.func_74763_f("start");
        }
        if (nbt.func_74764_b("end")) {
            this.deathTime = nbt.func_74763_f("end");
        }
        this.impacted = nbt.func_74767_n("impact");
        if (nbt.func_74764_b("UUID")) {
            this.entityUUID = UUID.fromString(nbt.func_74779_i("UUID"));
        }
    }

    public NBTTagCompound save() {
        return this.save(new NBTTagCompound());
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.missile != null) {
            nbt.func_74782_a("missile", (NBTBase)this.missile.toStack().func_77955_b(new NBTTagCompound()));
        }
        if (this.launchTime != 0L) {
            nbt.func_74772_a("start", this.launchTime);
        }
        if (this.deathTime != 0L) {
            nbt.func_74772_a("end", this.deathTime);
        }
        if (this.impacted) {
            nbt.func_74757_a("impact", true);
        }
        if (this.entityUUID != null) {
            nbt.func_74778_a("UUID", this.entityUUID.toString());
        }
        return nbt;
    }
}

