/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher;

import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.missile.data.missile.Missile;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.api.rails.IRailInventoryTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.framework.block.imp.IActivationListener;
import com.builtbroken.mc.prefab.inventory.ExternalInventory;
import com.builtbroken.mc.prefab.tile.logic.TileMachineNode;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMissileContainer
extends TileMachineNode<IInventory>
implements IRailInventoryTile<IInventory>,
IActivationListener {
    protected IMissile missile;

    public TileMissileContainer(String id, String mod) {
        super(id, mod);
    }

    protected IInventory createInventory() {
        return new ExternalInventory((IInventoryProvider)this, 1);
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        if (stack.func_77973_b() instanceof IMissileItem) {
            this.getInventory().func_70299_a(0, stack);
        } else {
            this.getInventory().func_70299_a(0, null);
        }
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)(this.getInventory().func_70301_a(0) != null ? this.getInventory().func_70301_a(0) : new ItemStack(Blocks.field_150348_b)));
    }

    protected boolean shouldCacheMissile() {
        return false;
    }

    public boolean onPlayerActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.playerRemoveMissile(player, side, hitX, hitY, hitZ) || this.playerAddMissile(player, side, hitX, hitY, hitZ);
    }

    public boolean playerRemoveMissile(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() == null && this.getMissile() != null) {
            if (this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("*Removed Missile*"));
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = this.getMissile().toStack();
                this.getInventory().func_70299_a(0, null);
                player.field_71069_bz.func_75142_b();
                this.sendDescPacket();
            }
            return true;
        }
        return false;
    }

    public boolean playerAddMissile(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && this.getMissile() == null) {
            if (this.isServer() && heldItem.func_77973_b() instanceof IMissileItem) {
                IMissile missile = ((IMissileItem)heldItem.func_77973_b()).toMissile(heldItem);
                if (this.canAcceptMissile(missile)) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("*Added Missile*"));
                    ItemStack stack = heldItem.func_77946_l();
                    stack.field_77994_a = 1;
                    this.getInventory().func_70299_a(0, stack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --heldItem.field_77994_a;
                        if (heldItem.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                        player.field_71069_bz.func_75142_b();
                    }
                    this.sendDescPacket();
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("*Missile will not fit*"));
                }
            }
            return true;
        }
        return false;
    }

    public boolean canAcceptMissile(IMissile missile) {
        return missile != null;
    }

    public boolean storeMissile(IMissile missile) {
        if (this.getMissileItem() == null) {
            this.getInventory().func_70299_a(0, missile.toStack());
            this.sendDescPacket();
            return true;
        }
        return false;
    }

    public IMissile getMissile() {
        if (this.shouldCacheMissile()) {
            if (this.missile == null) {
                this.missile = this.createMissileObject();
            }
            if (this.missile != null) {
                return this.missile;
            }
        }
        return this.missile != null ? this.missile : this.createMissileObject();
    }

    protected IMissile createMissileObject() {
        return this.getMissileItem() != null && this.getMissileItem().func_77973_b() instanceof IMissileItem ? ((IMissileItem)this.getMissileItem().func_77973_b()).toMissile(this.getMissileItem()) : null;
    }

    public ItemStack getMissileItem() {
        return this.getInventory().func_70301_a(0);
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (this.world() != null && slot == 0) {
            this.sendDescPacket();
            if (this.shouldCacheMissile()) {
                this.missile = this.createMissileObject();
            }
        }
    }

    public int[] getSlotsToLoad(ForgeDirection side) {
        return new int[]{0};
    }

    public int[] getSlotsToUnload(ForgeDirection side) {
        return new int[]{0};
    }

    public boolean canStore(ItemStack slotStack, int slot, ForgeDirection side) {
        if (slot == 0) {
            IMissile missile = null;
            if (slotStack.func_77973_b() instanceof IMissileItem) {
                missile = ((IMissileItem)slotStack.func_77973_b()).toMissile(slotStack);
            } else if (slotStack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)slotStack.func_77973_b()).getModule(slotStack);
                if (module instanceof IMissile) {
                    missile = (IMissile)module;
                }
            } else {
                missile = new Missile(slotStack);
            }
            return missile != null && this.canAcceptMissile(missile);
        }
        return false;
    }

    public boolean canRemove(ItemStack slotStack, int slot, ForgeDirection side) {
        return slot == 0;
    }

    public boolean canStore(ItemStack stack, ForgeDirection side) {
        return true;
    }

    public boolean canRemove(ItemStack stack, ForgeDirection side) {
        return true;
    }
}

