/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.block;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.content.launcher.launcher.TileStandardLauncher;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.jlib.data.Colors;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.data.Direction;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.block.imp.IWrenchListener;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class LauncherPartListener
extends TileListener
implements IWrenchListener,
IBlockListener {
    public static final int MICRO_LAUNCHER_HEIGHT = 1;
    public static final int SMALL_LAUNCHER_HEIGHT = 2;
    public static final int STANDARD_LAUNCHER_HEIGHT = 5;
    public static final int MEDIUM_LAUNCHER_HEIGHT = 17;

    public boolean onPlayerRightClickWrench(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta;
        Direction facingSide = Direction.getOrientation((int)side);
        if (this.world() != null && (meta = this.getBlockMeta()) == 0 && player.func_70093_af() && side != 0 && side != 1) {
            if (this.isServer()) {
                MissileSize missileSize;
                BlockPos frameStart = new BlockPos(this.xi(), this.yi() + 1, this.zi());
                int frameCount = LauncherPartListener.getFrameCount((World)this.world().unwrap(), frameStart);
                if (this.world().unwrap() != DimensionManager.getWorld((int)((World)this.world().unwrap()).field_73011_w.field_76574_g)) {
                    System.out.println("error");
                }
                if ((missileSize = LauncherPartListener.getLauncherSize(frameCount)) == null) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Detected " + frameCount + " launcher frame blocks, micro requires 1, small 2, standard 5, medium 17"));
                    return true;
                }
                if (!LauncherPartListener.isPathClear((World)this.world().unwrap(), frameStart.add(facingSide), frameCount, facingSide)) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("To prevent issues clear the blocks from the side of the tower that the missile will occupy. micro, small, and standard need 1x1 block space. Medium needs 3x3 block space to be placed."));
                    return true;
                }
                Block launcherBlock = ICBM_API.blockStandardLauncher;
                if (new Pos((IPos3D)this).setBlock((World)this.world().unwrap(), launcherBlock, side)) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.capitalizeFirst((String)missileSize.name().toLowerCase()) + " launcher created"));
                    TileEntity tile = this.getTileEntity();
                    if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof TileStandardLauncher) {
                        ((TileStandardLauncher)((ITileNodeHost)tile).getTileNode()).missileSize = missileSize;
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText(Colors.RED.code + "Error: Failed to set missile size for tile, this is a bug."));
                    }
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(Colors.RED.code + "Error: Failed to convert CPU block to standard launcher block. Check console for error messages and world for protection plugins preventing action."));
                }
            }
            return true;
        }
        return false;
    }

    public static MissileSize getLauncherSize(int frameCount) {
        if (frameCount == 17) {
            return MissileSize.MEDIUM;
        }
        if (frameCount == 5) {
            return MissileSize.STANDARD;
        }
        if (frameCount == 2) {
            return MissileSize.SMALL;
        }
        if (frameCount == 1) {
            return MissileSize.MICRO;
        }
        return null;
    }

    public static int getFrameCount(World world, BlockPos start) {
        int count = 0;
        Block block = start.getBlock(world);
        while (count < 255 && block == ICBM_API.blockLauncherFrame) {
            block = world.func_147439_a(start.xi(), start.yi() + ++count, start.zi());
        }
        return count;
    }

    public static boolean isPathClear(World world, BlockPos start, int height, Direction side) {
        for (int i = 0; i < height; ++i) {
            if (height != 17) {
                if (new BlockPos(start.xi(), start.yi() + i, start.zi()).add(side).isAirBlock(world)) continue;
                return false;
            }
            start = start.add(side);
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (((Pos)new Pos((double)(start.xi() + x), (double)(start.yi() + i), (double)(start.zi() + z)).add(side)).isAirBlock(world)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("activation");
        list.add("wrench");
        return list;
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        public ITileEventListener createListener(Block block) {
            return new LauncherPartListener();
        }

        public String getListenerKey() {
            return "launcherPartListener";
        }
    }
}

