/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.api.controller.ISiloConnectionPoint;
import com.builtbroken.icbm.api.launcher.ILauncher;
import com.builtbroken.icbm.api.launcher.INamedLauncher;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.controller.remote.display.TileSiloInterface;
import com.builtbroken.jlib.data.network.IByteBufReader;
import com.builtbroken.jlib.data.network.IByteBufWriter;
import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.map.radio.wireless.ConnectionStatus;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class SiloConnectionData
implements ISiloConnectionData,
ISave,
IByteBufWriter,
IByteBufReader {
    public World world;
    public int dim;
    public int x;
    public int y;
    public int z;
    protected ILauncher launcher;

    public SiloConnectionData(ILauncher launcher) {
        this.launcher = launcher;
        this.world = (World)launcher.world().unwrap();
        this.x = (int)Math.floor(launcher.x());
        this.y = (int)Math.floor(launcher.y());
        this.z = (int)Math.floor(launcher.z());
    }

    public SiloConnectionData(NBTTagCompound compoundTagAt) {
        this.load(compoundTagAt);
    }

    public SiloConnectionData(ByteBuf buf) {
        this.readBytes(buf);
    }

    @Override
    public String getSiloName() {
        return this.getSilo() instanceof INamedLauncher ? ((INamedLauncher)this.getSilo()).getLauncherName() : null;
    }

    @Override
    public ILauncher getSilo() {
        if (this.launcher instanceof TileEntity && ((TileEntity)this.launcher).func_145837_r() || this.launcher instanceof Entity && !((Entity)this.launcher).func_70089_S() || this.launcher instanceof ITileNode && !((ITileNode)this.launcher).getHost().isHostValid()) {
            this.launcher = null;
        }
        if (this.oldWorld() != null && this.launcher == null && this.oldWorld().func_72899_e(this.x, this.y, this.z)) {
            TileEntity tile = this.oldWorld().func_147438_o(this.x, this.y, this.z);
            if (tile instanceof ILauncher) {
                this.launcher = (ILauncher)tile;
            } else if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof ILauncher) {
                this.launcher = (ILauncher)((ITileNodeHost)tile).getTileNode();
            }
        }
        return this.launcher;
    }

    @Override
    public IMissile getMissile() {
        return this.getSilo() != null ? this.getSilo().getMissile() : null;
    }

    @Override
    public ConnectionStatus getSiloStatus() {
        ILauncher launcher = this.getSilo();
        if (launcher == null) {
            return ConnectionStatus.NO_CONNECTION;
        }
        return ConnectionStatus.ONLINE;
    }

    @Override
    public void openGui(EntityPlayer player, Object openingTile, ISiloConnectionPoint connector) {
        if (this.oldWorld() != null && !this.oldWorld().field_72995_K && this.getSilo() != null) {
            if (this.getSilo() instanceof TileAbstractLauncher) {
                TileAbstractLauncher launcher = (TileAbstractLauncher)this.getSilo();
                Object[] data = new Object[]{openingTile, connector};
                launcher.returnGuiData.put(player, data);
            }
            player.openGui((Object)ICBM.INSTANCE, openingTile instanceof TileSiloInterface ? 1 : 2, this.world, this.x, this.y, this.z);
        }
    }

    @Override
    public boolean hasSettingsGui() {
        return true;
    }

    public World oldWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld((int)this.dim);
        }
        return this.world;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public void load(NBTTagCompound nbt) {
        this.dim = nbt.func_74762_e("dim");
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74768_a("dim", this.world == null ? 0 : this.world.field_73011_w.field_76574_g);
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        return nbt;
    }

    public Object readBytes(ByteBuf buf) {
        this.load(ByteBufUtils.readTag((ByteBuf)buf));
        return this;
    }

    public ByteBuf writeBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.save(new NBTTagCompound()));
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SiloConnectionData) {
            return ((SiloConnectionData)obj).dim == this.dim && ((SiloConnectionData)obj).x == this.x && ((SiloConnectionData)obj).y == this.y && ((SiloConnectionData)obj).z == this.z;
        }
        return false;
    }
}

