/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.direct;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.controller.direct.GuiSiloController;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.items.ItemBlockAbstract;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileMachine;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TileSiloController
extends TileMachine
implements IPostInit,
IPacketIDReceiver,
IGuiTile {
    @SideOnly(value=Side.CLIENT)
    private static IIcon top;
    @SideOnly(value=Side.CLIENT)
    private static IIcon side;
    protected boolean inRedstoneMode = true;
    protected TileAbstractLauncher launcher;

    public TileSiloController() {
        super("siloController", Material.field_151573_f);
        this.itemBlock = ItemBlockAbstract.class;
        this.canEmmitRedstone = true;
        this.resistance = 5.0f;
        this.hardness = 10.0f;
    }

    public Tile newTile() {
        return new TileSiloController();
    }

    public void update() {
        super.update();
        if (this.ticks % 20L == 0L && this.launcher == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Pos pos = (Pos)this.toPos().add(dir);
                ITileNode tile = pos.getTileNode((IBlockAccess)this.oldWorld());
                if (!(tile instanceof TileAbstractLauncher)) continue;
                this.launcher = (TileAbstractLauncher)tile;
                break;
            }
            if (this.launcher != null && this.inRedstoneMode && this.isIndirectlyPowered()) {
                this.launcher.fireMissile();
            }
        }
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            if (this.inRedstoneMode) {
                this.inRedstoneMode = false;
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.icbm:siloController.msg.redstone.enabled", new Object[0]));
            } else {
                this.inRedstoneMode = true;
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.icbm:siloController.msg.redstone.disabled", new Object[0]));
            }
        }
        return true;
    }

    public Tile newTile(World world, int meta) {
        return new TileSiloController();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        side = iconRegister.func_94245_a("icbm:controller.direct.silo");
        top = iconRegister.func_94245_a("icbm:controller.direct.silo.top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int face) {
        if (face == 1) {
            return top;
        }
        return side;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("redstoneMode")) {
            this.inRedstoneMode = nbt.func_74767_n("redstoneMode");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("redstoneMode", this.inRedstoneMode);
    }

    public void onPostInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBM_API.blockDirectSiloController), new Object[]{"ITI", "ZCZ", "RER", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('Z'), UniversalRecipe.WIRE.get(), Character.valueOf('E'), Items.field_151061_bv}));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy();
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiSiloController(player, this);
    }
}

