/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.local;

import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.content.launcher.controller.local.TileLocalController;
import com.builtbroken.icbm.content.launcher.launcher.TileStandardLauncher;
import com.builtbroken.mc.api.map.radio.wireless.ConnectionStatus;
import com.builtbroken.mc.client.SharedAssets;
import com.builtbroken.mc.imp.transform.region.Rectangle;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.gui.EnumGuiIconSheet;
import com.builtbroken.mc.prefab.gui.GuiButton2;
import com.builtbroken.mc.prefab.gui.GuiContainerBase;
import com.builtbroken.mc.prefab.gui.buttons.GuiImageButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class GuiLocalController
extends GuiContainerBase {
    protected TileLocalController controller;
    List<ConnectionStatus> connectionStatuses = new ArrayList<ConnectionStatus>();
    long lastClickTime = 0L;
    private int ticks = 0;
    private static int updateGuiTicks = 100;
    private final String launcherLabel;
    private final String siloLabel;
    int buttonRowX = 30;
    int buttonRowY = 30;

    public GuiLocalController(TileLocalController launcher, EntityPlayer player) {
        super((Container)new ContainerDummy(player, (Object)launcher));
        this.controller = launcher;
        this.baseTexture = SharedAssets.GUI__MC_EMPTY_FILE;
        this.launcherLabel = LanguageUtility.getLocalName((String)"gui.icbm:controller.launcher");
        this.siloLabel = LanguageUtility.getLocalName((String)"gui.icbm:controller.silo");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(GuiImageButton.newRefreshButton((int)0, (int)(this.field_147003_i + 150), (int)(this.field_147009_r + 5)));
        this.connectionStatuses.clear();
        if (this.controller.launcherData != null) {
            int i;
            int row = 0;
            for (i = 0; i < this.controller.launcherData.size() && i < TileLocalController.MAX_LAUNCHER_LINK; ++i) {
                int rowHeight = row * 21;
                ISiloConnectionData data = this.controller.launcherData.get(i);
                String siloPrefix = data.getSilo() instanceof TileStandardLauncher ? this.launcherLabel : this.siloLabel;
                GuiButton2 button = new GuiButton2(10 + i, this.field_147003_i + this.buttonRowX, this.field_147009_r + this.buttonRowY + rowHeight, 80, 20, siloPrefix + "[" + i + "]");
                if (data != null) {
                    if (data.getSiloName() != null && !data.getSiloName().isEmpty()) {
                        String siloName = data.getSiloName();
                        if (siloName.length() > 8) {
                            siloName = siloName.substring(0, 8);
                        }
                        button.field_146126_j = siloPrefix + "[" + siloName + "]";
                    }
                    this.connectionStatuses.add(data.getSiloStatus());
                } else {
                    this.connectionStatuses.add(ConnectionStatus.NO_CONNECTION);
                }
                if (this.connectionStatuses.get(this.connectionStatuses.size() - 1) == ConnectionStatus.NO_CONNECTION) {
                    // empty if block
                }
                this.field_146292_n.add(new GuiButton2(10 + i + TileLocalController.MAX_LAUNCHER_LINK, this.field_147003_i + this.buttonRowX + 81, this.field_147009_r + this.buttonRowY + rowHeight, 30, 20, LanguageUtility.getLocalName((String)"gui.icbm:controller.fire")));
                this.field_146292_n.add(button);
                this.field_146292_n.add(new GuiButton2(10 + i + TileLocalController.MAX_LAUNCHER_LINK * 2, this.field_147003_i + this.buttonRowX + 81 + 36, this.field_147009_r + this.buttonRowY + rowHeight, 20, 20, "[x]"));
                ++row;
            }
            for (i = 0; i < this.connectionStatuses.size(); ++i) {
                this.tooltips.put(new Rectangle((double)(this.buttonRowX - 26), (double)(this.buttonRowY + i * 21), 28.0, (double)(28 + i * 21)), this.connectionStatuses.get(i).toString());
            }
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        block5: for (int i = 0; i < this.connectionStatuses.size(); ++i) {
            switch (this.connectionStatuses.get(i)) {
                case ONLINE: {
                    EnumGuiIconSheet.STATUS_ON.draw((Gui)this, this.buttonRowX - 24 + this.field_147003_i, this.buttonRowY + i * 21 + this.field_147009_r);
                    continue block5;
                }
                case OFFLINE: {
                    EnumGuiIconSheet.STATUS_OFF.draw((Gui)this, this.buttonRowX - 24 + this.field_147003_i, this.buttonRowY + i * 21 + this.field_147009_r);
                    continue block5;
                }
                case NO_CONNECTION: {
                    EnumGuiIconSheet.STATUS_CONNECTION_LOST.draw((Gui)this, this.buttonRowX - 24 + this.field_147003_i, this.buttonRowY + i * 21 + this.field_147009_r);
                }
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.ticks++ >= updateGuiTicks) {
            this.reloadData();
        }
        String name = LanguageUtility.getLocalName((String)this.controller.getInventory().func_145825_b());
        this.drawStringCentered(name, 85, 10);
        if (this.controller.launcherData == null || this.controller.launcherData.size() == 0) {
            this.drawStringCentered(LanguageUtility.getLocal((String)"gui.icbm:controller.links.none"), 85, 40);
            this.drawStringCentered(LanguageUtility.getLocal((String)"gui.icbm:controller.links.none.hint"), 85, 50);
        }
    }

    public void reloadData() {
        this.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (Minecraft.func_71386_F() - this.lastClickTime < 50L) {
            return;
        }
        if (button.field_146127_k != 0 && button.field_146127_k >= 10 && button.field_146127_k < 10 + TileLocalController.MAX_LAUNCHER_LINK * 3) {
            int id = button.field_146127_k - 10;
            if (id < TileLocalController.MAX_LAUNCHER_LINK) {
                this.controller.openSiloGui(id, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            } else if (id < TileLocalController.MAX_LAUNCHER_LINK * 2) {
                this.controller.fireLauncher(id - TileLocalController.MAX_LAUNCHER_LINK, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            } else {
                this.controller.unlink(id - TileLocalController.MAX_LAUNCHER_LINK * 2, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }
        this.lastClickTime = Minecraft.func_71386_F();
    }
}

