/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.local;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.api.controller.ISiloConnectionPoint;
import com.builtbroken.icbm.api.launcher.ILauncher;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.controller.SiloConnectionData;
import com.builtbroken.icbm.content.launcher.controller.local.GuiLocalController;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.ILinkFeedback;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.api.tile.IPlayerUsing;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.access.IRotation;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.block.imp.IActivationListener;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.inventory.ExternalInventory;
import com.builtbroken.mc.prefab.tile.logic.TileMachineNode;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLocalController
extends TileMachineNode
implements ILinkable,
IPacketIDReceiver,
IGuiTile,
IActivationListener,
IRotation,
IPlayerUsing,
ISiloConnectionPoint {
    public static double MAX_LINK_DISTANCE = 100.0;
    public static int MAX_LAUNCHER_LINK = 6;
    public static final int GUI_PACKET_ID = 0;
    public static final int FIRE_SILO_PACKET_ID = 2;
    public static final int OPEN_SILO_PACKET_ID = 3;
    public static final int UNLINK_PACKET_ID = 4;
    public static final int MAIN_GUI_ID = 1;
    protected final List<Pos> launcherLocations = new ArrayList<Pos>();
    protected final List<ISiloConnectionData> launcherData = new ArrayList<ISiloConnectionData>();
    protected final List<EntityPlayer> usersWithGuiOpen = new ArrayList<EntityPlayer>();
    private ForgeDirection rotationCache;

    public TileLocalController() {
        super("controller.local", "icbm");
    }

    protected IInventory createInventory() {
        return new ExternalInventory((IInventoryProvider)this, 2).setInventoryName("tile.icbm:smallSiloController.container.name");
    }

    public void update(long ticks) {
        super.update(ticks);
        if (this.isServer() && ticks % 3L == 0L && this.getPlayersUsing().size() > 0) {
            this.doUpdateGuiUsers();
        }
    }

    public void doCleanupCheck() {
        super.doCleanupCheck();
        Iterator<EntityPlayer> it = this.usersWithGuiOpen.iterator();
        while (it.hasNext()) {
            EntityPlayer player = it.next();
            if (player.field_71070_bA instanceof ContainerDummy && ((ContainerDummy)player.field_71070_bA).tile == this) continue;
            it.remove();
        }
    }

    protected void fireLauncher(int index, EntityPlayer player) {
        if (this.isServer()) {
            ILauncher launcher;
            ISiloConnectionData data;
            if (index >= 0 && index < this.launcherData.size() && (data = this.launcherData.get(index)) != null && (launcher = data.getSilo()) != null) {
                if (!launcher.fireMissile()) {
                    ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " attempted to fire a missile from " + data);
                } else {
                    ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " fired a missile from " + data);
                }
            }
        } else {
            this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{2, index}));
        }
    }

    protected void fireAllLaunchers(EntityPlayer player) {
        if (this.isServer()) {
            for (int i = 0; i < this.launcherData.size(); ++i) {
                this.fireLauncher(i, player);
            }
        } else {
            this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{2, -1}));
        }
    }

    public void openSiloGui(int index, EntityPlayer player) {
        if (this.isServer()) {
            ISiloConnectionData data;
            if (index >= 0 && index < this.launcherData.size() && (data = this.launcherData.get(index)) != null) {
                if (data.hasSettingsGui()) {
                    data.openGui(player, this, this);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal((String)"info.voltzengine:tile.error.gui.none")));
                }
            }
        } else {
            this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{3, index}));
        }
    }

    public void unlink(int index, EntityPlayer player) {
        if (this.isServer()) {
            if (index >= 0 && index < this.launcherData.size()) {
                Pos pos;
                ISiloConnectionData data = this.launcherData.get(index);
                if (data != null && (pos = this.launcherLocations.get(index)).xi() == data.xi() && pos.yi() == data.yi() && pos.zi() == data.zi()) {
                    this.launcherLocations.remove(index);
                }
                this.launcherData.remove(index);
            }
        } else {
            this.sendPacketToServer(this.getHost().getPacketForData(new Object[]{4, index}));
        }
    }

    public String link(Location loc, short code) {
        if (loc.world != this.world().unwrap()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        ITileNode tile = pos.getTileNode((IBlockAccess)this.world().unwrap());
        if (!(tile instanceof TileAbstractLauncher)) {
            return "link.error.tile.invalid";
        }
        if (((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (!this.launcherLocations.contains(pos)) {
            if (this.launcherLocations.size() < MAX_LAUNCHER_LINK) {
                this.launcherLocations.add(pos);
                ((ILinkFeedback)tile).onLinked(this.toLocation());
                return "";
            }
            return "link.error.tile.limit.max";
        }
        return "link.error.tile.already.added";
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isClient()) {
                if (id == 0) {
                    NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
                    this.launcherData.clear();
                    if (tag.func_74764_b("siloData")) {
                        NBTTagList list = tag.func_150295_c("siloData", 10);
                        for (int i = 0; i < list.func_74745_c(); ++i) {
                            SiloConnectionData data = new SiloConnectionData(list.func_150305_b(i));
                            this.launcherData.add(data);
                        }
                    }
                    if (Minecraft.func_71410_x().field_71462_r instanceof GuiLocalController) {
                        ((GuiLocalController)Minecraft.func_71410_x().field_71462_r).reloadData();
                    }
                    return true;
                }
            } else {
                if (id == 2) {
                    int index = buf.readInt();
                    if (index == -1) {
                        this.fireAllLaunchers(player);
                    } else {
                        this.fireLauncher(index, player);
                    }
                    return true;
                }
                if (id == 3) {
                    int index = buf.readInt();
                    this.openSiloGui(index, player);
                } else if (id == 4) {
                    int index = buf.readInt();
                    this.unlink(index, player);
                }
            }
            return false;
        }
        return true;
    }

    public void doUpdateGuiUsers() {
        if (this.isServer()) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            if (this.getSiloConnectionData().size() > 0) {
                for (ISiloConnectionData data : this.getSiloConnectionData()) {
                    list.func_74742_a((NBTBase)data.save(new NBTTagCompound()));
                }
            }
            nbt.func_74782_a("siloData", (NBTBase)list);
            this.sendPacketToGuiUsers(this.getHost().getPacketForData(new Object[]{0, nbt}));
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        if (ID == 1) {
            return new ContainerDummy(player, (Object)this);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        if (ID == 1) {
            return new GuiLocalController(this, player);
        }
        return null;
    }

    public boolean openGui(EntityPlayer player, Object currentGui, Object ... data) {
        player.openGui((Object)ICBM.INSTANCE, 1, (World)this.world().unwrap(), this.xi(), this.yi(), this.zi());
        return true;
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("locations")) {
            this.launcherLocations.clear();
            NBTTagList list = nbt.func_150295_c("locations", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.launcherLocations.add(new Pos((double)tag.func_74762_e("x"), (double)tag.func_74762_e("y"), (double)tag.func_74762_e("z")));
            }
        }
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.launcherLocations != null && this.launcherLocations.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Pos pos : this.launcherLocations) {
                list.func_74742_a((NBTBase)pos.toIntNBT());
            }
            nbt.func_74782_a("locations", (NBTBase)list);
        }
        return nbt;
    }

    public boolean onPlayerActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
            return false;
        }
        if (this.isServer()) {
            player.openGui((Object)ICBM.INSTANCE, 1, (World)this.world().unwrap(), this.xi(), this.yi(), this.zi());
        }
        return true;
    }

    public ForgeDirection getDirection() {
        if (this.rotationCache == null) {
            this.rotationCache = ForgeDirection.getOrientation((int)this.getHost().getHostMeta()).getOpposite();
        }
        return this.rotationCache;
    }

    public List<EntityPlayer> getPlayersUsing() {
        return this.usersWithGuiOpen;
    }

    @Override
    public List<ISiloConnectionData> getSiloConnectionData() {
        if (this.isServer() && (this.launcherData.isEmpty() || this.launcherData.size() != this.launcherLocations.size())) {
            this.launcherData.clear();
            for (Pos pos : this.launcherLocations) {
                TileEntity tile = pos.getTileEntity((IBlockAccess)this.world().unwrap());
                if (tile instanceof ILauncher) {
                    this.launcherData.add(new SiloConnectionData((ILauncher)tile));
                    continue;
                }
                if (!(tile instanceof ITileNodeHost) || !(((ITileNodeHost)tile).getTileNode() instanceof ILauncher)) continue;
                this.launcherData.add(new SiloConnectionData((ILauncher)((ITileNodeHost)tile).getTileNode()));
            }
        }
        return this.launcherData;
    }

    @Override
    public String getConnectorGroupName() {
        return "na";
    }
}

