/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.remote.antenna;

import com.builtbroken.icbm.content.launcher.controller.remote.antenna.AntennaNetwork;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TileAntennaPart;
import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.api.map.radio.IRadioWaveExternalReceiver;
import com.builtbroken.mc.api.map.radio.IRadioWaveReceiver;
import com.builtbroken.mc.api.map.radio.IRadioWaveSender;
import com.builtbroken.mc.api.map.radio.RadioTowerStatus;
import com.builtbroken.mc.api.map.radio.wireless.ConnectionRemovedReason;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessConnector;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetwork;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetworkHub;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetworkObject;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.lib.world.map.radio.RadioRegistry;
import com.builtbroken.mc.lib.world.map.radio.network.WirelessNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAntenna
extends TileAntennaPart
implements IGuiTile,
IWirelessNetworkHub,
IWirelessConnector,
IRadioWaveSender,
IRadioWaveReceiver {
    protected RadioTowerStatus towerStatus = RadioTowerStatus.OFFLINE;
    protected WirelessNetwork wirelessNetwork;
    protected List<IWirelessNetwork> connectedNetworks = new ArrayList<IWirelessNetwork>();
    protected float hz = 0.0f;
    protected boolean generateNetwork = false;
    private int randomTick = 30;
    protected String displayName;
    protected String networkName;
    protected String passKey;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.oldWorld().field_72995_K) {
            if (this.ticks % 20 == 0) {
                if (this.towerStatus == RadioTowerStatus.ONLINE) {
                    RadioRegistry.add((IRadioWaveReceiver)this);
                } else {
                    RadioRegistry.remove((IRadioWaveReceiver)this);
                }
            }
            if (this.isGeneratingNetwork() && this.towerStatus == RadioTowerStatus.ONLINE) {
                this.buildWirelessNetwork();
            } else if (this.wirelessNetwork != null) {
                this.setWirelessNetwork(null);
            }
            if (this.ticks % 100 == 0 && this.wirelessNetwork != null) {
                this.wirelessNetwork.updateConnections();
            }
            if (this.ticks >= this.randomTick) {
                int addition = MathHelper.rand.nextInt(200) + 1000;
                this.randomTick = addition + this.ticks < 0 ? addition - (Integer.MAX_VALUE - this.ticks) : this.ticks + addition;
                this.doInitScan();
            }
        }
    }

    protected void buildWirelessNetwork() {
        if (this.wirelessNetwork == null) {
            this.setWirelessNetwork(new WirelessNetwork((IWirelessNetworkHub)this));
        }
    }

    @Override
    protected void updateConnections() {
        HashMap oldConnections = this.connections;
        this.connections = new HashMap();
        super.updateConnections();
        for (TileEntity tile : oldConnections.values()) {
            if (!(tile instanceof IWirelessNetworkObject) || this.connections.values().contains(tile)) continue;
            for (IWirelessNetwork network : this.getAttachedNetworks()) {
                network.removeConnection((IWirelessConnector)this, (IWirelessNetworkObject)tile);
            }
            if (this.wirelessNetwork == null) continue;
            this.wirelessNetwork.removeConnection((IWirelessConnector)this, (IWirelessNetworkObject)tile);
        }
        for (TileEntity tile : this.connections.values()) {
            if (!(tile instanceof IWirelessNetworkObject) || oldConnections.values().contains(tile)) continue;
            for (IWirelessNetwork network : this.getAttachedNetworks()) {
                network.addConnection((IWirelessConnector)this, (IWirelessNetworkObject)tile);
            }
            if (this.wirelessNetwork == null) continue;
            this.wirelessNetwork.addConnection((IWirelessConnector)this, (IWirelessNetworkObject)tile);
        }
    }

    @Override
    protected boolean canConnect(ForgeDirection side, TileEntity tile) {
        return tile != null;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.antennaNetwork != null) {
            this.antennaNetwork.kill();
        }
        if (this.wirelessNetwork != null) {
            this.wirelessNetwork.kill();
        }
        if (this.getAttachedNetworks() != null && this.getAttachedNetworks().size() > 0) {
            for (IWirelessNetwork network : this.getAttachedNetworks()) {
                network.removeConnector((IWirelessConnector)this);
            }
        }
        RadioRegistry.remove((IRadioWaveReceiver)this);
    }

    public void doInitScan() {
        if (this.antennaNetwork == null) {
            this.antennaNetwork = new AntennaNetwork(this);
            this.antennaNetwork.add(this);
        }
        if (this.connections.isEmpty()) {
            this.updateConnections();
        }
        long time = System.nanoTime();
        ArrayList<TileAntennaPart> pathedTiles = new ArrayList<TileAntennaPart>();
        LinkedList<TileAntennaPart> stack = new LinkedList<TileAntennaPart>();
        stack.offer(this);
        while (!stack.isEmpty()) {
            TileAntennaPart currentNode = (TileAntennaPart)((Object)stack.poll());
            pathedTiles.add(currentNode);
            if (currentNode != this) {
                this.antennaNetwork.add(currentNode);
            }
            if (currentNode.connections.size() == 0) {
                currentNode.updateConnections();
            }
            if (currentNode.connections.size() <= 1) continue;
            for (TileEntity tile : currentNode.connections.values()) {
                if (!(tile instanceof TileAntennaPart) || pathedTiles.contains(tile)) continue;
                stack.offer((TileAntennaPart)tile);
            }
        }
        time = System.nanoTime() - time;
        this.antennaNetwork.updateBounds();
        RadioRegistry.addOrUpdate((IRadioWaveReceiver)this);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    @Override
    public void updateRenderState() {
    }

    public void receiveRadioWave(float hz, IRadioWaveSender sender, String messageHeader, Object[] data) {
        if (sender != this) {
            for (TileEntity tile : this.connections.values()) {
                if (!(tile instanceof IRadioWaveExternalReceiver)) continue;
                ((IRadioWaveExternalReceiver)tile).receiveExternalRadioWave(hz, sender, (IRadioWaveReceiver)this, messageHeader, data);
            }
            sender.onMessageReceived((IRadioWaveReceiver)this, hz, messageHeader, data);
        }
    }

    public Cube getWirelessCoverageArea() {
        return this.antennaNetwork != null ? this.antennaNetwork.senderRange : null;
    }

    public Cube getRadioReceiverRange() {
        return this.antennaNetwork != null ? this.antennaNetwork.receiveRange : null;
    }

    public Cube getRadioSenderRange() {
        return this.antennaNetwork != null ? this.antennaNetwork.senderRange : null;
    }

    public IWirelessNetwork getWirelessNetwork() {
        return this.wirelessNetwork;
    }

    public void setWirelessNetwork(WirelessNetwork wirelessNetwork) {
        if (wirelessNetwork == null && this.wirelessNetwork != null) {
            this.wirelessNetwork.kill();
        } else if (wirelessNetwork != null && this.wirelessNetwork != null && wirelessNetwork != this.wirelessNetwork) {
            this.wirelessNetwork.kill();
        }
        this.wirelessNetwork = wirelessNetwork;
        if (this.wirelessNetwork != null) {
            if (this.connections.size() == 0) {
                this.updateConnections();
            }
            this.wirelessNetwork.addConnector((IWirelessConnector)this);
        }
    }

    public float getBroadCastFrequency() {
        return this.hz;
    }

    public void sendRadioMessage(float hz, String header, Object ... data) {
        if (this.antennaNetwork == null) {
            this.doInitScan();
        }
        RadioRegistry.popMessage((World)this.oldWorld(), (IRadioWaveSender)this, (float)hz, (String)header, (Object[])data);
    }

    public List<IWirelessNetworkObject> getWirelessNetworkObjects() {
        if (this.towerStatus == RadioTowerStatus.ONLINE && this.connections.size() > 0) {
            ArrayList<IWirelessNetworkObject> objects = new ArrayList<IWirelessNetworkObject>();
            for (Map.Entry entry : this.connections.entrySet()) {
                TileEntity tile = (TileEntity)entry.getValue();
                if (!(tile instanceof IWirelessNetworkObject) || tile.func_145837_r() || !((IWirelessNetworkObject)tile).canAcceptAntennaConnection((ForgeDirection)entry.getKey())) continue;
                objects.add((IWirelessNetworkObject)tile);
            }
            return objects;
        }
        return new ArrayList<IWirelessNetworkObject>();
    }

    public boolean addWirelessNetwork(IWirelessNetwork network) {
        if (this.towerStatus == RadioTowerStatus.ONLINE && !this.connectedNetworks.contains(network)) {
            return this.connectedNetworks.add(network);
        }
        return false;
    }

    public boolean removeWirelessNetwork(IWirelessNetwork network, ConnectionRemovedReason reason) {
        if (this.connectedNetworks.contains(network)) {
            return this.connectedNetworks.remove(network);
        }
        return false;
    }

    public boolean canConnectToNetwork(IWirelessNetwork network) {
        if (network != null && network.getPrimarySender() != null && (double)Math.abs(network.getHz() - this.hz) <= 0.001) {
            Cube senderRangeSender;
            Cube receiverRangeSender = network.getPrimarySender() instanceof IRadioWaveReceiver ? ((IRadioWaveReceiver)network.getPrimarySender()).getRadioReceiverRange() : network.getPrimarySender().getWirelessCoverageArea();
            Cube cube = senderRangeSender = network.getPrimarySender() instanceof IRadioWaveSender ? ((IRadioWaveSender)network.getPrimarySender()).getRadioSenderRange() : network.getPrimarySender().getWirelessCoverageArea();
            if (receiverRangeSender != null && senderRangeSender != null && this.getRadioSenderRange().doesOverlap(receiverRangeSender) && senderRangeSender.doesOverlap(this.getRadioReceiverRange())) {
                return true;
            }
        }
        return false;
    }

    public List<IWirelessNetwork> getAttachedNetworks() {
        return this.connectedNetworks;
    }

    public boolean canAcceptAntennaConnection(ForgeDirection side) {
        return false;
    }

    public void setTowerStatus(RadioTowerStatus towerStatus) {
        this.towerStatus = towerStatus;
        if (!this.oldWorld().field_72995_K) {
            if (towerStatus != RadioTowerStatus.ONLINE && this.wirelessNetwork != null) {
                this.setWirelessNetwork(null);
            } else if (towerStatus == RadioTowerStatus.ONLINE && this.generateNetwork && this.wirelessNetwork == null) {
                this.buildWirelessNetwork();
            }
        }
    }

    public boolean isGeneratingNetwork() {
        return this.generateNetwork;
    }

    public void setGenerateNetwork(boolean generateNetwork) {
        this.generateNetwork = generateNetwork;
        if (!this.oldWorld().field_72995_K) {
            if (!generateNetwork && this.wirelessNetwork != null) {
                this.setWirelessNetwork(null);
            } else if (generateNetwork && this.towerStatus == RadioTowerStatus.ONLINE && this.wirelessNetwork == null) {
                this.buildWirelessNetwork();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int v;
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("hz")) {
            this.hz = nbt.func_74760_g("hz");
        }
        if (nbt.func_74764_b("towerStatus") && (v = nbt.func_74762_e("towerStatus")) >= 0 && v < RadioTowerStatus.values().length) {
            this.towerStatus = RadioTowerStatus.values()[v];
        }
        this.generateNetwork = nbt.func_74767_n("genNet");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("hz", this.hz);
        nbt.func_74768_a("towerStatus", this.towerStatus.ordinal());
        nbt.func_74757_a("genNet", this.generateNetwork);
    }

    public String toString() {
        return "TileAntenna[" + this.oldWorld().field_73011_w.field_76574_g + "d, " + this.field_145851_c + "x, " + this.field_145848_d + "y, " + this.field_145849_e + "z]@" + ((Object)((Object)this)).hashCode();
    }
}

