/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.remote.central;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.api.controller.ISiloConnectionPoint;
import com.builtbroken.icbm.content.launcher.controller.local.TileLocalController;
import com.builtbroken.icbm.content.launcher.controller.remote.central.ContainerCommandController;
import com.builtbroken.icbm.content.launcher.controller.remote.central.GuiCommandController;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.TileCommandSiloConnector;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.map.radio.IRadioWaveExternalReceiver;
import com.builtbroken.mc.api.map.radio.IRadioWaveReceiver;
import com.builtbroken.mc.api.map.radio.IRadioWaveSender;
import com.builtbroken.mc.api.map.radio.wireless.ConnectionRemovedReason;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessDataListener;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessDataPoint;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetwork;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetworkObject;
import com.builtbroken.mc.api.tile.ILinkFeedback;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.hz.FakeRadioSender;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCommandController
extends TileModuleMachine
implements ILinkable,
IPacketIDReceiver,
IGuiTile,
IRecipeContainer,
IWirelessDataPoint,
IWirelessDataListener,
ILinkFeedback,
IRadioWaveExternalReceiver {
    public static IIcon texture;
    public static IIcon top_texture;
    public final HashMap<Pos, TileCommandSiloConnector> siloConnectors = new HashMap();
    protected List<IWirelessNetwork> connectedNetworks = new ArrayList<IWirelessNetwork>();
    protected short siloDataPassKey = 0;
    protected String displayName;

    public TileCommandController() {
        super("commandController", Material.field_151573_f);
        this.hardness = 10.0f;
        this.resistance = 10.0f;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 2);
    }

    public Tile newTile() {
        return new TileCommandController();
    }

    public IIcon getIcon(int side) {
        if (side == 1) {
            return top_texture;
        }
        return texture;
    }

    public void registerIcons(IIconRegister iconRegister) {
        texture = iconRegister.func_94245_a("icbm:commandController");
        top_texture = iconRegister.func_94245_a("icbm:commandController_top");
    }

    public void update() {
        super.update();
        if (this.isServer() && this.ticks % 60L == 0L) {
            ArrayList<Pos> remove = new ArrayList<Pos>();
            for (Pos pos : this.siloConnectors.keySet()) {
                TileCommandSiloConnector controller = this.siloConnectors.get(pos);
                if (controller == null) {
                    if (!this.field_145850_b.func_72899_e(pos.xi(), pos.yi(), pos.zi())) continue;
                    TileEntity tile = pos.getTileEntity((IBlockAccess)this.oldWorld());
                    if (tile instanceof TileCommandSiloConnector) {
                        this.siloConnectors.put(pos, (TileCommandSiloConnector)tile);
                        continue;
                    }
                    remove.add(pos);
                    continue;
                }
                if (!controller.func_145837_r()) continue;
                this.siloConnectors.put(pos, null);
            }
            remove.forEach(this.siloConnectors::remove);
        }
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
                return false;
            }
            if (Engine.runningAsDev) {
                if (player.func_70694_bm().func_77973_b() == Items.field_151055_y) {
                    if (this.isServer()) {
                        if (this.getAttachedNetworks().size() > 0) {
                            int i = 0;
                            for (IWirelessNetwork network : this.getAttachedNetworks()) {
                                player.func_146105_b((IChatComponent)new ChatComponentText("Network[" + i++ + "] = " + network));
                            }
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("No networks attached"));
                        }
                    }
                    return true;
                }
                if (player.func_70694_bm().func_77973_b() == Items.field_151072_bj) {
                    if (this.isServer()) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("SiloConnector: " + this.siloConnectors));
                    }
                    return true;
                }
            }
        }
        if (this.isServer()) {
            this.openGui(player, (Object)ICBM.INSTANCE);
        }
        return true;
    }

    public String link(Location loc, short code) {
        if (loc.world != this.oldWorld()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > TileLocalController.MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)loc.oldWorld());
        if (!(tile instanceof TileCommandSiloConnector)) {
            return "link.error.tile.invalid";
        }
        if (tile instanceof IPassCode && ((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (!this.siloConnectors.containsKey(pos)) {
            this.siloConnectors.put(loc.toPos(), (TileCommandSiloConnector)tile);
            if (tile instanceof ILinkFeedback) {
                ((ILinkFeedback)tile).onLinked(this.toLocation());
            }
            return "";
        }
        return "link.error.tile.already.added";
    }

    public void onLinked(Location location) {
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerCommandController(player, (IInventory)this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiCommandController(player, this);
    }

    public void onConnectionAdded(IWirelessNetworkObject object) {
    }

    public void onConnectionRemoved(IWirelessNetworkObject object, ConnectionRemovedReason reason) {
    }

    public boolean hasAccessForData(String dataName, short passKey) {
        return "silos".equals(dataName) && passKey == this.siloDataPassKey;
    }

    public boolean addWirelessNetwork(IWirelessNetwork network) {
        if (!this.connectedNetworks.contains(network)) {
            return this.connectedNetworks.add(network);
        }
        return false;
    }

    public boolean removeWirelessNetwork(IWirelessNetwork network, ConnectionRemovedReason reason) {
        if (this.connectedNetworks.contains(network)) {
            return this.connectedNetworks.remove(network);
        }
        return false;
    }

    public boolean canConnectToNetwork(IWirelessNetwork network) {
        return true;
    }

    public List<IWirelessNetwork> getAttachedNetworks() {
        return this.connectedNetworks;
    }

    public boolean canAcceptAntennaConnection(ForgeDirection side) {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("siloPosData")) {
            this.siloConnectors.clear();
            NBTTagList list = nbt.func_150295_c("siloPosData", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.siloConnectors.put(new Pos(list.func_150305_b(i)), null);
            }
        }
        if (nbt.func_74764_b("displayName")) {
            this.displayName = nbt.func_74779_i("displayName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (!this.siloConnectors.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Pos pos : this.siloConnectors.keySet()) {
                list.func_74742_a((NBTBase)pos.toNBT());
            }
            nbt.func_74782_a("siloPosData", (NBTBase)list);
        }
        if (this.displayName != null && !this.displayName.isEmpty()) {
            nbt.func_74778_a("displayName", this.displayName);
        }
    }

    public void receiveExternalRadioWave(float hz, IRadioWaveSender sender, IRadioWaveReceiver receiver, String messageHeader, Object[] data) {
        try {
            if (this.isServer()) {
                for (IWirelessNetwork network : this.getAttachedNetworks()) {
                    short pass;
                    if (!((double)Math.abs(hz - network.getHz()) <= 0.001)) continue;
                    sender.onMessageReceived(receiver, hz, messageHeader, data);
                    if ("fireMissile1".equals(messageHeader) || "fireMissileAtTarget".equals(messageHeader)) {
                        pass = (Short)data[0];
                        String group = (String)data[1];
                        String siloName = (String)data[2];
                        if (group != null && siloName != null) {
                            boolean fired = false;
                            boolean foundGroup = false;
                            boolean siloFound = false;
                            block8: for (ISiloConnectionPoint iSiloConnectionPoint : this.siloConnectors.values()) {
                                if (!group.equals(iSiloConnectionPoint.getConnectorGroupName())) continue;
                                foundGroup = true;
                                for (ISiloConnectionData launcher : iSiloConnectionPoint.getSiloConnectionData()) {
                                    if (launcher.getSiloName() == null || !siloName.equals(launcher.getSiloName())) continue;
                                    siloFound = true;
                                    switch (launcher.getSiloStatus()) {
                                        case OFFLINE: {
                                            if (!(sender instanceof FakeRadioSender)) break;
                                            ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "] is offline and can not receive the launch data!"));
                                            break;
                                        }
                                        case ONLINE: {
                                            if (launcher instanceof IPassCode && ((IPassCode)launcher).getCode() != pass) {
                                                if (!(sender instanceof FakeRadioSender)) break;
                                                ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "] auth code is not valid!"));
                                                break;
                                            }
                                            if (launcher.getSilo() != null) {
                                                int travelTime = launcher.getSilo().getTravelTimeTo(launcher.getSilo().getTarget());
                                                if ("fireMissileAtTarget".equals(messageHeader) && launcher.getSilo().fireMissile((IPos3D)data[3]) || "fireMissile1".equals(messageHeader) && launcher.getSilo().fireMissile()) {
                                                    fired = true;
                                                    if (!(sender instanceof FakeRadioSender)) break block8;
                                                    ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "]: Missile fire at target " + launcher.getSilo().getTarget()));
                                                    if (travelTime <= 0) break block8;
                                                    ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "]: Eta " + travelTime + " seconds"));
                                                    break;
                                                }
                                                if (!(sender instanceof FakeRadioSender)) break block8;
                                                ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "]: Missile failed to fire! Check target data!"));
                                                break;
                                            }
                                            if (!(sender instanceof FakeRadioSender)) break;
                                            ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "] error passing data to silo! Code: Iv33"));
                                            break;
                                        }
                                        case NO_CONNECTION: {
                                            if (!(sender instanceof FakeRadioSender)) break;
                                            ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Silo[" + siloName + "] can not be contacted, it may be out of radio range!"));
                                        }
                                    }
                                    break block8;
                                }
                            }
                            if (!(sender instanceof FakeRadioSender)) continue;
                            if (fired) {
                                ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Missing fired, stand clear of target!"));
                                continue;
                            }
                            if (!foundGroup) {
                                ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Unknown Group: " + group));
                                continue;
                            }
                            if (siloFound) continue;
                            ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Unknown SiloName: " + siloName));
                            continue;
                        }
                        if (sender instanceof FakeRadioSender) {
                            ((FakeRadioSender)sender).player.func_146105_b((IChatComponent)new ChatComponentText("Error: silo name or group name is invalid! Check encoded data!"));
                        }
                        ICBM.INSTANCE.logger().error((Object)((Object)this) + "  Received bad message from " + sender + ".\n Header = " + messageHeader + "\n Data = " + data + "\n Error: Group name or silo name is null");
                        continue;
                    }
                    if ("fireMissile2".equals(messageHeader)) {
                        pass = (Short)data[0];
                        String string = (String)data[1];
                        continue;
                    }
                    ICBM.INSTANCE.logger().error((Object)((Object)this) + "  Received bad message from " + sender + ".\n Header = " + messageHeader + "\n Data = " + data + "\n Error: Group name or silo name is null");
                }
            }
        }
        catch (Exception e) {
            ICBM.INSTANCE.logger().error((Object)((Object)this) + "  Failed to receive message from " + sender + ".\n Header = " + messageHeader + "\n Data = " + data, (Throwable)e);
        }
    }

    public void onRangeChange(IRadioWaveReceiver receiver, Cube range) {
    }

    public String getControllerDisplayName() {
        return this.displayName;
    }

    public void setConnectorDisplayName(String name) {
        this.displayName = name;
        if (this.isClient()) {
            this.sendPacketToServer((IPacket)new PacketTile((TileEntity)this, new Object[]{2, name != null ? name : ""}));
        }
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.displayName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.getControllerDisplayName() == null ? "" : this.getControllerDisplayName()));
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isServer() && id == 2) {
                this.setConnectorDisplayName(ByteBufUtils.readUTF8String((ByteBuf)buf));
                return true;
            }
            return false;
        }
        return true;
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add(this.newShapedRecipe(ICBM_API.blockCommandCentral, new Object[]{"WWW", "GPR", "CVC", Character.valueOf('W'), "wireGold", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('P'), "plateIron", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('V'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('R'), "gemDiamond"}));
    }
}

