/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.remote.display;

import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.launcher.controller.SiloConnectionData;
import com.builtbroken.icbm.content.launcher.controller.remote.display.GuiSiloInterface;
import com.builtbroken.icbm.content.launcher.controller.remote.display.TileSiloInterface;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TileSiloInterfaceClient
extends TileSiloInterface
implements ISimpleItemRenderer {
    protected HashMap<Pos, List<ISiloConnectionData>> clientSiloDataCache;
    protected String[] controllers;
    protected Pos[][] controllerData;

    @Override
    public Tile newTile() {
        return new TileSiloInterfaceClient();
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiSiloInterface(player, this);
    }

    public void requestSiloData() {
        if (this.isClient()) {
            this.sendPacketToServer((IPacket)new PacketTile((TileEntity)this, new Object[]{1}));
        }
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (id == 2) {
                if (this.clientSiloDataCache == null) {
                    this.clientSiloDataCache = new HashMap();
                }
                this.controllerData = null;
                this.controllers = null;
                this.clientSiloDataCache.clear();
                this.readConnectorSet(buf);
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof GuiSiloInterface) {
                    screen.func_73866_w_();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void readCommandSiloConnector(int controllerIndexValue, ByteBuf buf) {
        int locationSize = buf.readInt();
        Pos[] posData = new Pos[locationSize];
        for (int i = 0; i < locationSize; ++i) {
            Pos pos = new Pos((double)buf.readInt(), (double)buf.readInt(), (double)buf.readInt());
            int dataSize = buf.readInt();
            ArrayList<SiloConnectionData> list = new ArrayList<SiloConnectionData>();
            if (dataSize > 0) {
                NBTTagCompound save = ByteBufUtils.readTag((ByteBuf)buf);
                if (save != null) {
                    NBTTagList tagList = save.func_150295_c("data", 10);
                    for (int s = 0; s < tagList.func_74745_c(); ++s) {
                        SiloConnectionData data = new SiloConnectionData(tagList.func_150305_b(s));
                        if (data.dim != Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g) continue;
                        data.world = Minecraft.func_71410_x().field_71441_e;
                        list.add(data);
                    }
                }
            } else if (dataSize == 0 || dataSize == -1) {
                // empty if block
            }
            posData[i] = pos;
            this.clientSiloDataCache.put(pos, list);
        }
        this.controllerData[controllerIndexValue] = posData;
    }

    protected void readConnectorSet(ByteBuf buf) {
        int controllers;
        if (buf.readBoolean() && (controllers = buf.readInt()) > 0) {
            this.controllers = new String[controllers];
            this.controllerData = new Pos[controllers][];
            for (int c = 0; c < controllers; ++c) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.controllers[c] = name = name.isEmpty() || name.equals("--") ? "c" + c : name;
                this.readCommandSiloConnector(c, buf);
            }
        }
    }

    @Override
    public void openSiloGui(Pos pos, ISiloConnectionData iSiloConnectionData, EntityPlayer player) {
        if (this.isServer()) {
            super.openSiloGui(pos, iSiloConnectionData, player);
        } else {
            this.sendPacketToServer((IPacket)new PacketTile((TileEntity)this, new Object[]{2, pos, iSiloConnectionData}));
        }
    }

    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)-0.5f, (float)-1.4f, (float)-0.5f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glRotatef((float)150.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glRotatef((float)150.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.1f, (float)-0.5f);
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.FoF_STATION_TEXTURE);
        Assets.FoF_STATION_MODEL.renderOnly(new String[]{"Group_006", "Group_007"});
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new Cube(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).add(this.x(), this.y(), this.z()).toAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(pos.xf() + 0.5f), (float)(pos.yf() - 0.561f), (float)(pos.zf() + 0.5f));
        switch (this.getDirection()) {
            case EAST: {
                break;
            }
            case WEST: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.FoF_STATION_TEXTURE);
        Assets.FoF_STATION_MODEL.renderOnly(new String[]{"Group_006", "Group_007"});
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    public IIcon getIcon() {
        return Blocks.field_150351_n.func_149691_a(0, 0);
    }
}

