/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.launcher;

import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.launcher.launcher.TileStandardLauncher;
import com.builtbroken.icbm.content.missile.client.RenderMissile;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import com.builtbroken.mc.seven.framework.block.listeners.client.ITileRenderListener;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.obj.GroupObject;
import org.lwjgl.opengl.GL11;

public class StandardLauncherRenderListener
extends TileListener
implements IBlockListener,
ITileRenderListener {
    private static boolean processedModel = false;
    private static GroupObject[] frame = new GroupObject[7];
    private static GroupObject warhead;
    private static List<GroupObject> engine;
    private static GroupObject guidance;
    private static GroupObject[][] skinLayers;

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(TileEntity tile, double xx, double yy, double zz, float f) {
        Pos center = new Pos(xx, yy, zz);
        if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof TileStandardLauncher) {
            TileStandardLauncher launcher = (TileStandardLauncher)((ITileNodeHost)tile).getTileNode();
            if (launcher.getMissile() != null) {
                GL11.glPushMatrix();
                Pos pos = (Pos)((Pos)center.add(0.5, 0.0, 0.5)).add(launcher.getDirection());
                if (launcher.missileSize == MissileSize.MEDIUM) {
                    pos = (Pos)pos.add(launcher.getDirection());
                }
                if (launcher.getMissile().getCenterOffset() != null) {
                    pos = (Pos)pos.add(launcher.getMissile().getCenterOffset());
                }
                GL11.glTranslatef((float)pos.xf(), (float)pos.yf(), (float)pos.zf());
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderMissile.renderMissile(launcher.getMissile(), 0.0f, 90.0f, null);
                GL11.glPopMatrix();
            } else if (launcher.recipe != null) {
                int i;
                if (!processedModel) {
                    StandardLauncherRenderListener.processModel();
                }
                GL11.glPushMatrix();
                Pos pos = center;
                float yf = 2.2f;
                switch (launcher.getDirection()) {
                    case NORTH: {
                        pos = (Pos)pos.add(-0.65, (double)2.2f, 0.95);
                        break;
                    }
                    case SOUTH: {
                        pos = (Pos)pos.add(-0.65, (double)2.2f, 2.95);
                        break;
                    }
                    case EAST: {
                        pos = (Pos)pos.add(0.35, (double)2.2f, 1.95);
                        break;
                    }
                    case WEST: {
                        pos = (Pos)pos.add(-1.65, (double)2.2f, 1.95);
                    }
                }
                GL11.glTranslatef((float)pos.xf(), (float)pos.yf(), (float)pos.zf());
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
                for (i = 0; i < launcher.recipe.frameLevel && i < frame.length; ++i) {
                    frame[i].render();
                }
                if (launcher.recipe.frameCompleted) {
                    if (launcher.recipe.warhead != null) {
                        warhead.render();
                    }
                    if (launcher.recipe.rocketComputer != null) {
                        guidance.render();
                    }
                    if (launcher.recipe.rocketEngine != null) {
                        for (GroupObject o : engine) {
                            o.render();
                        }
                    }
                    if (launcher.recipe.platesContained > 0) {
                        for (i = 0; i < launcher.recipe.platesContained; ++i) {
                            int layer = i / 4;
                            int set = i % 4;
                            if (layer >= skinLayers.length) continue;
                            skinLayers[layer][set].render();
                        }
                    }
                }
                GL11.glPopMatrix();
            }
        }
    }

    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("tilerender");
        return list;
    }

    private static void processModel() {
        processedModel = true;
        for (GroupObject object : Assets.STANDARD_MISSILE_MODEL_2.groupObjects) {
            String name;
            if (object.name.contains("frame")) {
                name = object.name.split("_")[0];
                int layer = 0;
                if (name.contains("1")) {
                    layer = 0;
                } else if (name.contains("2")) {
                    layer = 1;
                } else if (name.contains("3")) {
                    layer = 2;
                } else if (name.contains("4")) {
                    layer = 3;
                } else if (name.contains("5")) {
                    layer = 4;
                } else if (name.contains("6")) {
                    layer = 5;
                } else if (name.contains("7")) {
                    layer = 6;
                }
                StandardLauncherRenderListener.frame[layer] = object;
                continue;
            }
            if (object.name.contains("CPcore")) {
                guidance = object;
                continue;
            }
            if (object.name.contains("fual") || object.name.contains("fire")) {
                engine.add(object);
                continue;
            }
            if (object.name.contains("boom")) {
                warhead = object;
                continue;
            }
            if (!object.name.contains("skiln")) continue;
            name = object.name.split("_")[0];
            int set = 0;
            int layer = 0;
            if (name.contains("1")) {
                layer = 0;
            } else if (name.contains("2")) {
                layer = 1;
            } else if (name.contains("3")) {
                layer = 2;
            } else if (name.contains("4")) {
                layer = 3;
            } else if (name.contains("5")) {
                layer = 4;
            } else if (name.contains("6")) {
                layer = 5;
            } else if (name.contains("7")) {
                layer = 6;
            } else if (name.contains("8")) {
                layer = 7;
            } else if (name.contains("9")) {
                layer = 8;
            }
            if (name.contains("RT")) {
                set = 0;
            } else if (name.contains("LB")) {
                set = 1;
            } else if (name.contains("RB")) {
                set = 2;
            } else if (name.contains("LT")) {
                set = 3;
            }
            StandardLauncherRenderListener.skinLayers[layer][set] = object;
        }
    }

    static {
        engine = new ArrayList<GroupObject>();
        skinLayers = new GroupObject[9][4];
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        public ITileEventListener createListener(Block block) {
            return new StandardLauncherRenderListener();
        }

        public String getListenerKey() {
            return "StandardLauncherRenderListener";
        }
    }
}

