/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.launcher;

import com.builtbroken.icbm.api.modules.IGuidance;
import com.builtbroken.icbm.api.modules.IRocketEngine;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.content.missile.data.missile.Missile;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.jlib.data.network.IByteBufReader;
import com.builtbroken.jlib.data.network.IByteBufWriter;
import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.oredict.OreDictionary;

public class StandardMissileCrafting
implements ISave,
IByteBufWriter,
IByteBufReader {
    public static final int MAX_ROD_COUNT = 128;
    public static final int ROD_PER_LEVEL_COUNT = 16;
    public static final int MAX_ROD_LEVEL_COUNT = 8;
    public static final int MAX_PLATE_COUNT = 36;
    public static final int PLATE_PER_LEVEL_COUNT = 4;
    public static final int MAX_PLATE_LEVEL_COUNT = 9;
    protected int rodsContained = 0;
    protected int platesContained = 0;
    protected int frameLevel = 0;
    protected int plateLevel = 0;
    protected boolean frameCompleted = false;
    protected boolean gutsCompleted = false;
    protected boolean skinCompleted = false;
    protected ItemStack rocketEngine;
    protected ItemStack rocketComputer;
    protected ItemStack warhead;
    protected List<ItemStack> itemsUsed = new ArrayList<ItemStack>();

    public boolean canAddItem(ItemStack stack) {
        if (stack != null) {
            if (StandardMissileCrafting.isRod(stack)) {
                return this.rodsContained < 128;
            }
            if (this.frameCompleted) {
                if (StandardMissileCrafting.isPlate(stack)) {
                    return this.platesContained < 36;
                }
                Item item = stack.func_77973_b();
                if (item instanceof IModuleItem) {
                    IModule module = ((IModuleItem)item).getModule(stack);
                    if (module instanceof IRocketEngine) {
                        return this.rocketEngine == null;
                    }
                    if (module instanceof IWarhead) {
                        return this.warhead == null;
                    }
                    if (module instanceof IGuidance) {
                        return this.rocketComputer == null;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isPartOfRecipe(ItemStack stack) {
        if (stack != null) {
            if (StandardMissileCrafting.isRod(stack) || StandardMissileCrafting.isPlate(stack)) {
                return true;
            }
            Item item = stack.func_77973_b();
            if (item instanceof IModuleItem) {
                IModule module = ((IModuleItem)item).getModule(stack);
                return module instanceof IRocketEngine || module instanceof IWarhead || module instanceof IGuidance;
            }
        }
        return false;
    }

    public IChatComponent getCurrentRecipeChat() {
        if (!this.frameCompleted) {
            return new ChatComponentText("Needs " + (128 - this.rodsContained) + " more rods.");
        }
        if (!this.gutsCompleted) {
            if (this.rocketComputer == null) {
                return new ChatComponentText("Needs a guidance computer.");
            }
            if (this.rocketEngine == null) {
                return new ChatComponentText("Needs a rocket engine.");
            }
        } else if (!this.skinCompleted) {
            return new ChatComponentText("Needs " + (36 - this.platesContained) + " more metal sheets.");
        }
        return new ChatComponentText("Done click with wrench to finish");
    }

    private static boolean isRod(ItemStack stack) {
        return StandardMissileCrafting.hasOreName("rodIron", stack);
    }

    private static boolean isPlate(ItemStack stack) {
        return StandardMissileCrafting.hasOreName("plateIron", stack);
    }

    private static boolean hasOreName(String name, ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (oreName == null || oreName.isEmpty() || !oreName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean addItem(ItemStack stack) {
        if (stack != null) {
            if (StandardMissileCrafting.isRod(stack) && !this.frameCompleted) {
                int added = this.addRods(stack.field_77994_a);
                stack.field_77994_a -= added;
                return added > 0;
            }
            if (StandardMissileCrafting.isPlate(stack) && !this.skinCompleted) {
                int added = this.addPlates(stack.field_77994_a);
                ItemStack stackAdd = stack.func_77946_l();
                this.storeItem(stackAdd, added);
                stack.field_77994_a -= added;
                return added > 0;
            }
            Item item = stack.func_77973_b();
            boolean added = false;
            if (item instanceof IModuleItem) {
                IModule module = ((IModuleItem)item).getModule(stack);
                if (module instanceof IRocketEngine) {
                    if (this.rocketEngine == null) {
                        this.rocketEngine = stack.func_77946_l();
                        this.rocketEngine.field_77994_a = 1;
                        --stack.field_77994_a;
                        added = true;
                    }
                } else if (module instanceof IWarhead) {
                    if (this.warhead == null) {
                        this.warhead = stack.func_77946_l();
                        this.warhead.field_77994_a = 1;
                        --stack.field_77994_a;
                        added = true;
                    }
                } else if (module instanceof IGuidance && this.rocketComputer == null) {
                    this.rocketComputer = stack.func_77946_l();
                    this.rocketComputer.field_77994_a = 1;
                    --stack.field_77994_a;
                    added = true;
                }
                if (this.rocketComputer != null && this.rocketEngine != null) {
                    this.gutsCompleted = true;
                }
                return added;
            }
        }
        return false;
    }

    protected void addItems(String oreName, int count) {
        int tempR = count;
        ItemStack oreStack = null;
        ArrayList items = OreDictionary.getOres((String)oreName);
        if (items != null) {
            for (ItemStack s : items) {
                if (s == null) continue;
                oreStack = s.func_77946_l();
            }
        }
        while (tempR > 0) {
            ItemStack stack = oreStack.func_77946_l();
            stack.field_77994_a = Math.min(tempR, oreStack.func_77976_d());
            tempR -= stack.field_77994_a;
            if (stack.field_77994_a <= 0) continue;
            this.addItem(stack);
        }
    }

    protected void storeItem(ItemStack stack, int added) {
        ItemStack stackAdd = stack.func_77946_l();
        stackAdd.field_77994_a = added;
        if (stackAdd.field_77994_a > 0) {
            for (ItemStack item : this.itemsUsed) {
                int room = item.func_77976_d() - item.field_77994_a;
                if (room <= 0 || !InventoryUtility.stacksMatch((ItemStack)item, (ItemStack)stackAdd)) continue;
                item.field_77994_a += Math.min(room, stackAdd.field_77994_a);
                stackAdd.field_77994_a -= Math.min(room, stackAdd.field_77994_a);
                if (stackAdd.field_77994_a > 0) continue;
                stackAdd = null;
                break;
            }
            if (stackAdd != null && stackAdd.field_77994_a > 0) {
                this.itemsUsed.add(stackAdd);
            }
        }
    }

    protected int addRods(int count) {
        if (!this.frameCompleted) {
            int addition = Math.min(count, Math.max(128 - this.rodsContained, 0));
            if (addition > 0) {
                this.rodsContained += addition;
                this.frameLevel = this.rodsContained / 16;
                if (this.rodsContained >= 128) {
                    this.frameCompleted = true;
                }
            }
            return addition;
        }
        return 0;
    }

    protected int addPlates(int count) {
        if (!this.skinCompleted) {
            int addition = Math.min(count, Math.max(36 - this.platesContained, 0));
            if (addition > 0) {
                this.platesContained += addition;
                this.plateLevel = this.platesContained / 4;
                if (this.platesContained >= 36) {
                    this.skinCompleted = true;
                }
            }
            return addition;
        }
        return 0;
    }

    public boolean isFinished() {
        return this.skinCompleted && this.frameCompleted && this.gutsCompleted;
    }

    public ItemStack getMissileAsItem() {
        Missile missile = this.getMissile();
        if (missile != null) {
            return missile.toStack();
        }
        return null;
    }

    public Missile getMissile() {
        Missile missile = new Missile(MissileSize.STANDARD.getDefaultMissileCasing());
        if (this.warhead != null) {
            missile.setWarhead(MissileModuleBuilder.INSTANCE.buildWarhead(this.warhead));
            if (missile.getWarhead() == null) {
                return null;
            }
        }
        if (this.rocketEngine != null) {
            missile.setEngine(MissileModuleBuilder.INSTANCE.buildEngine(this.rocketEngine));
            if (missile.getEngine() == null) {
                return null;
            }
        }
        if (this.rocketComputer != null) {
            missile.setGuidance(MissileModuleBuilder.INSTANCE.buildGuidance(this.rocketComputer));
            if (missile.getGuidance() == null) {
                return null;
            }
        }
        return missile;
    }

    public void load(NBTTagCompound nbt) {
        int rods = nbt.func_74762_e("rodsContained");
        int plates = nbt.func_74762_e("platesContained");
        if (rods > 0) {
            this.addRods(rods);
        }
        if (plates > 0) {
            this.addPlates(plates);
        }
        if (nbt.func_74764_b("rocketComputer")) {
            this.rocketComputer = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("rocketComputer"));
            if (this.rocketComputer != null && !(this.rocketComputer.func_77973_b() instanceof IModuleItem)) {
                System.out.println("Error loading standard missile recipe progress. Guidance item is invalid, this will cause issues when constructing the missile.");
            }
        }
        if (nbt.func_74764_b("rocketEngine")) {
            this.rocketEngine = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("rocketEngine"));
            if (this.rocketEngine != null && !(this.rocketEngine.func_77973_b() instanceof IModuleItem)) {
                System.out.println("Error loading standard missile recipe progress. Engine item is invalid, this will cause issues when constructing the missile.");
            }
        }
        if (nbt.func_74764_b("warhead")) {
            this.warhead = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("rocketEngine"));
            if (this.warhead != null && !(this.warhead.func_77973_b() instanceof IModuleItem)) {
                System.out.println("Error loading standard missile recipe progress. Warhead item is invalid, this will cause issues when constructing the missile.");
            }
        }
        if (nbt.func_150297_b("itemsUsed", 10)) {
            this.itemsUsed.clear();
            NBTTagList list = nbt.func_150295_c("itemsUsed", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                if (stack != null) {
                    this.itemsUsed.add(stack);
                    continue;
                }
                Engine.error((String)("Failed to load ItemStack from nbt for " + this + "\n" + list.func_150307_f(i)));
            }
        } else {
            if (rods > 0) {
                this.addItems("rodIron", rods);
            }
            if (plates > 0) {
                this.addItems("plateIron", plates);
            }
        }
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagCompound cTag;
        nbt.func_74768_a("rodsContained", this.rodsContained);
        nbt.func_74768_a("platesContained", this.platesContained);
        if (this.rocketComputer != null) {
            cTag = new NBTTagCompound();
            this.rocketComputer.func_77955_b(cTag);
            nbt.func_74782_a("rocketComputer", (NBTBase)cTag);
        }
        if (this.rocketEngine != null) {
            cTag = new NBTTagCompound();
            this.rocketEngine.func_77955_b(cTag);
            nbt.func_74782_a("rocketEngine", (NBTBase)cTag);
        }
        if (this.warhead != null) {
            cTag = new NBTTagCompound();
            this.warhead.func_77955_b(cTag);
            nbt.func_74782_a("warhead", (NBTBase)cTag);
        }
        if (this.rocketComputer != null && this.rocketEngine != null) {
            this.gutsCompleted = true;
        }
        if (this.itemsUsed != null && !this.itemsUsed.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.itemsUsed) {
                list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("itemsUsed", (NBTBase)list);
        }
        return nbt;
    }

    public StandardMissileCrafting readBytes(ByteBuf buf) {
        this.clear();
        this.addRods(buf.readInt());
        this.addPlates(buf.readInt());
        ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        if (stack.func_77973_b() instanceof IModuleItem) {
            this.warhead = stack;
        }
        if ((stack = ByteBufUtils.readItemStack((ByteBuf)buf)).func_77973_b() instanceof IModuleItem) {
            this.rocketComputer = stack;
        }
        if ((stack = ByteBufUtils.readItemStack((ByteBuf)buf)).func_77973_b() instanceof IModuleItem) {
            this.rocketEngine = stack;
        }
        return this;
    }

    public ByteBuf writeBytes(ByteBuf buf) {
        buf.writeInt(this.rodsContained);
        buf.writeInt(this.platesContained);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)(this.warhead != null ? this.warhead : new ItemStack(Blocks.field_150348_b)));
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)(this.rocketComputer != null ? this.rocketComputer : new ItemStack(Blocks.field_150348_b)));
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)(this.rocketEngine != null ? this.rocketEngine : new ItemStack(Blocks.field_150348_b)));
        return buf;
    }

    public void dropItems(Location location) {
        if (this.rocketEngine != null) {
            InventoryUtility.dropItemStack((IWorldPosition)location, (ItemStack)this.rocketEngine);
            this.rocketEngine = null;
        }
        if (this.rocketComputer != null) {
            InventoryUtility.dropItemStack((IWorldPosition)location, (ItemStack)this.rocketComputer);
            this.rocketComputer = null;
        }
        if (this.warhead != null) {
            InventoryUtility.dropItemStack((IWorldPosition)location, (ItemStack)this.warhead);
            this.warhead = null;
        }
        if (this.itemsUsed != null & !this.itemsUsed.isEmpty()) {
            Iterator<ItemStack> it = this.itemsUsed.iterator();
            while (it.hasNext()) {
                ItemStack stack = it.next();
                if (stack != null && stack.field_77994_a > 0) {
                    InventoryUtility.dropItemStack((IWorldPosition)location, (ItemStack)stack);
                }
                it.remove();
            }
        }
        this.clear();
    }

    protected void clear() {
        this.rodsContained = 0;
        this.platesContained = 0;
        this.frameCompleted = false;
        this.skinCompleted = false;
        this.gutsCompleted = false;
        this.frameLevel = 0;
        this.plateLevel = 0;
    }
}

