/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.launcher;

import com.builtbroken.icbm.api.crafting.IModularMissileItem;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.block.LauncherPartListener;
import com.builtbroken.icbm.content.launcher.launcher.StandardMissileCrafting;
import com.builtbroken.icbm.content.missile.data.missile.Missile;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.tile.access.IRotation;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.block.imp.IActivationListener;
import com.builtbroken.mc.framework.block.imp.IBlockStackListener;
import com.builtbroken.mc.framework.block.imp.IWrenchListener;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileStandardLauncher
extends TileAbstractLauncher
implements IRotation,
IWrenchListener,
IActivationListener,
IBlockStackListener {
    protected boolean isCrafting = false;
    protected boolean buildMissileBlocks = false;
    protected boolean destroyMissileBlocks = false;
    protected StandardMissileCrafting recipe;
    private ForgeDirection dir_cache;
    private int frameUpdateCheckTick = 1;
    public MissileSize missileSize = MissileSize.STANDARD;

    public TileStandardLauncher() {
        super("launcher.standard", "icbm");
    }

    public ItemStack toStack() {
        Block blockDrop = InventoryUtility.getBlock((String)"icbm:icbmLauncherParts");
        if (blockDrop != null) {
            return new ItemStack(blockDrop, 1, 0);
        }
        return null;
    }

    public String uniqueContentID() {
        return "launcher." + this.missileSize.name().toLowerCase();
    }

    @Override
    public void firstTick() {
        super.firstTick();
        this.frameUpdateCheckTick = 10 + (int)(30.0 * Math.random());
        if (this.isCrafting || this.getMissileItem() != null) {
            this.buildMissileBlocks = true;
        }
    }

    @Override
    public void update(long ticks) {
        super.update(ticks);
        if (this.isServer()) {
            if (ticks == 1L || ticks % 20L == 0L) {
                if (this.buildMissileBlocks) {
                    this.buildMissileBlocks = false;
                    MultiBlockHelper.buildMultiBlock((World)((World)this.world().unwrap()), (IMultiTileHost)((IMultiTileHost)this.getHost()), (boolean)true, (boolean)true);
                } else if (this.destroyMissileBlocks) {
                    this.destroyMissileBlocks = false;
                    MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)((IMultiTileHost)this.getHost()), (boolean)false, (boolean)true, (boolean)false);
                }
            }
            if (ticks % (long)this.frameUpdateCheckTick == 0L) {
                int count = LauncherPartListener.getFrameCount((World)this.world().unwrap(), new BlockPos((IPos3D)this).add(0, 1, 0));
                MissileSize size = LauncherPartListener.getLauncherSize(count);
                if (size != this.missileSize) {
                    this.dropItems();
                    Block blockDrop = InventoryUtility.getBlock((String)"icbm:icbmLauncherParts");
                    if (blockDrop != null) {
                        ((World)this.world().unwrap()).func_147468_f(this.xi(), this.yi(), this.zi());
                        ((World)this.world().unwrap()).func_147449_b(this.xi(), this.yi(), this.zi(), blockDrop);
                    }
                } else {
                    int dMeta;
                    int meta = ((World)this.world().unwrap()).func_72805_g(this.xi(), this.yi() + count, this.zi());
                    if (meta != (dMeta = TileStandardLauncher.getMetaForDirection(this.getDirection()))) {
                        ((World)this.world().unwrap()).func_72921_c(this.xi(), this.yi() + count, this.zi(), dMeta, 3);
                    }
                }
            }
        }
    }

    private static int getMetaForDirection(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 4;
            }
        }
        return 0;
    }

    public boolean onPlayerRightClickWrench(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.recipe != null && this.isServer()) {
            if (this.recipe.isFinished()) {
                ItemStack stack = this.recipe.getMissileAsItem();
                if (stack != null) {
                    this.disableCraftingMode();
                    this.getInventory().func_70299_a(0, stack);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error missile stack is null"));
                }
            } else {
                player.func_146105_b(this.recipe.getCurrentRecipeChat());
            }
        }
        return true;
    }

    @Override
    public boolean onPlayerActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y && Engine.runningAsDev) {
            if (this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Missile: " + this.getMissile()));
            }
            return true;
        }
        if (this.getMissile() == null) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IModularMissileItem) {
                if (this.isServer()) {
                    IMissile missile = ((IModularMissileItem)player.func_70694_bm().func_77973_b()).toMissile(player.func_70694_bm());
                    if (missile != null) {
                        if (this.canAcceptMissile(missile)) {
                            ItemStack copy = player.func_70694_bm().func_77946_l();
                            copy.field_77994_a = 1;
                            this.getInventory().func_70299_a(0, copy);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --player.func_70694_bm().field_77994_a;
                                if (player.func_70694_bm().field_77994_a <= 0) {
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                                }
                                player.field_71069_bz.func_75142_b();
                            }
                            player.func_146105_b((IChatComponent)new ChatComponentText("* Missile added *"));
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Invalid missile size or type"));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Invalid missile item"));
                    }
                }
                return true;
            }
            if (this.missileSize == MissileSize.STANDARD && StandardMissileCrafting.isPartOfRecipe(player.func_70694_bm())) {
                ItemStack heldItem;
                if (this.recipe == null) {
                    this.triggerCraftingMode();
                    this.recipe = new StandardMissileCrafting();
                    player.func_146105_b((IChatComponent)new ChatComponentText("Starting crafting for new missile"));
                }
                if ((heldItem = player.func_70694_bm()) != null) {
                    if (this.isServer()) {
                        if (this.recipe.canAddItem(heldItem = heldItem.func_77946_l())) {
                            if (!this.recipe.addItem(heldItem)) {
                                if (!this.recipe.isFinished()) {
                                    player.func_146105_b((IChatComponent)new ChatComponentText("Odd that should fit..."));
                                } else {
                                    player.func_146105_b((IChatComponent)new ChatComponentText("Recipe finished, click with wrench or screwdriver."));
                                }
                            } else if (!InventoryUtility.stacksMatchExact((ItemStack)player.func_70694_bm(), (ItemStack)heldItem)) {
                                if (heldItem.field_77994_a <= 0) {
                                    heldItem = null;
                                }
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldItem);
                                player.field_71069_bz.func_75142_b();
                                this.sendDescPacket();
                            }
                        } else {
                            player.func_146105_b(this.recipe.getCurrentRecipeChat());
                        }
                        return true;
                    }
                    if (Block.func_149634_a((Item)player.func_70694_bm().func_77973_b()) == null) {
                        if (this.isServer()) {
                            player.func_146105_b(this.recipe.getCurrentRecipeChat());
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public ForgeDirection getDirection() {
        if (this.dir_cache == null) {
            this.dir_cache = ForgeDirection.getOrientation((int)this.host.getHostMeta());
        }
        return this.dir_cache;
    }

    @Override
    public Pos getMissileLaunchOffset() {
        switch (this.missileSize) {
            case MICRO: {
                return (Pos)new Pos(this.getDirection()).add(0.0, 3.0, 0.0);
            }
            case SMALL: {
                return (Pos)new Pos(this.getDirection()).add(0.0, 5.0, 0.0);
            }
            case STANDARD: {
                return (Pos)new Pos(this.getDirection()).add(0.0, 7.0, 0.0);
            }
            case MEDIUM: {
                return (Pos)((Pos)new Pos(this.getDirection()).multiply(2.0)).add(0.0, 19.0, 0.0);
            }
        }
        return (Pos)new Pos(this.getDirection()).add(0.0, 20.0, 0.0);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack stackPrev, ItemStack newStack) {
        if (slot == 0 && this.isServer()) {
            if (this.isCrafting && this.recipe != null) {
                this.recipe.dropItems((Location)this.toLocation().add((IPos3D)this.getMissileLaunchOffset()));
            } else if (!InventoryUtility.stacksMatch((ItemStack)stackPrev, (ItemStack)newStack)) {
                this.sendDescPacket();
            }
            if (this.getMissileItem() != null) {
                this.buildMissileBlocks = true;
                this.destroyMissileBlocks = false;
                this.disableCraftingMode();
            } else {
                this.buildMissileBlocks = false;
                this.destroyMissileBlocks = true;
            }
        }
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        return super.read(buf, id, player, type);
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        buf.writeByte(this.missileSize.ordinal());
        if (this.getMissileItem() != null) {
            buf.writeByte(0);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getMissileItem());
        } else if (this.isCrafting) {
            if (this.recipe != null) {
                buf.writeByte(1);
                this.recipe.writeBytes(buf);
            } else {
                buf.writeByte(2);
            }
        } else {
            buf.writeByte(3);
        }
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        this.missileSize = MissileSize.get(buf.readByte());
        byte type = buf.readByte();
        if (type == 0) {
            ItemStack missileStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.missile = missileStack.func_77973_b() instanceof IMissileItem ? ((IMissileItem)missileStack.func_77973_b()).toMissile(missileStack) : new Missile(missileStack);
        } else if (type == 1) {
            this.missile = null;
            if (this.recipe == null) {
                this.recipe = new StandardMissileCrafting();
            }
            this.recipe.readBytes(buf);
        } else if (type == 2 || type == 3) {
            this.missile = null;
            this.recipe = null;
            this.isCrafting = false;
        }
    }

    @Override
    protected void onPostMissileFired(Pos target, EntityMissile entity) {
        super.onPostMissileFired(target, entity);
        this.destroyMissileBlocks = true;
        if (entity.getMissile() != null && entity.getMissile().getEngine() != null && entity.getMissile().getEngine().generatesFire(entity, entity.getMissile())) {
            Location center = (Location)this.toLocation().add(this.getDirection());
            for (int x = -1; x < 2; ++x) {
                block1: for (int z = -1; z < 2; ++z) {
                    if (!(((World)this.world().unwrap()).field_73012_v.nextFloat() < 0.3f)) continue;
                    Location pos = (Location)center.add((double)x, 0.0, (double)z);
                    if (pos.isAirBlock()) {
                        if (((Location)pos.sub(0.0, 1.0, 0.0)).isSideSolid(ForgeDirection.UP)) {
                            pos.setBlock((Block)Blocks.field_150480_ab);
                            continue;
                        }
                        for (int i = 0; i < 3; ++i) {
                            Location posBellow = (Location)pos.add(0.0, (double)(-i), 0.0);
                            if (!posBellow.isAirBlock() || !((Location)posBellow.sub(0.0, 1.0, 0.0)).isSideSolid(ForgeDirection.UP)) continue;
                            posBellow.setBlock((Block)Blocks.field_150480_ab);
                            continue block1;
                        }
                        continue;
                    }
                    Location posBellow = center;
                    for (int i = 0; i < 3; ++i) {
                        Location posUp = (Location)pos.add(0.0, (double)i, 0.0);
                        if (posUp.isAirBlock()) {
                            if (!posBellow.isSideSolid(ForgeDirection.UP)) continue block1;
                            posUp.setBlock((Block)Blocks.field_150480_ab);
                        }
                        posBellow = posUp;
                    }
                }
            }
        }
    }

    @Override
    public boolean canFireMissile() {
        return !this.isCrafting;
    }

    @Override
    public boolean canAcceptMissile(IMissile missile) {
        return super.canAcceptMissile(missile) && missile.getMissileSize() == this.missileSize.ordinal();
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("missileRecipe")) {
            this.triggerCraftingMode();
            this.recipe = new StandardMissileCrafting();
            this.recipe.load(nbt.func_74775_l("missileRecipe"));
        }
        if (nbt.func_74764_b("missileSize")) {
            this.missileSize = MissileSize.get(nbt.func_74762_e("missileSize"));
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.recipe != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.recipe.save(nbt);
            nbt.func_74782_a("missileRecipe", (NBTBase)tag);
        }
        nbt.func_74768_a("missileSize", this.missileSize.ordinal());
        return nbt;
    }

    protected void triggerCraftingMode() {
        this.isCrafting = true;
        this.buildMissileBlocks = true;
    }

    protected void disableCraftingMode() {
        this.isCrafting = false;
        this.recipe = null;
        if (this.getMissileItem() == null) {
            this.destroyMissileBlocks = true;
            this.buildMissileBlocks = false;
        }
    }

    protected final void dropItems() {
        if (this.getMissileItem() != null) {
            InventoryUtility.dropItemStack((IWorldPosition)this.toLocation(), (ItemStack)this.getMissileItem());
            this.getInventory().func_70299_a(0, null);
        }
        if (this.recipe != null) {
            this.recipe.dropItems(this.toLocation());
            this.recipe = null;
        }
    }
}

