/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.listeners;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.launcher.TileMissileContainer;
import com.builtbroken.icbm.content.missile.client.RenderMissile;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import com.builtbroken.mc.seven.framework.block.listeners.client.ITileRenderListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class TileMissileRenderListener
extends TileListener
implements IBlockListener,
ITileRenderListener {
    @JsonProcessorData(value={"renderOffset"}, type="pos")
    public Pos offset = Pos.zero;
    @JsonProcessorData(value={"renderRotation"}, type="eulerAngle")
    public EulerAngle rotation = new EulerAngle(0.0, 0.0, 0.0);

    public void renderDynamic(TileEntity tile, double xx, double yy, double zz, float f) {
        IMissile missile;
        ITileNode node;
        ITileNode iTileNode = node = tile instanceof ITileNodeHost ? ((ITileNodeHost)tile).getTileNode() : null;
        if (node instanceof TileMissileContainer && (missile = ((TileMissileContainer)node).getMissile()) != null) {
            GL11.glPushMatrix();
            try {
                double h = missile.getHeight() / 2.0;
                GL11.glTranslated((double)(xx + this.offset.x()), (double)(yy + this.offset.y() + h), (double)(zz + this.offset.z()));
                RenderMissile.renderMissile(missile, 0.0f, 90.0f, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            GL11.glPopMatrix();
        }
    }

    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("tilerender");
        return list;
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        public ITileEventListener createListener(Block block) {
            return new TileMissileRenderListener();
        }

        public String getListenerKey() {
            return "missileRender";
        }
    }
}

