/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.client;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IModelState;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMissile
extends Render {
    public static final RenderMissile INSTANCE = new RenderMissile(0.5f);
    public static final String[] RENDER_KEYS = new String[]{"missile", "entity"};

    private RenderMissile(float f) {
        this.field_76989_e = f;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        EntityMissile entityMissile = (EntityMissile)entity;
        IMissile missile = entityMissile.getMissile();
        double height = ((EntityMissile)entity).field_70121_D.field_72337_e - ((EntityMissile)entity).field_70121_D.field_72338_b;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)(y + height / 2.0), (double)z);
        float pitch = RenderMissile.interpolateRotation(entity.field_70127_C, entity.field_70125_A, f1);
        float yaw = RenderMissile.interpolateRotation(entity.field_70126_B, entity.field_70177_z, f1);
        RenderMissile.renderMissile(missile, yaw, pitch, RENDER_KEYS);
        GL11.glPopMatrix();
    }

    public static void renderMissile(IMissile missile, float yaw, float pitch, String[] keys) {
        if (!RenderMissile.renderStatesFor(missile, yaw, pitch, keys != null ? keys : RENDER_KEYS)) {
            GL11.glRotatef((float)(yaw + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(pitch - 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.CLASSIC_MISSILE_TEXTURE);
            if (missile == null || missile.getWarhead() != null) {
                Assets.CLASSIC_MISSILE_MODEL.renderOnly(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
            }
            Assets.CLASSIC_MISSILE_MODEL.renderAllExcept(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
        }
    }

    protected static boolean renderStatesFor(Object object, float yaw, float pitch, String ... keys) {
        RenderData data;
        if (object instanceof IJsonGenObject && keys != null && (data = ClientDataHandler.INSTANCE.getRenderData(((IJsonGenObject)object).getContentID())) != null) {
            for (String stateID : keys) {
                IRenderState state = data.getState(stateID);
                if (!(state instanceof IModelState) || !((IModelState)state).render(false, yaw, pitch, 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public static float interpolateRotation(float prev, float rotation, float f) {
        float f3;
        for (f3 = rotation - prev; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return prev + f * f3;
    }
}

