/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.data.casing;

import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.mc.api.IModObject;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.builtbroken.mc.imp.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;

public class MissileCasingData
extends JsonGenData
implements IJsonGenObject,
IModObject {
    public final String ID;
    private int width;
    private int height;
    private int mass;
    private int size = -1;
    private Pos centerOffset = Pos.zero;
    private float health;
    public final List<String> textureNames = new ArrayList<String>();

    public MissileCasingData(IJsonProcessor processor, String ID) {
        super(processor);
        this.ID = ID;
        super.onCreated();
    }

    public void onCreated() {
        if (this.size >= 0 && this.size < MissileSize.values().length) {
            if (MissileSize.values()[this.size].casingDataMap.containsKey(this.ID)) {
                throw new IllegalArgumentException("Duplicate ID found for " + this.ID);
            }
            MissileSize.values()[this.size].casingDataMap.put(this.ID, this);
        }
    }

    public String getContentID() {
        return this.contentType() + "." + this.uniqueContentID();
    }

    public String getUniqueID() {
        return this.ID;
    }

    public String toString() {
        return "MissileCasingData[" + this.getContentID() + "]";
    }

    public String uniqueContentID() {
        return this.ID;
    }

    public String contentType() {
        return "missile";
    }

    public String getMod() {
        return "icbm";
    }

    public int getWidth() {
        return this.width;
    }

    @JsonProcessorData(value={"bodyWidth"}, type="int")
    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    @JsonProcessorData(value={"bodyHeight"}, type="int")
    public void setHeight(int height) {
        this.height = height;
    }

    public int getMass() {
        return this.mass;
    }

    @JsonProcessorData(value={"bodyMass"}, type="int")
    public void setMass(int mass) {
        this.mass = mass;
    }

    public int getMissileBodySize() {
        return this.size;
    }

    @JsonProcessorData(value={"bodySizeClassification"})
    public void setMissileBodySize(String size) {
        for (MissileSize missileSize : MissileSize.values()) {
            if (!missileSize.name().equalsIgnoreCase(size)) continue;
            this.setMissileBodySize(missileSize.ordinal());
        }
        if (this.size == -1) {
            throw new IllegalArgumentException("Failed to read in missile size for value '" + size + "'");
        }
    }

    @JsonProcessorData(value={"bodySizeNumber"}, type="int")
    public void setMissileBodySize(int size) {
        this.size = size;
        if (size < 0 || size >= MissileSize.values().length) {
            throw new IllegalArgumentException("Size '" + size + "' is outside the range of valid sizes.");
        }
    }

    public Pos getCenterOffset() {
        return this.centerOffset;
    }

    @JsonProcessorData(value={"bodyCenterOffset"}, type="pos")
    public void setCenterOffset(Pos centerOffset) {
        this.centerOffset = centerOffset;
    }

    public float getHealth() {
        return this.health;
    }

    @JsonProcessorData(value={"bodyHealth"}, type="float")
    public void setHealth(float health) {
        this.health = health;
    }
}

